##############################################################################
#
# Copyright (c) 2004 TINY SPRL. (http://tiny.be) All Rights Reserved.
#                    Fabien Pinckaers <fp@tiny.Be>
#
# WARNING: This program as such is intended to be used by professional
# programmers who take the whole responsability of assessing all potential
# consequences resulting from its eventual inadequacies and bugs
# End users who are looking for a ready-to-use solution with commercial
# garantees and support are strongly adviced to contract a Free Software
# Service Company
#
# This program is Free Software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
#
##############################################################################

import gtk
from gtk import glade
import gobject
import gettext
import common

import rpc

import csv, StringIO

#
# TODO: make it works with references
#
def import_csv(fname, f, model, fields):
	content = file(fname,'rb').read()
	input=StringIO.StringIO(content)
	reader = csv.reader(input)
	references = {}
	dics = []
	for row in reader:
		dic={}
		for i in range(len(f)):
			if fields[f[i]]['type']=='integer':
				dic[f[i]]=row[i] and int(row[i])
			elif fields[f[i]]['type']=='float':
				dic[f[i]]=row[i] and float(row[i])
			elif fields[f[i]]['type']=='many2one':
				print fields[f[i]]
				dic[f[i]]=False
				if row[i]:
					res = rpc.session.rpc_exec_auth('/object', 'execute', fields[f[i]]['relation'], 'name_search', row[i], [])
					if len(res):
						dic[f[i]]=res[0][0]
					else:
						common.message(_('Import Error !\nFields: "%s" does not exists !') % (row[i],))
						return False
			else:
				dic[f[i]]=str(row[i])
		dics.append(dic)
	for dic in dics:
		rpc.session.rpc_exec_auth('/object', 'execute', model, 'create', dic)
	common.message(_('Import Done'))
	return True

class win_import(object):
	def __init__(self, model, fields, preload = []):
		self.glade = glade.XML(common.terp_path("terp.glade"),'win_import',gettext.textdomain())
		self.win = self.glade.get_widget('win_import')
		self.model = model
		self.fields_data = {}

		self.view1 = gtk.TreeView()
		self.view1.get_selection().set_mode(gtk.SELECTION_MULTIPLE)
		self.glade.get_widget('imp_vp1').add(self.view1)
		self.view2 = gtk.TreeView()
		self.view2.get_selection().set_mode(gtk.SELECTION_MULTIPLE)
		self.glade.get_widget('imp_vp2').add(self.view2)
		self.view1.set_headers_visible(False)
		self.view2.set_headers_visible(False)

		cell = gtk.CellRendererText()
		column = gtk.TreeViewColumn(_('Field name'), cell, text=0)
		self.view1.append_column(column)

		cell = gtk.CellRendererText()
		column = gtk.TreeViewColumn(_('Field name'), cell, text=0)
		self.view2.append_column(column)

		self.model1 = gtk.ListStore(gobject.TYPE_STRING, gobject.TYPE_STRING)
		self.model2 = gtk.ListStore(gobject.TYPE_STRING, gobject.TYPE_STRING)

		for f in preload:
			self.model2.set(self.model2.append(), 0, f[1], 1, f[0])

		self.fields = fields
		for f in fields:
			if fields[f]['type'] not in ('one2many','many2many','reference'):
				self.model1.set(self.model1.append(), 1, f, 0, fields[f].get('string', 'unknown'))

		self.view1.set_model(self.model1)
		self.view2.set_model(self.model2)
		self.view1.show_all()
		self.view2.show_all()

		self.glade.signal_connect('on_but_unselect_all_clicked', self.sig_unsel_all)
		self.glade.signal_connect('on_but_select_all_clicked', self.sig_sel_all)
		self.glade.signal_connect('on_but_select_clicked', self.sig_sel)
		self.glade.signal_connect('on_but_unselect_clicked', self.sig_unsel)

	def sig_sel_all(self, widget=None):
		self.model2.clear()
		for field in self.fields.keys():
			self.model2.set(self.model2.append(), 0, self.fields[field], 1, field)

	def sig_sel(self, widget=None):
		sel = self.view1.get_selection()
		sel.selected_foreach(self._sig_sel_add)

	def _sig_sel_add(self, store, path, iter):
		num = self.model2.append()
		self.model2.set(num, 0, store.get_value(iter,0), 1, store.get_value(iter,1))

	def sig_unsel(self, widget=None):
		def _sig_sel_del(store, path, iter):
			store.remove(iter)
		(store,paths) = self.view2.get_selection().get_selected_rows()
		for p in paths:
			store.remove(store.get_iter(p))

	def sig_unsel_all(self, widget=None):
		self.model2.clear()

	def go(self):
		button = self.win.run()
		if button==gtk.RESPONSE_OK:
			fields = []
			fields2 = []
			iter = self.model2.get_iter_root()
			while iter:
				fields.append(self.model2.get_value(iter, 1))
				fields2.append(self.model2.get_value(iter, 0))
				iter = self.model2.iter_next(iter)
			self.win.destroy()

			fname = common.file_selection(_('Import CSV File'))
			if fname:
				return import_csv(fname, fields, self.model, self.fields)
			return False
		else:
			self.win.destroy()
			return False

