/**
 * Copyright (C) 2007-2013 Lawrence Murray
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the Free
 * Software Foundation; either version 2 of the License, or (at your option)
 * any later version.
 * 
 * @author Lawrence Murray <lawrence@indii.org>
 * $Rev: 510 $
 * $Date: 2013-09-28 00:09:30 +0800 (Sat, 28 Sep 2013) $
 */
#ifndef INDII_TINT_GUI_TINTDOCUMENT_HPP
#define INDII_TINT_GUI_TINTDOCUMENT_HPP

#include "../model/ClusterModel.hpp"
#include "../../gui/Document.hpp"

#include "wx/aui/aui.h"

namespace indii {
/**
 * Image document.
 */
class TintDocument : public Document {
public:
  /**
   * Constructor.
   *
   * @param parent Parent.
   * @param res Image resource.
   * @param model Cluster model.
   */
  TintDocument(wxWindow* parent, ImageResource* res, ClusterModel* model);
  
  /**
   * Constructor.
   *
   * @param parent Parent.
   * @param path Path of image to open.
   */
  TintDocument(wxWindow* parent, const wxString& path);
  
  /**
   * Destructor.
   */
  virtual ~TintDocument();
  
protected:
  /**
   * Image resource.
   */
  ImageResource* res;

  /**
   * Cluster model.
   */
  ClusterModel* model;

private:
  /**
   * Do we own the model and image resource?
   */
  bool own;

  DECLARE_EVENT_TABLE()
};
}

#endif
