/**
 * Copyright (C) 2007-2013 Lawrence Murray
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the Free
 * Software Foundation; either version 2 of the License, or (at your option)
 * any later version.
 * 
 * @author Lawrence Murray <lawrence@indii.org>
 * $Rev: 500 $
 * $Date: 2013-08-16 19:04:13 +0800 (Fri, 16 Aug 2013) $
 */
#include "TintDocument.hpp"

#include "../../image/FileImageResource.hpp"

using namespace indii;

TintDocument::TintDocument(wxWindow* parent, ImageResource* res,
    ClusterModel* model) : Document(parent, res, model), res(res),
    model(model), own(false) {
  model->setForDialog();
}

TintDocument::TintDocument(wxWindow* parent, const wxString& path) :
    Document(parent), own(true) {
  res = new FileImageResource(path);
  model = new ClusterModel(res);

  model->prepare();
  model->cluster();
  model->lock();

  model->unlock();
  watch(model);

  set(res, model);
}

TintDocument::~TintDocument() {
  if (own) {
    delete model;
    delete res;
  }
}

BEGIN_EVENT_TABLE(TintDocument, Document)
END_EVENT_TABLE()
