/**
 * Copyright (C) 2007-2013 Lawrence Murray
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the Free
 * Software Foundation; either version 2 of the License, or (at your option)
 * any later version.
 * 
 * @author Lawrence Murray <lawrence@indii.org>
 * $Rev: 500 $
 * $Date: 2013-08-16 19:04:13 +0800 (Fri, 16 Aug 2013) $
 */
#ifndef INDII_TINT_GUI_THUMBPANE_HPP
#define INDII_TINT_GUI_THUMBPANE_HPP

#include "ThumbHSL.hpp"
#include "../model/ClusterModel.hpp"
#include "../model/ClusterModelObserver.hpp"
#include "../../image/ImageResource.hpp"
#include "../../gui/Pane.hpp"

#include "wx/scrolwin.h"
#include "wx/panel.h"
#include "wx/button.h"
#include "wx/bmpbuttn.h"

#include <vector>

namespace indii {
/**
 * Preview pane.
 */
class ThumbPane : public wxScrolledWindow, public ClusterModelObserver {
public:
  /**
   * Constructor.
   *
   * @param parent Parent.
   */
  ThumbPane(wxWindow* parent);

  /**
   * Set model.
   *
   * @param model Model.
   */
  void setModel(ClusterModel* model);

  /**
   * Add button event.
   */
  void OnButtonAdd(wxCommandEvent& evt);
  
  /**
   * Subtract button event.
   */
  void OnButtonSub(wxCommandEvent& evt);
  
  /**
   * Handle resize event.
   */
  void OnSize(wxSizeEvent& evt);

  /**
   * Context sensitive help.
   */
  void OnHelp(wxHelpEvent& evt);
  
  /**
   * Handle number of clusters change.
   */
  virtual void notifyNumClustersChange();

private:
  /**
   * Update layout.
   */
  void updateLayout();

  /**
   * Cluster model.
   */
  ClusterModel* model;
  
  /**
   * Thumbnails.
   */
  std::vector<ThumbHSL*> thumbs;

  /*
   * Controls
   */
	#ifdef __WXMSW__
    wxButton *butAdd, *butSub;
	#else
    wxBitmapButton *butAdd, *butSub;
	#endif

  /*
   * Control ids.
   */
  enum ID {
    ID_BUT_ADD,
    ID_BUT_SUB
  };
  
  DECLARE_EVENT_TABLE()
};
}

#endif

