/**
 * Copyright (C) 2007-2013 Lawrence Murray
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the Free
 * Software Foundation; either version 2 of the License, or (at your option)
 * any later version.
 * 
 * @author Lawrence Murray <lawrence@indii.org>
 * $Rev: 512 $
 * $Date: 2013-09-29 15:03:45 +0800 (Sun, 29 Sep 2013) $
 */
#ifndef INDII_TINT_GUI_THUMBHSL_HPP
#define INDII_TINT_GUI_THUMBHSL_HPP

#include "ThumbImage.hpp"
#include "SpectrumImage.hpp"
#include "../../image/ImageResource.hpp"
#include "../model/ClusterModel.hpp"
#include "../model/ClusterModelObserver.hpp"

#include "wx/panel.h"
#include "wx/slider.h"

namespace indii {
/**
 * Thumbnail with Hue-Saturation-Luminance sliders.
 */
class ThumbHSL : public wxPanel, public ClusterModelObserver {
public:
  /**
   * Constructor.
   *
   * @param parent Parent window.
   * @param cluster Cluster number to which this thumbnail pertains.
   */
  ThumbHSL(wxWindow *parent, const unsigned int cluster);

  /**
   * Set model.
   *
   * @param model Model.
   */
  void setModel(ClusterModel* model);

  /*
   * Handle model changes.
   */
  virtual void notifyNumClustersChange();
  virtual void notifySaturationDecayChange();
  virtual void notifySaturationSoftnessChange();
  virtual void notifyClusterChange(const unsigned int i);  
  virtual void notifyHueChange(const unsigned i);
  virtual void notifySatChange(const unsigned i);
  virtual void notifyLightChange(const unsigned i);
  virtual void notifyAlphaChange(const unsigned i);
  
  /*
   * Slider control events.
   */
  void OnSlideH(wxScrollEvent& evt);
  void OnSlideS(wxScrollEvent& evt);
  void OnSlideL(wxScrollEvent& evt);
  void OnSlideA(wxScrollEvent& evt);

private:
  /**
   * Cluster model.
   */
  ClusterModel* model;

  /**
   * Cluster number.
   */
  unsigned int cluster;

  /*
   * Controls.
   */
  wxSlider *slideH, *slideS, *slideL, *slideA;
  SpectrumImage *spectH, *spectS, *spectL, *spectA;
  ThumbImage* thumb;
  
  /*
   * Slider control ids.
   */
  enum ID {
    ID_SLIDE_H,
    ID_SLIDE_S,
    ID_SLIDE_L,
    ID_SLIDE_A
  };
  
  DECLARE_EVENT_TABLE()
};
}

#endif
