/**
 * Copyright (C) 2007-2013 Lawrence Murray
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the Free
 * Software Foundation; either version 2 of the License, or (at your option)
 * any later version.
 * 
 * @author Lawrence Murray <lawrence@indii.org>
 * $Rev: 500 $
 * $Date: 2013-08-16 19:04:13 +0800 (Fri, 16 Aug 2013) $
 */
#ifndef INDII_TINT_GUI_SPECTRUMIMAGE_HPP
#define INDII_TINT_GUI_SPECTRUMIMAGE_HPP

#include "../../image/ImageResource.hpp"
#include "../model/ClusterModel.hpp"
#include "../model/ClusterModelObserver.hpp"

#include "wx/panel.h"
#include "wx/control.h"
#include "wx/bitmap.h"
#include "wx/dcclient.h"

namespace indii {
/**
 * Spectrum image.
 */
class SpectrumImage : public wxPanel, public ClusterModelObserver {
public:
  /**
   * Types of spectra.
   */
  enum Type {
    H, S, L, A
  };
  
  /**
   * Constructor.
   *
   * @param parent Parent window.
   * @param cluster Cluster number to which this thumbnail pertains.
   */
  SpectrumImage(wxWindow *parent, const unsigned int cluster, const Type type);

  /**
   * Set model.
   *
   * @param model Model.
   */
  void setModel(ClusterModel* model);
        
  virtual void notifyNumClustersChange();
        
  virtual void notifyClusterChange(const unsigned int i);  
        
  /**
   * Handle paint event.
   */
  void OnPaint(wxPaintEvent& evt);
        
private:
  /**
   * Image resource manager.
   */
  ImageResource* res;
        
  /**
   * Cluster model.
   */
  ClusterModel* model;
        
  /**
   * Cluster number.
   */
  unsigned int cluster;
        
  /**
   * Type.
   */
  Type type;
  
  /**
   * Colour layer of thumbnail.
   */
  wxBitmap fg;
        
  /**
   * Is foreground prepared?
   */
  bool fgPrepared;
        
  /**
   * Prepare foreground.
   */
  void prepareForeground();
  
  DECLARE_EVENT_TABLE()
  
};
}

#endif
