/**
 * Copyright (C) 2007-2013 Lawrence Murray
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the Free
 * Software Foundation; either version 2 of the License, or (at your option)
 * any later version.
 * 
 * @author Lawrence Murray <lawrence@indii.org>
 * $Rev: 511 $
 * $Date: 2013-09-28 15:50:18 +0800 (Sat, 28 Sep 2013) $
 */
#ifndef INDII_IMAGE_IMAGECACHE_HPP
#define INDII_IMAGE_IMAGECACHE_HPP

#include "Image.hpp"

#include "wx/image.h"

#include <map>

namespace indii {
/**
 * Cache of various versions of an image.
 */
class ImageCache {
public:
  /**
   * Constructor.
   *
   * @param original Original image.
   */
  ImageCache(Image* original);
      
  /**
   * Destructor.
   */
  virtual ~ImageCache();
  
  /**
   * Get resized image.
   *
   * @param scale Inverse scale of the new image.
   *
   * @return The resized image, drawn from the cache if available.
   */
  Image* get(const int scale);

  /**
   * Get display image.
   *
   * @param width Width of the image in pixels.
   */
  wxImage* getDisplay(const int width);

private:
  /**
   * Image cache.
   */
  typedef std::map<int,Image*> cache_t;

  /**
   * Display image cache.
   */
  typedef std::map<int,wxImage*> display_cache_t;

  /**
   * Original image.
   */
  Image* original;
  
  /**
   * Original display image.
   */
  wxImage* displayOriginal;

  /**
   * Cache.
   */
  cache_t cache;

  /**
   * Display cache.
   */
  display_cache_t displayCache;
};
}

#endif
