/**
 * Copyright (C) 2007-2013 Lawrence Murray
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the Free
 * Software Foundation; either version 2 of the License, or (at your option)
 * any later version.
 *
 * @author Lawrence Murray <lawrence@indii.org>
 * $Rev: 500 $
 * $Date: 2013-08-16 19:04:13 +0800 (Fri, 16 Aug 2013) $
 */
#ifndef INDII_IMAGE_IMAGE_HPP
#define INDII_IMAGE_IMAGE_HPP

#include "boost/numeric/ublas/matrix.hpp"

namespace indii {
/**
 * Image.
 */
class Image {
public:
  /**
   * Constructor.
   *
   * @param width Width of the image.
   * @param height Height of the image.
   */
  Image(const int width, const int height);

  /**
   * Constructor.
   *
   * @param img Existing image.
   * @param scale Inverse scale of the new image.
   */
  Image(const Image& img, const int scale = 1);

  /**
   * Width of image.
   */
  int getWidth() const;

  /**
   * Height of image.
   */
  int getHeight() const;

  /**
   * Channels.
   */
  boost::numeric::ublas::matrix<float> r, g, b;
};
}

inline int indii::Image::getWidth() const {
  return r.size2();
}

inline int indii::Image::getHeight() const {
  return r.size1();
}

#endif
