/**
 * Copyright (C) 2007-2013 Lawrence Murray
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the Free
 * Software Foundation; either version 2 of the License, or (at your option)
 * any later version.
 *
 * @author Lawrence Murray <lawrence@indii.org>
 * $Rev: 500 $
 * $Date: 2013-08-16 19:04:13 +0800 (Fri, 16 Aug 2013) $
 */
#include "Image.hpp"

#include "boost/numeric/ublas/matrix_proxy.hpp"

indii::Image::Image(const int width, const int height) :
    r(height, width), g(height, width), b(height, width) {
  //
}

indii::Image::Image(const Image& img, const int scale) :
    r(img.getHeight()/scale, img.getWidth()/scale),
    g(img.getHeight()/scale, img.getWidth()/scale),
    b(img.getHeight()/scale, img.getWidth()/scale) {
  using namespace boost::numeric::ublas;

  noalias(r) = subslice(img.r, 0, scale, r.size1(), 0, scale, r.size2());
  noalias(g) = subslice(img.g, 0, scale, g.size1(), 0, scale, g.size2());
  noalias(b) = subslice(img.b, 0, scale, b.size1(), 0, scale, b.size2());
}

