/**
 * Copyright (C) 2007-2013 Lawrence Murray
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the Free
 * Software Foundation; either version 2 of the License, or (at your option)
 * any later version.
 * 
 * @author Lawrence Murray <lawrence@indii.org>
 * $Rev: 505 $
 * $Date: 2013-09-23 23:34:48 +0800 (Mon, 23 Sep 2013) $
 */
#ifndef INDII_IMAGE_FILEIMAGERESOURCE_HPP
#define INDII_IMAGE_FILEIMAGERESOURCE_HPP

#include "ImageResource.hpp"

#include "wx/string.h"

namespace indii {
/**
 * File based image resource manager.
 */
class FileImageResource : public ImageResource {
public:
  /**
   * Constructor.
   *
   * @param path Path name of the image.
   */
  FileImageResource(const wxString& path);

  /**
   * Destructor.
   */
  virtual ~FileImageResource();
};
}

#endif
