/**
 * Copyright (C) 2007-2013 Lawrence Murray
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the Free
 * Software Foundation; either version 2 of the License, or (at your option)
 * any later version.
 * 
 * @author Lawrence Murray <lawrence@indii.org>
 * $Rev: 509 $
 * $Date: 2013-09-27 19:37:55 +0800 (Fri, 27 Sep 2013) $
 */
#ifndef INDII_GUI_HELP_HPP
#define INDII_GUI_HELP_HPP

#include "wx/html/helpctrl.h"
#include "wx/menu.h"

namespace indii {  
/**
 * Tint help.
 */
class Help {
public:
  /**
   * Initialize help system.
   */
  static void init(wxWindow* parent = NULL);

  /**
   * Terminate help system.
   */
  static void term();

  /**
   * Show help.
   *
   * @param section Section number. Default gives contents and welcome page.
   */
  static void show(const int section = 0);

private:
  /**
   * Help controller.
   */
  static wxHtmlHelpController* help;
  
  /**
   * Was the help file successfully loaded?
   */
  static bool haveHelp;
};
}

#endif
