/**
 * Copyright (C) 2007-2013 Lawrence Murray
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the Free
 * Software Foundation; either version 2 of the License, or (at your option)
 * any later version.
 * 
 * @author Lawrence Murray <lawrence@indii.org>
 * $Rev: 500 $
 * $Date: 2013-08-16 19:04:13 +0800 (Fri, 16 Aug 2013) $
 */
#ifndef INDII_TINT_GUI_THUMBIMAGE_HPP
#define INDII_TINT_GUI_THUMBIMAGE_HPP

#include "../model/ClusterModel.hpp"
#include "../model/ClusterModelObserver.hpp"

#include "wx/panel.h"
#include "wx/control.h"
#include "wx/bitmap.h"
#include "wx/dcclient.h"

namespace indii {
/**
 * Image preview.
 */
class ThumbImage : public wxControl, public ClusterModelObserver {
public:
  /**
   * Constructor.
   *
   * @param parent Parent window.
   * @param res Image resource manager. Caller retains ownership.
   * @param model Cluster model. Caller retains ownership.
   * @param cluster Cluster number to which this thumbnail pertains.
   */
  ThumbImage(wxWindow *parent, const unsigned int cluster);

  /**
   * Set model.
   *
   * @param model Model.
   */
  void setModel(ClusterModel* model);

  virtual void notifyNumClustersChange();
  virtual void notifySaturationDecayChange();
  virtual void notifySaturationSoftnessChange();
  virtual void notifyClusterChange(const unsigned int i);  
  virtual void notifySatChange(const unsigned i);
  
  /**
   * Handle paint event.
   */
  void OnPaint(wxPaintEvent& evt);

  /**
   * Handle left mouse button down event.
   */
  void OnLeftDown(wxMouseEvent& evt);

  /**
   * Handle left mouse button up event.
   */
  void OnLeftUp(wxMouseEvent& evt);

  /**
   * Handle mouse enter event.
   */
  void OnEnter(wxMouseEvent& evt);
  
  /**
   * Handle mouse leave event.
   */
  void OnLeave(wxMouseEvent& evt);

private:
  /**
   * Cluster model.
   */
  ClusterModel* model;

  /**
   * Cluster number.
   */
  unsigned int cluster;

  /**
   * Is thumbnail active? (in active state, even if cluster not selected,
   * e.g. on mouse button down event).
   */
  bool isActive;
  
  /**
   * Is mouse over icon?
   */
  bool isOver;

  /**
   * Scale of the thumbnail compared to original image.
   */
  unsigned int scale;
  
  /**
   * Colour layer of thumbnail.
   */
  wxBitmap fg;

  /**
   * B&W layer of thumbnail.
   */
  wxBitmap bg;

  /**
   * Alpha channel of thumbnail.
   */
  channel a;

  /**
   * Is foreground prepared?
   */
  bool fgPrepared;

  /**
   * Prepare background.
   */
  void prepareBackground();

  /**
   * Prepare foreground.
   */
  void prepareForeground();

  DECLARE_EVENT_TABLE()

};
}

#endif
