/**
 * Copyright (C) 2007-2013 Lawrence Murray
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the Free
 * Software Foundation; either version 2 of the License, or (at your option)
 * any later version.
 * 
 * @author Lawrence Murray <lawrence@indii.org>
 * $Rev: 500 $
 * $Date: 2013-08-16 19:04:13 +0800 (Fri, 16 Aug 2013) $
 */
#include "MaskCache.hpp"

using namespace indii;

MaskCache::MaskCache(wxImage* image) : original(image) {
  originalMask = new wxBitmap(*image);
}

MaskCache::~MaskCache() {
  cache_t::iterator iter;
  for (iter = cache.begin(); iter != cache.end(); iter++) {
    delete iter->second;
  }
  delete originalMask;
}

wxMask* MaskCache::get(const int width, const int height) {
  wxBitmap* mask;
  
  if ((width == original->GetWidth() && height == original->GetHeight()) ||
      width <= 0 || height <= 0) {
    /* no need to resize, return original */
    mask = originalMask;
  } else {
    dim_t dim(width, height);  
    cache_t::iterator find = cache.find(dim);
    if (find != cache.end()) {
      mask = find->second;
    } else {
      mask = new wxBitmap(original->Scale(width, height));
      cache.insert(cache_pair_t(dim, mask));
    }
  }

  return new wxMask(*mask, *wxBLACK);
}
