/**
 * Copyright (C) 2007-2013 Lawrence Murray
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the Free
 * Software Foundation; either version 2 of the License, or (at your option)
 * any later version.
 * 
 * @author Lawrence Murray <lawrence@indii.org>
 * $Rev: 500 $
 * $Date: 2013-08-16 19:04:13 +0800 (Fri, 16 Aug 2013) $
 */
#include "ImageResource.hpp"

#include <cmath>
#include <algorithm>

using namespace indii;

ImageResource::ImageResource() {
  //
}

ImageResource::~ImageResource() {
  //
}

void ImageResource::fitOutside(const int widthBound, const int heightBound,
    int* width, int* height) {
  const double ratio = (double)getWidth() / (double)getHeight();
  
  if (ratio*heightBound > widthBound) {
    /* reduce height */
    *width = ratio*heightBound;
    *height = heightBound;
  } else if (widthBound > heightBound*ratio) {
    /* reduce width */
    *width = widthBound;
    *height = widthBound/ratio;
  } else {
    /* bounds same aspect ratio */
    *width = widthBound;
    *height = heightBound;
  }
}

void ImageResource::fitInside(const int widthBound, const int heightBound,
    int* width, int* height) {
  int w = getWidth(), h = getHeight();
  int zoomNumerator = std::min(widthBound/w, heightBound/h);
  int zoomDenominator = std::max((w + widthBound - 1)/widthBound, (h + heightBound - 1)/heightBound);

  if (zoomDenominator > 0) {
    *width = w/zoomDenominator;
    *height = h/zoomDenominator;
  } else if (zoomNumerator > 0) {
    *width = zoomNumerator*w;
    *height = zoomNumerator*h;
  } else {
    *width = w;
    *height = h;
  }

}

unsigned int ImageResource::fitScale(const int widthBound,
    const int heightBound) {
  double widthScale, heightScale;
  widthScale = log((double)getWidth() / widthBound) / log(2.0);
  heightScale = log((double)getHeight() / heightBound) / log(2.0);
  
  return static_cast<unsigned int>(ceil(std::max(widthScale, heightScale)));
}
