/**
 * Copyright (C) 2007-2013 Lawrence Murray
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the Free
 * Software Foundation; either version 2 of the License, or (at your option)
 * any later version.
 * 
 * @author Lawrence Murray <lawrence@indii.org>
 * $Rev: 500 $
 * $Date: 2013-08-16 19:04:13 +0800 (Fri, 16 Aug 2013) $
 */
#ifndef INDII_IMAGE_IMAGECACHE_HPP
#define INDII_IMAGE_IMAGECACHE_HPP

#include "wx/image.h"

#include <map>

namespace indii {
/**
 * Cache of various versions of an image.
 */
class ImageCache {
public:
  /**
   * Constructor.
   *
   * @param image Original image.
   * @param high Should images be resized in high quality?
   */
  ImageCache(wxImage* image, const bool high = false);
      
  /**
   * Destructor.
   */
  virtual ~ImageCache();
  
  /**
   * Get resized image.
   *
   * @param width Width of the image.
   * @param height Height of the image.
   *
   * @return The resized image, drawn from the cache if available.
   *
   * If either @p width or @p height is <= 0, the original image is
   * returned.
   */
  wxImage* get(const int width = 0, const int height = 0);

private:
  /**
   * Image dimension.
   */
  typedef std::pair<const int, const int> dim_t;
  
  /**
   * Image cache.
   */
  typedef std::map<dim_t,wxImage*> cache_t;
  
  /**
   * Image cache pair.
   */
  typedef std::pair<dim_t,wxImage*> cache_pair_t;
  
  /**
   * Original image.
   */
  wxImage* original;
  
  /**
   * Cache.
   */
  cache_t cache;

  /**
   * Should images be resized in high quality?
   */
  const bool high;
};
}

#endif
