/**
 * Copyright (C) 2007-2013 Lawrence Murray
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the Free
 * Software Foundation; either version 2 of the License, or (at your option)
 * any later version.
 *
 * @author Lawrence Murray <lawrence@indii.org>
 * $Rev: 500 $
 * $Date: 2013-08-16 19:04:13 +0800 (Fri, 16 Aug 2013) $
 */
#ifndef INDII_GUI_MISC_HPP
#define INDII_GUI_MISC_HPP

namespace indii {
/**
 * Is the meta key pressed?
 *
 * @param evt Mouse event.
 */
bool is_meta(const wxMouseEvent& evt);
}

#include "wx/event.h"

inline bool indii::is_meta(const wxMouseEvent& evt) {
  #ifndef WX_28
  return evt.GetModifiers() == wxMOD_CONTROL;
  #else
  return evt.ControlDown() && !evt.AltDown() && !evt.ShiftDown() && !evt.MetaDown();
  #endif
}

#endif
