/**
 * Copyright (C) 2007-2013 Lawrence Murray
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the Free
 * Software Foundation; either version 2 of the License, or (at your option)
 * any later version.
 * 
 * @author Lawrence Murray <lawrence@indii.org>
 * $Rev: 500 $
 * $Date: 2013-08-16 19:04:13 +0800 (Fri, 16 Aug 2013) $
 */
#ifndef INDII_GUI_OPENRECENTMENU_HPP
#define INDII_GUI_OPENRECENTMENU_HPP

#include "wx/wx.h"

namespace indii {
/**
 * Open recent file menu.
 */
class OpenRecentMenu : public wxMenu {
public:
  /**
   * Menu shown. Rebuilds menu on-the-fly.
   */
  void OnShow(wxMenuEvent& evt);
  
  /**
   * Clear recent menu event.
   */
  void OnClearRecent(wxCommandEvent& evt);
  
  /**
   * Add file to recent list.
   */
  static void AddFile(const wxString& path);

  /**
   * Remove file from recent list.
   */
  static void RemoveFile(const wxString& path);
    
  /**
   * Get file from recent list.
   */
  static wxString GetFile(const int id);
  
  /**
   * Clear list.
   */
  static void Clear();
    
private:
	/**
   * Maximum number of files in list.
   */
  static const unsigned MAX_FILES = 8;

  /*
   * Control ids.
   */
  enum ID {
    /* these must both match those given in TintWindow */
    ID_CLEAR_RECENT = 764,
    ID_OPEN_RECENT = 765
  };

	DECLARE_EVENT_TABLE()
};
}

#endif
