/**
 * Copyright (C) 2007-2013 Lawrence Murray
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the Free
 * Software Foundation; either version 2 of the License, or (at your option)
 * any later version.
 * 
 * @author Lawrence Murray <lawrence@indii.org>
 * $Rev: 500 $
 * $Date: 2013-08-16 19:04:13 +0800 (Fri, 16 Aug 2013) $
 */
#ifndef INDII_CLUSTER_CLUSTERVECTOR_HPP
#define INDII_CLUSTER_CLUSTERVECTOR_HPP

#include "boost/numeric/ublas/vector.hpp"

namespace indii {
/**
 * Vector type.
 *
 * @tparam T Datum element type.
 */
template<class T = float>
class ClusterVector {
public:
  static const unsigned N = 3;

  typedef boost::numeric::ublas::vector<T,
      boost::numeric::ublas::bounded_array<T,N> > type;
};
}

#endif

