import dbus
import dbus.service
from timerapplet import core
from timerapplet import utils

DBUS_INTERFACE_NAMESPACE = 'net.sourceforge.timerapplet.TimerApplet.Timer'

class TimerService(dbus.service.Object):
    def __init__(self, bus_name, object_path, timer):
        dbus.service.Object.__init__(self,
                                     dbus.service.BusName(bus_name, bus=dbus.SessionBus()),
                                     object_path)
        self._timer = timer
    
    @dbus.service.method(dbus_interface=DBUS_INTERFACE_NAMESPACE, in_signature='siii')
    def Start(self, name, hours, minutes, seconds):
        if self._timer.get_state() != core.Timer.STATE_IDLE:
            self._timer.reset()
        self._timer.set_duration(utils.hms_to_seconds(hours, minutes, seconds))
        self._timer.set_name(name)
        self._timer.start()
        
    @dbus.service.method(dbus_interface=DBUS_INTERFACE_NAMESPACE)
    def Stop(self):
        if self._timer.get_state() != core.Timer.STATE_IDLE:
            self._timer.reset()
    
    @dbus.service.method(dbus_interface=DBUS_INTERFACE_NAMESPACE)
    def PauseContinue(self):
        if self._timer.get_state() == core.Timer.STATE_RUNNING:
            self._timer.stop()
        elif self._timer.get_state() == core.Timer.STATE_PAUSED:
            self._timer.start()
