/*
 * Copyright (C) 2004 Jimmy Do <crispyleaves@gmail.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
 
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "manage-presets-window.h"
#include "add-profile-dialog.h"
#include "profile-manager.h"
#include "timer-applet.h"
#include "layout-utils.h"

static void
on_profile_added (GtkWidget *profile_manager, gchar *profile_name, gdouble profile_duration, gpointer user_data)
{
	GtkTreeRowReference *new_row_ref;
	new_row_ref = timer_applet_add_preset (profile_name, profile_duration);
	profile_manager_select_row (profile_manager, new_row_ref);
}

static void
on_profile_edited (GtkWidget *profile_manager, GtkTreeRowReference *row_ref, gchar *profile_name, gdouble profile_duration, gpointer user_data)
{
	timer_applet_update_preset (row_ref, profile_name, profile_duration);
	
	profile_manager_select_row (profile_manager, row_ref);
}

static void
on_profile_deleted (GtkWidget *profile_manager, GtkTreeRowReference *row_ref, gpointer user_data)
{
	timer_applet_remove_preset (row_ref);
}

static void
on_manage_presets_response (GtkDialog *dialog, gint response, gpointer user_data)
{
	switch (response) {
		case GTK_RESPONSE_CLOSE:
			gtk_widget_hide (GTK_WIDGET (dialog));
			break;

		case GTK_RESPONSE_DELETE_EVENT:
			g_print ("manage presets dialog delete event\n");
			break;

		default:
			g_assert_not_reached ();
	}
}

GtkWidget *
manage_presets_window_new (void)
{
	GtkWidget *manage_profiles_window;
	GtkWidget *vbox;
	GtkWidget *presets_group;
	GtkWidget *label;
	GtkWidget *profile_manager_widget;
	
	manage_profiles_window = gtk_dialog_new_with_buttons (_("Manage Presets"), NULL, GTK_DIALOG_DESTROY_WITH_PARENT,
								GTK_STOCK_CLOSE, GTK_RESPONSE_CLOSE, NULL);

	g_object_set (G_OBJECT (manage_profiles_window),
				"has-separator", FALSE,
				"border-width", 0,
				NULL);

	
	vbox = gtk_vbox_new (FALSE, 18);
	g_object_set (G_OBJECT (vbox), "border-width", 12, NULL);

	gtk_widget_ensure_style (manage_profiles_window);
	g_object_set (G_OBJECT (GTK_DIALOG (manage_profiles_window)->vbox), "border-width", 0, NULL);
	g_object_set (G_OBJECT (GTK_DIALOG (manage_profiles_window)->action_area), "border-width", 12, NULL);
	gtk_box_pack_start (GTK_BOX (GTK_DIALOG (manage_profiles_window)->vbox), vbox, TRUE, TRUE, 0);
	gtk_widget_show (vbox);
	
	profile_manager_widget = profile_manager_new (GTK_TREE_MODEL (timer_applet_get_presets_list ()));
	label = gtk_label_new (_("<span weight=\"bold\">_Timer Presets</span>"));
	g_object_set (G_OBJECT (label),
				"use-markup", TRUE,
				"use-underline", TRUE,
				"mnemonic-widget", profile_manager_get_tree_view (profile_manager_widget),
				"xalign", 0.0,
				NULL);
	presets_group = create_group_box (label);
	
	profile_manager_set_profile_handlers (profile_manager_widget, on_profile_added, NULL, on_profile_edited, NULL, on_profile_deleted, NULL);
	
	group_box_add_row_full (presets_group, profile_manager_widget, TRUE, TRUE);
	gtk_box_pack_start (GTK_BOX (vbox), presets_group, TRUE, TRUE, 0);
	gtk_widget_show (label);
	gtk_widget_show (profile_manager_widget);
	gtk_widget_show (presets_group);
	
	g_signal_connect (G_OBJECT (manage_profiles_window), "response", G_CALLBACK (on_manage_presets_response), NULL);
	g_signal_connect (G_OBJECT (manage_profiles_window), "delete-event", G_CALLBACK (gtk_widget_hide_on_delete), NULL);

	return manage_profiles_window;
}

void
manage_presets_window_open (GtkDialog *manage_presets_window)
{
	g_assert (manage_presets_window);
	gtk_window_present (GTK_WINDOW (manage_presets_window));
}
