/*
 * Copyright (C) 2004 Jimmy Do <crispyleaves@gmail.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
 
#ifndef ADD_PROFILE_DIALOG_H
#define ADD_PROFILE_DIALOG_H
#include <gtk/gtk.h>

typedef void (*ProfileAddedCallback) (GtkWidget *add_profile_dialog, gchar *profile_name, gdouble profile_duration, gpointer user_data);
typedef void (*ProfileEditedCallback) (GtkWidget *add_profile_dialog, GtkTreeRowReference *row_ref, gchar *profile_name,
									gdouble profile_duration, gpointer user_data);
typedef gboolean (*NameValidator) (const gchar *profile_name, const gchar *ignore_name, gpointer user_data);

GtkWidget *
add_profile_dialog_new (NameValidator name_validator, gpointer user_data);

void
add_profile_dialog_open (GtkWidget *add_profile_dialog, gchar *dialog_title, gchar *profile_name, gdouble profile_duration, GtkTreeRowReference *editing_profile);

void
add_profile_set_handlers (GtkWidget *add_profile_dialog, ProfileAddedCallback added_cb, gpointer user_data1, ProfileEditedCallback edited_cb, gpointer user_data2);

#endif /* ADD_PROFILE_DIALOG_H */
