Components.utils.import("resource://calendar/modules/calUtils.jsm");
                        
var prompts = Components.classes["@mozilla.org/embedcomp/prompt-service;1"]
                        .getService(Components.interfaces.nsIPromptService);
var consoleService = Components.classes["@mozilla.org/consoleservice;1"]
                        .getService(Components.interfaces.nsIConsoleService);
var prefs = Components.classes["@mozilla.org/preferences-service;1"]
                        .getService(Components.interfaces.nsIPrefBranch);
var timer = Components.classes["@mozilla.org/timer;1"]
                        .createInstance(Components.interfaces.nsITimer);
   
var calendarTimeline = { 
	
};
                      
var callback = { 
    notify: function notify(timer) {
		try { 
			calendarTimeline.draw();
		} catch (e) {}
    }
};

calendarTimeline.draw = function draw() {
    var cell = document.getElementById("eventsDiv");

    if ( cell.hasChildNodes() ) {
        while ( cell.childNodes.length >= 1 ) {
            cell.removeChild( cell.firstChild );       
        } 
    }
    var canvas = document.getElementById("mycanvas");
    var ctx = canvas.getContext('2d');
    canvas.setAttribute("width", window.innerWidth);
    canvas.setAttribute("style", "width: " + window.innerWidth + "px;");
    ctx.clearRect(0, 0, 24 , window.innerWidth);
    
    this.hourPixels = prefs.getIntPref("extensions.timeline.hour")
    if (prefs.getBoolPref("extensions.timeline.log")) {
        consoleService.logStringMessage("Timeline Message:\n\tTimeline Reloaded at " + new Date());
    }
    if (this.hourPixels > 30) {
        //if we're going to draw an hourly chart
        this.drawHours();
    } else {
        //if we're going to draw a weekly or monthly chart
        this.drawDays();
    }
}

calendarTimeline.drawHours = function drawHours() {
    var canvas = document.getElementById("mycanvas");

    if (canvas.getContext)  {
        var date = new Date();
        var difference = this.hourPixels - (this.hourPixels*date.getMinutes()/60);
        var hour = date.getHours();
        
        var offset = 256/this.hourPixels; //no of hours before nowLine
        
        //Canvas stuff
        var ctx = canvas.getContext('2d');
        // For shininess, make nice roundy line endings
        ctx.lineCap = "round";
        
        // Max m is a number high enough that the 10 minute lines are drawn all across the page
        for (var m = 0; m < 10 + (window.innerWidth*6/this.hourPixels); m++) {
                
            //Hourly lines (with a 10px gap in them to fit in the hour text)
            ctx.beginPath();
            ctx.moveTo(difference + m*this.hourPixels,20);
            ctx.lineTo(difference + m*this.hourPixels,15);
            ctx.moveTo(difference + m*this.hourPixels,5);
            ctx.lineTo(difference + m*this.hourPixels,0);
            ctx.stroke();
            
            if (difference + (m-10)*this.hourPixels/6 < window.innerWidth) {            
				//Dashes denoting 10 minutes lines
				ctx.beginPath();
				ctx.moveTo(difference + (m-10)*this.hourPixels/6,20);
				ctx.lineTo(difference + (m-10)*this.hourPixels/6,17);
				ctx.moveTo(difference + (m-10)*this.hourPixels/6,3);
				ctx.lineTo(difference + (m-10)*this.hourPixels/6,0);
				ctx.stroke();   
			}
        }
        //Time text
        var time = hour - offset + 1;
        ctx.font = "10px Sans";
        ctx.textAlign = "center";
        for (var x = 0; x < window.innerWidth; x = x + this.hourPixels) {
            if (time < 0) time = time + 24; 
            if (time > 23) time = time - 24; 
            ctx.fillText(time + ":00", difference + x, 14);
            time = time + 1;
        } 
        this.getTimelineItems();
    }
}

calendarTimeline.drawDays = function drawDays() {
    var canvas = document.getElementById("mycanvas");
    
    var date = new Date();
    var difference = 0;
    //if hourPixels = 16, we're talking weekly, if it's 8, monthly
    if (this.hourPixels == 16) {
        var hourlength = window.innerWidth/7;
        var hourOffset = 2;
     } else {
        var hourlength = window.innerWidth/28;
        var hourOffset = 5;
    }
    difference = 256 + hourlength - (hourlength*date.getHours()/24);
    var weekday= ["Sun", "Mon", "Tue", "Wed", "Thu", "Fri", "Sat"];
    if (canvas.getContext)  {
        //Canvas stuff
        var ctx = canvas.getContext('2d');
        // For shininess, make nice roundy line endings
        ctx.lineCap = "round";
        for (var m = 0; m < window.innerWidth*6/hourlength; m++) {

            ctx.beginPath();
            ctx.moveTo(difference + (m-hourOffset)*hourlength,20);
            ctx.lineTo(difference + (m-hourOffset)*hourlength,15);
            ctx.moveTo(difference + (m-hourOffset)*hourlength,5);
            ctx.lineTo(difference + (m-hourOffset)*hourlength,0);
            ctx.stroke();
            
            var d = Date.parse(date) + (m-hourOffset+1)*24*3600000;
            d = new Date(d)
            if ( prefs.getIntPref("extensions.timeline.hour") == 16 ) {
                d = weekday[d.getDay()] + " " + d.toLocaleDateString();
            } else {
                d= d.getDate() + "/" + (d.getMonth()+1);
            }
            //Time text
            ctx.font = "10px Sans";
            ctx.textAlign = "center";
            ctx.fillText(d, difference + (m-hourOffset)*hourlength ,14)
        }
    }
    this.getTimelineItems();
}

// We need to get the events from the calendar for the timeline.  
// We ask for all events between 7 days before and 28 days after now.
calendarTimeline.getTimelineItems = function getTimelineItems(type) { 
	
    var date = new Date();
    var start = Date.parse(date) - 7*1000*60*60*24;
    start = cal.jsDateToDateTime(new Date(start));
    var end = Date.parse(date) + 28*1000*60*60*24;
    end = cal.jsDateToDateTime(new Date(end));
    
    var getListener = {
        
        onOperationComplete: function(aCalendar, aStatus, aOperationType, aId, aDetail) {
			var div = document.createElement("html:div");
			div.setAttribute("id", "nowLine");
			div.left = 256;
			div.top = 2
			div.width = 3;
			div.innerHTML = "%20";
			document.getElementById("eventsDiv").appendChild(div);
        },
        
        onGetResult: function(aCalendar, aStatus, aItemType, aDetail, aCount, aItems) {
            for each (var item in aItems) {
				try {
                    calendarTimeline.drawItem(aCalendar, item);
				} catch(e) {
				}
			}
        }
    };
        
    getCompositeCalendar().getItems(    getCompositeCalendar().ITEM_FILTER_ALL_ITEMS | 
                                        getCompositeCalendar().ITEM_FILTER_CLASS_OCCURRENCES, 
                                        0, 
                                        start, 
                                        end, 
                                        getListener);
}

//Draw boxes for each item.
calendarTimeline.drawItem = function drawItem(calendar, item) {
    var bgcolor = calendar.getProperty("color") || "#A8C2E1";
    var color = getContrastingTextColor(bgcolor);
    var date = new Date();
    var div = document.createElement("html:div");
    var timeOffset = 1;
    var difference = 0;
    var timeZoneOffset = 1;
    
    //For zooms displaying hours
    if (this.hourPixels > 16) {
		var hourlength = this.hourPixels;
		timeOffset = 1;
	}
    
    //For zooms displaying days (week view)
    if (this.hourPixels == 16) {
        var hourlength = window.innerWidth/(7*24);
        timeOffset=7;
        timeZoneOffset = 1;
        difference = window.innerWidth/(24);
    }
    //For zooms displaying dates (month view)
    if (this.hourPixels == 8) {
        var hourlength = window.innerWidth/(28*24); 
        timeOffset=28;
        timeZoneOffset = 1;
        difference = window.innerWidth/24;
    }
    var offset=256/hourlength;
    if (cal.isEvent(item)) {
        var startPosition = 256 + (item.startDate.nativeTime/1000-date)*hourlength/3600000;
        if (startPosition < window.innerWidth) {
			var duration = hourlength*(item.endDate.nativeTime-item.startDate.nativeTime)/3600000000;
			if (startPosition + duration > 0) {
			if (prefs.getBoolPref("extensions.timeline.log")) {
				consoleService.logStringMessage(
					"Timeline Message:\n\t" + item.title + 
					"\n\t" + item.startDate.icalString + " --> " + item.endDate.icalString + 
					"\n\tStart Position: " + startPosition + "px" + 
					"\n\tLength: " + duration + "px" + 
					"\n\tColour: " + bgcolor );
			}

			if (item.startDate.isDate) {
				var timezone = this.hourPixels*item.startDate.jsDate.getTimezoneOffset()/(60*timeZoneOffset);
				var startPostion = (offset*hourlength+hourlength*(item.startDate.nativeTime/1000 - date)/(3600000*timeOffset)) + timezone;
			} else {
				var startPostion = offset*hourlength+hourlength*(item.startDate.nativeTime/1000 - date)/(3600000*timeOffset);
			}
			
			var title;
			if (startPosition + duration > window.innerWidth) { duration = window.innerWidth - startPosition; }
			if (startPosition > 0) { var indent = 25; } else { var indent = (25-startPosition); }
        
			if (item.title.length * 10 > (duration - indent)) {
				title = item.title.substring(0, (duration - indent)/10) + "...";
			} else {
				title = item.title;
			}
			var text = document.createTextNode(title);

			var style =     "text-indent:" + indent + "px; " +
							"color:" + color + "; ";
			var alarms = item.getAlarms({});
			var alarmIcon = "";
			var repeatColour = "";
			if (alarms.length) {
				alarmIcon = "alarm";
			}
        
			if (item.recurrenceId) {
				if (color=="white") {
					repeatColour = "whiteRepeat";
				} else { 
					repeatColour = "blackRepeat";
				}   
			}

			div.width = duration;
			div.left = startPosition;
			if (item.startDate.isDate) { 
				style += "background:" + bgcolor + ";";
				div.style.cssText = style;
				div.top = 19;
				div.height = 3;
				div.setAttribute("class","event allDayEvent");
				if (!prefs.getBoolPref("extensions.timeline.showAllDay")) {
					div.setAttribute("style", "display:none;");
				}
			} else { 
				if (this.hourPixels > 20) {
					style += "background:" + bgcolor + " url(chrome://calendartimeline/skin/" + alarmIcon + repeatColour + "Icon.png) no-repeat 1px center;";
					div.style.cssText = style;
					div.setAttribute("class","event standardEvent");
					div.appendChild(text);
					if (!prefs.getBoolPref("extensions.timeline.showEvents")) {
						div.setAttribute("style", "display:none;")
					}
				} else {
					style += "background:" + bgcolor + ";";
					div.style.cssText = style;
					div.top = 2;
					div.height = 20;
					div.setAttribute("class","event standardEventDays");
					div.appendChild(text);
					if (!prefs.getBoolPref("extensions.timeline.showEvents")) {
						div.setAttribute("style", "display:none;")
					}
				}
			}
			div.addEventListener("dblclick", function () { modifyEventWithDialog(item, null, false); } , false);
		}
		} 
    } else if (cal.isToDo(item)) {
        if (prefs.getBoolPref("extensions.timeline.showTasks")) {
            if (prefs.getBoolPref("extensions.timeline.log")) {
                consoleService.logStringMessage(
                    "Timeline Message:\n\t" + item.title + 
                    "\n\t" + item.entryDateicalString + " --> " + item.dueDate.icalString + 
                    "\n\tColour: " + bgcolor );
            }
            if (item.dueDate) {
                var deadline = offset*hourlength+hourlength*(item.dueDate.nativeTime/1000 - date)/(3600000*timeOffset);
                var style =     "background-color:" + bgcolor + ";" +
                                "left:" + (deadline-2)  + "px;";
                                
				div.left = deadline - 2;
				div.top = 2
				div.width = 3;
				div.innerHTML = "%20";
                div.setAttribute("style", style );
                div.setAttribute("class","task");
				div.innerHTML = "%20";
                div.addEventListener("dblclick", function () { modifyEventWithDialog(item, null, null); } , false);
            }
        }
    }
    div.setAttribute("id", item.id);
    document.getElementById("eventsDiv").appendChild(div);
}

//Toggles an event type on or off (event, task, add-day event)
calendarTimeline.toggleTimelineContents = function toggleTimelineContents(type) {
    var menuItem = document.getElementById("timelineContext" + type);
    if (prefs.getBoolPref("extensions.timeline.show" + type)) {
        prefs.setBoolPref("extensions.timeline.show" + type, false);
        menuItem.setAttribute("checked", false);
    } else {
        prefs.setBoolPref("extensions.timeline.show" + type, true);
        menuItem.setAttribute("checked", true);
    }
    this.draw();
}
//Checks to see whether an event type is currently displayed (event, task, add-day event)
calendarTimeline.checkTimelineContents = function checkTimelineContents(type) {
    if (prefs.getBoolPref("extensions.timeline.show" + type)) {
        return true;
    } else {
        return false;
    }
}

//Set the zoom back to default (from popup menu item)
calendarTimeline.resetZoom = function resetZoom() {
    prefs.setIntPref('extensions.timeline.hour', 128);
    this.draw();
}

calendarTimeline.zoom = function zoom(delta) {          
    var size = prefs.getIntPref("extensions.timeline.hour");
    if (delta < 0) {
        size = size*2;
    } else{
        size = size/2;
    }
    if (size < 8) size = 8;
    if (size > 64) size = 256;
    prefs.setIntPref("extensions.timeline.hour", size);
    this.draw();
}

timer.initWithCallback(callback, 28125, Components.interfaces.nsITimer.TYPE_REPEATING_SLACK);
