/** 
  mffm Time Code
  Time Code for multimedia systems

  Copyright (C) 2000, 2001 Matt R. Flax <flatmax@ieee.org>
  
  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 2.1 of the License, or (at your option) any later version.
  
  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Lesser General Public License for more details.
  
  You have received a copy of the GNU Lesser General Public License
  along with this library.

  Compile with :
    g++ -o filterTest filterTest.C
 */
#include <mffm/timeCode.H>

#include <fstream>
using namespace std;

/** Time code related defines */
#define ARRAY_TYPE double /// The type of the signal data
#define FIELD_COUNT 1 /// We only want to deal with a samples field
#define MASTER_COUNTER_TYPE MasterCounter<field, FIELD_COUNT> /// Start, current and top fields, with FIELD_TYPE base sets (at the moment only measure samples)
#define TIME_CODE_TYPE TimeCode<MASTER_COUNTER_TYPE, ARRAY_TYPE>

int main(int argc, char *argv[]){
  ifstream inputF("input.dat");
  if (!inputF){
    cerr<<"error input file input.dat couldn't be opened"<<endl;
    return -1;
  }
  inputF.seekg(0, ios::end);
  int N=inputF.tellg()/2; //The input are number, space, number, space ...
  inputF.seekg(0, ios::beg);
  
  cout<<"N="<<N<<endl;

  double input[N];
  double tempD;
  int i=0;
  while (inputF >> tempD){
    input[i++]=tempD;
  }
  inputF.close();

  ofstream outputF("output1.dat");

  // filter definitions
  // The following were generated using the octave function :
  // [a,b]=BPDesign(1,1500,0.75 ,44000) ... provided with this header 
  // timeCode set. download octave now : www.octave.org

  int aCnt=5, bCnt=5;
  double a[5]={1.0, -3.5541014881435541994, 4.7850051334632244249, -2.8981254680358414788, 6.6775765615488547056e-01};
  double b[5]={1.6888975845622482275e-02, 0.0, -3.3777951691244964549e-02, 0.0, 1.6888975845622482275e-02};
  double memory[5]={0.0, 0.0, 0.0, 0.0, 0.0};

  TIME_CODE_TYPE tc(0,N); //Define the time code with the window to the correct size
  // now filter ...
  for (i=0;i<N;i++){
    tc.filter(input[i],aCnt,a,bCnt,b,memory); //Filter one sample
    outputF<<(*tc.window)[tc.getCount()]<<' '; // output to file
    tc+=1; // Move the time code on one sample
  }
  outputF.close();
}
