/*
 * $Id: MockDefinitionsReader.java 1045365 2010-12-13 20:46:46Z apetrelli $
 *
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package org.apache.tiles.definition;

import java.util.LinkedHashMap;
import java.util.Map;

import org.apache.tiles.Definition;

/**
 * Mock Defintions Reader implementation.  Stubs out all functionality.
 *
 * @version $Rev: 1045365 $ $Date: 2010-12-13 15:46:46 -0500 (Mon, 13 Dec 2010) $
 */
public class MockDefinitionsReader implements DefinitionsReader {

    /**
     * Hokey way to verify that this was created.
     */
    private static int instanceCount = 0;

    /**
     * Hokey way to verify that this class was created.
     *
     * @return The number of created instances.
     */
    public static int getInstanceCount() {
        return instanceCount;
    }

    /** Creates a new instance of MockDefinitionsReader. */
    public MockDefinitionsReader() {
        instanceCount++;
    }

    /**
     * Reads <code>{@link Definition}</code> objects from a source.
     *
     * Implementations should publish what type of source object is expected.
     *
     * @param source The source from which definitions will be read.
     * @return a Map of <code>Definition</code> objects read from
     *  the source.
     * @throws org.apache.tiles.definition.DefinitionsFactoryException if the source is invalid or
     *  an error occurs when reading definitions.
     */
    public Map<String, Definition> read(Object source) {
        return new LinkedHashMap<String, Definition>();
    }
}
