/*
 * $Id: AbstractModelBody.java 1044817 2010-12-12 13:22:01Z apetrelli $
 *
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.tiles.autotag.core.runtime;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;

import org.apache.tiles.autotag.core.runtime.util.NullWriter;

/**
 * Base class for the abstraction of the body.
 *
 * @version $Rev: 1044817 $ $Date: 2010-12-12 14:22:01 +0100 (Sun, 12 Dec 2010) $
 */
public abstract class AbstractModelBody implements ModelBody {

    /**
     * The default writer to use.
     */
    private Writer defaultWriter;

    /**
     * Constructor.
     *
     * @param defaultWriter The default writer to use.
     */
    public AbstractModelBody(Writer defaultWriter) {
        this.defaultWriter = defaultWriter;
    }

    @Override
    public void evaluate() throws IOException {
        evaluate(defaultWriter);
    }

    @Override
    public String evaluateAsString() throws IOException {
        StringWriter writer = new StringWriter();
        try {
            evaluate(writer);
        } finally {
            writer.close();
        }
        String body = writer.toString();
        if (body != null) {
            body = body.replaceAll("^\\s*|\\s*$", "");
            if (body.length() <= 0) {
                body = null;
            }
        }
        return body;
    }

    @Override
    public void evaluateWithoutWriting() throws IOException {
        NullWriter writer = new NullWriter();
        try {
            evaluate(writer);
        } finally {
            writer.close();
        }
    }

}
