/**
 * @file   unit-status.cc
 *
 * @section LICENSE
 *
 * The MIT License
 *
 * @copyright Copyright (c) 2017-2021 TileDB, Inc.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 *
 * @section DESCRIPTION
 *
 * Tests the `Status` class.
 */

#include <test/support/tdb_catch.h>
#include "tiledb/common/status.h"

using namespace tiledb::common;

TEST_CASE("Status: Test ok", "[status]") {
  Status st = Status::Ok();
  CHECK(st.ok());
  st = Status_Error("err msg");
  CHECK(!st.ok());
}

TEST_CASE("Status: Test to_string", "[status]") {
  Status ok = Status::Ok();
  CHECK_THAT(ok.to_string(), Catch::Equals("Ok"));

  Status err = Status_Error("err msg");
  CHECK_THAT(err.to_string(), Catch::Equals("Error: err msg"));
}
