/*
 *	TICKR - GTK-based Feed Reader - Copyright (C) Emmanuel Thomas-Maurin 2009-2012
 *	<manutm007@gmail.com>
 *
 * 	This program is free software: you can redistribute it and/or modify
 * 	it under the terms of the GNU General Public License as published by
 * 	the Free Software Foundation, either version 3 of the License, or
 * 	(at your option) any later version.
 *
 * 	This program is distributed in the hope that it will be useful,
 * 	but WITHOUT ANY WARRANTY; without even the implied warranty of
 * 	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * 	GNU General Public License for more details.
 *
 * 	You should have received a copy of the GNU General Public License
 * 	along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef INC_TICKR_H
#define INC_TICKR_H

#define APP_NAME		"Tickr"
#define APP_CMD			"tickr"
#define APP_VERSION_NUMBER	"0.6.2"
#define WEBSITE_URL		"http://www.newsrssticker.com"
#define SUPPORT_URL		WEBSITE_URL"/help.php"
#define DOWNLOAD_URL		WEBSITE_URL"/download.php"
#define SUPPORT_EMAIL_ADDR	"manu@newsrssticker.com"
#define CHECK4UPDATES_URL	WEBSITE_URL"/app_version_visible.php"
#define CHECK4UPDATES_ID_STR	"LSVN="	/* Stands for 'Last Stable Version Number =' */

#define _GNU_SOURCE
#define _ISOC99_SOURCE

/*#define DOUBLE_LINE_TICKER*/		/* NEW and experimental/unstable */

#define VERBOSE_OUTPUT
/*#define DEBUG_OUTPUT*/		/* Actually never used so far */

/* For info_win_wait(..., timeout) */
/*#define INFO_WIN_WAIT_POS	GTK_WIN_POS_CENTER*/	/* Same as for info_win() */
#define INFO_WIN_WAIT_POS	GTK_WIN_POS_CENTER_ON_PARENT
/*#define INFO_WIN_WAIT_POS	GTK_WIN_POS_NONE*/
#define INFO_WIN_WAIT_TIMEOUT	2000	/* in ms */

#define CONNECT_FAIL_MAX	5
#define CONNECT_FAIL_TIMEOUT	1

/* To avoid confusion.
 * We must make sure this value doesn't conflict with any other user-defined GTK_RESPONSE_STH
 * (at the moment, only one enum in tickr_feedpicker.c.) */
#define GTK_RESPONSE_CANCEL_CLOSE	100	/* Predefined GTK_RESPONSE_ are < 0 */

/* For correctness sake, 'uri' should be used instead of 'url'. */

#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <errno.h>
#include <time.h>
#include <unistd.h>
#include <ctype.h>
#include <fcntl.h>
#include <sys/stat.h>
#include <gtk/gtk.h>
#include <gdk/gdkkeysyms.h>
#ifndef G_OS_WIN32
# include <grp.h>
# include <pwd.h>
# include <sys/socket.h>
# include <netdb.h>
# include <arpa/inet.h>
# include <sys/select.h>
#else
/* Win version = XP or higher */
# define WINVER		0x0501
# define _WIN32_WINNT	0x0501
# include <winsock2.h>
# include <ws2tcpip.h>
# include <rpcdce.h>
# include <iphlpapi.h>
# include <winreg.h>
# include <shlobj.h>
#endif
#ifndef G_OS_WIN32
# include <glib-2.0/glib/gstdio.h>
#else
# include <../glib-2.0/glib/gstdio.h>
#endif
#include <libxml/parser.h>
#include <libxml/tree.h>
#include "../libetm-0.4.4/libetm.h"
#include "tickr_socket.h"
#include "tickr_list.h"

#define RESOURCE_NONE_QUIT	FALSE	/* To quit or not if no resource is specified */
#define OPTION_ERROR_QUIT	FALSE	/* To quit or not if unknown or invalid option(s) */

#define DRWA_WIDTH_MIN		100
#define DRWA_HEIGHT_MIN		10
#define TAB_SIZE		8
#define FILE_NAME_MAXLEN	(2 * 1024 - 1)	/* Apply to both FULL FILE NAMES and ***URLs*** */
#define FONT_NAME_MAXLEN	64
#define FONT_SIZE_MAXLEN	3
#define FONT_MAXLEN		FONT_NAME_MAXLEN + 1 + FONT_SIZE_MAXLEN
#define DELIMITER_MAXLEN	80
#define OPTION_NAME_MAXLEN	31
#define OPTION_VALUE_MAXLEN	MAX(MAX(FILE_NAME_MAXLEN, FONT_MAXLEN), DELIMITER_MAXLEN)
#define OPTION_MAXLEN		OPTION_NAME_MAXLEN + OPTION_VALUE_MAXLEN + 4	/* -name="value" */
#define N_OPTION_MAX		64	/* Max number of options */
#define N_URL_MAX		1024	/* Max number of url's */
#define NFEEDLINKANDOFFSETMAX	256	/* Max number of "open-able" links per feed */
/*#define LINK_TAG_CHAR		'^'*/	/* ascii 5E - char used internally for links, removed from feed text */
#define LINK_TAG_CHAR		((char)(1))	/* char (ascii 01) used internally for item links, removed from feed text */
#define ITEM_TITLE_TAG_CHAR	((char)(2))	/* char (ascii 02) used internally for item titles, --- */
#define ITEM_DES_TAG_CHAR	((char)(3))	/* char (ascii 03) used internally for item descrptions, --- */

#define TMPSTR_SIZE		(2 * 1024 - 1)	/* Used for most tmp strings - must be large enough */
#ifndef G_OS_WIN32
# define SEPARATOR_CHAR		'/'
#else
# define SEPARATOR_CHAR		'\\'
#endif
#define FEED_TITLE_MAXLEN	60
/* 7-bit ascii - of course, the following ones must match */
#define TITLE_TAG_CHAR		'>'
#define TITLE_TAG_STR		">"
#define SELECTED_URL_CHAR	'*'
#define SELECTED_URL_STR	"*"
#define UNSELECTED_URL_CHAR	'-'
#define UNSELECTED_URL_STR	"-"

/* Make sure this stuff is robust enough */
#define XPIXMAP_MAXWIDTH	(32 * 1024 - 1)	/* 32 K - 1 = max supported width for xpixmaps
						 * (not 64 k - 1 as sometimes uncorrectly specified.)
						 */
#define LINE_MAXLEN		128	/* Max length of a single line (see tickr_render.c) */
#define WORD_MAXLEN		32	/* Max length of a word that won't get cut off */
#if (LINE_MAXLEN <= WORD_MAXLEN)
# error LINE_MAXLEN must be > WORD_MAXLEN
#endif
#define FONT_MAXSIZE		200

#define ARBITRARY_TASKBAR_HEIGHT 25

/*
 * File names, paths and dirs stuff
 *
 * Linux version:	/usr/bin/
 *			/usr/share/APP_CMD/
 *			/usr/share/APP_CMD/pixmpas/
 *			/home/<user_name>/.APP_CMD/
 *
 * Win32 version:	C:\Program files\APP_NAME\	(also location for pixmaps)
 *			C:\...\Application Data\APP_NAME\
 */
#ifndef G_OS_WIN32
# define TICKR_DIR_NAME		"."APP_CMD
#else
# define TICKR_DIR_NAME		APP_NAME
#endif
#define CONFIG_FILE		APP_CMD"-conf"
#define URL_LIST_FILE		APP_CMD"-url-list"
#define RESOURCE_DUMP		APP_CMD"-resrc-dump"
#define XML_DUMP		APP_CMD"-xml-dump"
#define XML_DUMP_EXTRA		APP_CMD"-xml-dump-extra"
#define TMP1			"tmp1"
#define TMP2			"tmp2"
#ifndef G_OS_WIN32
# define STD_OUT		stdout
# define STD_ERR		stderr
#else
# define STD_OUT		stdout_fp
# define STDOUT_FILENAME1	"stdout1.txt"
# define STDOUT_FILENAME2	"stdout2.txt"
# define STD_ERR		stderr_fp
# define STDERR_FILENAME1	"stderr1.txt"
# define STDERR_FILENAME2	"stderr2.txt"
#endif
#ifndef G_OS_WIN32
# define INSTALL_PATH		"/usr/share/"APP_CMD
# define IMAGES_PATH		INSTALL_PATH"/pixmaps"
#else
# define IMAGES_PATH		APP_NAME	/* actually not a path but a dir name */
#endif
#define TICKR_ICON		APP_CMD"-icon.png"
#define TICKR_LOGO		APP_CMD"-logo.png"
#define RSS_ICON		APP_CMD"-rss-icon.png"

/* Default config values */
#define DELAY			8
#define SHIFTSIZE		1
#ifndef G_OS_WIN32
# define FONTNAME		"Sans"
#else
# define FONTNAME		"Arial Unicode MS"
#endif
#define FONTSIZE		"14"
#define FGCOLOR			"#ffffffff"	/* White */
#define BGCOLOR			"#36516240"	/* Some translucent blue */
#define WIN_X			0
#define WIN_Y			0
#define WIN_W			1024	/* Unused, we use get_ticker_env()->screen_w instead */
#define WIN_H			0	/* If = 0, determined by font size */
#define WINDEC			'n'
#define ALWAYSONTOP		'n'	/* Changed to no */
#ifndef G_OS_WIN32
# define WINTRANSPARENCY	1.0
#else
# define WINTRANSPARENCY	0.8
#endif
#define ICONINTASKBAR		'y'
#define WINSTICKY		'n'
#define SHADOW			'y'
#define SHADOWOFFSET_X		4
#define SHADOWOFFSET_Y		2
#define SHADOWFX		2
#define LINEDELIMITER		" "
#define CUTLINEDELIMITER	"..."LINEDELIMITER
#define SPECIALCHARS		'n'
#define NEWPG			'`'
#define TABCH			'~'
#define RSSREFRESH		15
#define FEEDTITLE		'n'
#define FEEDTITLEDELIMITER	"        "
#define ITEMTITLE		'y'
#define ITEMTITLEDELIMITER	"        "
#define ITEMDESCRIPTION		'n'
#define ITEMDESCRIPTIONDELIMITER "        -        "
#define NITEMSPERFEED		5
#define STRIPHTMLTAGS		'y'
#define UPPERCASETEXT		'n'
#define HOMEFEED		"http://newsrss.bbc.co.uk/rss/newsonline_world_edition/front_page/rss.xml"
#ifndef G_OS_WIN32
# define OPENLINKCMD		"firefox"	/* Firefox on Linux */
#else
# define OPENLINKCMD		""
#endif
#define OPENLINKARGS		""
#define CLOCK			'n'
#define CFONTNAME		FONTNAME
#define CFONTSIZE		"12"
#define CFGCOLOR		"#aeaeaeff"	/* White but darker than text*/
#define CBGCOLOR		BGCOLOR
#define DISABLEPOPUPS		'n'
#define PAUSEONMOUSEOVER	'y'
#define DISABLELEFTCLICK	'n'
#define MOUSEWHEELSCROLL	's'
#define ENABLEFEEDORDERING	'n'
#define USEAUTHENTICATION	'n'
#define USER			""
#define USEPROXY		'n'
#define PROXYHOST		""
#define PROXYPORT		"8080"
#define USEPROXYAUTHENTICATION	'n'
#define PROXYUSER		""

/* Global pseudo stdout and stderr on win32 */
#ifdef G_OS_WIN32
extern FILE	*stdout_fp, *stderr_fp;
#endif

/* typedef enum's */
typedef enum {
	SINGLE,
	MULTIPLE
} _selection_mode;

typedef enum {
	RESRC_TYPE_UNDETERMINED,
	RESRC_UNSPECIFIED,
	RESRC_URL,		/* Will be fetched and xml-parsed */
	RESRC_FILE		/* Will be processed as non-xml text file */
} _resrc_type;

typedef enum {
	RSS_FORMAT_UNDETERMINED,
	RSS_1_0,
	RSS_2_0,
	RSS_ATOM
} _rss_format;

typedef enum {
	TIME_RESET,
	TIME_CHECK
} check_time_mode;

typedef enum {
	INFO,
	INFO_WARNING,
	INFO_ERROR
} info_type;

typedef enum {
	WIN_WITH_SPINNER_OPEN,
	WIN_WITH_SPINNER_CLOSE
} win_with_spinner_mode;

typedef enum {
	WIN_WITH_PROGRESS_BAR_OPEN,
	WIN_WITH_PROGRESS_BAR_PULSE,
	WIN_WITH_PROGRESS_BAR_CLOSE
} win_with_progress_bar_mode;

typedef enum {
	AUTH_PAGE,
	PROXY_PAGE
} connection_settings_page;

/* typedef struct's */
/* Usefull graphical (and other) ticker 'environment' values */
typedef struct {
	GdkScreen	*screen;			/* GDK screen for win */
	GdkVisual	*visual;
	gint		screen_w, screen_h;		/* Screen width & height */
	gint		depth;				/* Screen depth */
	GtkWidget 	*win;				/* Top level window */
	GtkWidget	*drw_a, *drwa_clock;		/* Drawing areas (main / clock) */
	gint		drwa_width, drwa_height;	/* Main drawing area dimensions */
	gint		drwa_clock_width;		/* Clock drawing area width */
	cairo_surface_t	*c_surf;			/* Cairo image surface onto which text is rendered */
	gint 		surf_width, surf_height;	/* Cairo image surface dimensions */
	char		active_link[FILE_NAME_MAXLEN + 1];
	int		mouse_x_in_drwa;
	/* These flags are checked mainly by shift2left_callback() */
	gboolean	suspend_rq;			/* Request for doing nothing */
	gboolean	compute_rq;			/* Request for (re)computing everything (surface and win) */
	gboolean	reload_rq;			/* Request for (re)loading resource */
	_selection_mode	selection_mode;		/* default = MULTIPLE, set to SINGLE internally if selection
							 * is unavalaible/empty or after picking a single feed */
	gboolean	stream_fully_read;		/* Set/checked only in render_stream_to_surface() and
							 * shift2left_callback() */
} TickerEnv;

typedef struct {
	char		url[FILE_NAME_MAXLEN + 1];
	gint		offset_in_surface;
} FeedLinkAndOffset;

typedef struct {
	_resrc_type	type;				/* Text file or url */
	_rss_format	format;				/* RSS 1.0, RSS 2.0 or Atom */
	char		id[FILE_NAME_MAXLEN + 1];	/* Local = file name or remote = feed url */
	/* Apply only to url/rss */
	_rss_format	rss_format;
	char		feed_title[FEED_TITLE_MAXLEN + 1];
	char		resrc_dump[FILE_NAME_MAXLEN + 1];	/* Downloaded file/resource */
	char		xml_dump[FILE_NAME_MAXLEN + 1];
	FILE		*fp;				/* File to be read (from xmldump) after some processing */
	FeedLinkAndOffset link_and_offset[NFEEDLINKANDOFFSETMAX];
	char		xml_dump_extra[FILE_NAME_MAXLEN + 1];
	FILE		*fp_extra;			/* File with extra info: item titles (or des) generated
							 * when ticker displays only des (or titles) */
	int		rss_ttl;
} Resource;

#define USER_MAXLEN		63
#define PSW_MAXLEN		63
#define AUTH_STR_MAXLEN		127

/* Do we need both these auth/proxy structs and auth/proxy params? redundant... */
typedef struct {
	gboolean	use_authentication;
	char		user[USER_MAXLEN + 1];
	char		psw[PSW_MAXLEN + 1];
	char		auth_str[AUTH_STR_MAXLEN + 1];
} Authentication;

#define PROXY_HOST_MAXLEN	127
#define PROXY_PORT_MAXLEN	15
#define PROXY_USER_MAXLEN	63
#define PROXY_PSW_MAXLEN	63
#define PROXY_AUTH_STR_MAXLEN	127
#define PROXY_STR_MAXLEN	255

typedef struct {
	gboolean	use_proxy;
	char		host[PROXY_HOST_MAXLEN + 1];
	char		port[PROXY_PORT_MAXLEN + 1];
	char		proxy_str[PROXY_STR_MAXLEN + 1];
	int		use_proxy_authentication;
	char		user[PROXY_USER_MAXLEN + 1];
	char		psw[PROXY_PSW_MAXLEN + 1];
	char		auth_str[PROXY_AUTH_STR_MAXLEN + 1];
} Proxy;

typedef struct {
	int		delay;
	int		shift_size;
	char		font_n_s[FONT_MAXLEN + 1];
	GdkColor	fg_color;
	guint16		fg_color_alpha;
	GdkColor	bg_color;
	guint16		bg_color_alpha;
	gint		win_x;
	gint		win_y;
	gint		win_w;
	gint		win_h;
	char		windec;
	char		always_on_top;
	gdouble		win_transparency;	/* 0.1 -> 1.0 */
	char		icon_in_taskbar;
	char		win_sticky;
	char		shadow;
	int		shadow_offset_x;
	int		shadow_offset_y;
	int		shadow_fx;
	char		line_delimiter[DELIMITER_MAXLEN + 1];
	char		cutline_delimiter[DELIMITER_MAXLEN + 1];
	char		special_chars;
	char		new_page_char;
	char		tab_char;
	int		rss_refresh;
	char		feed_title;
	char		feed_title_delimiter[DELIMITER_MAXLEN + 1];
	char		item_title;
	char		item_title_delimiter[DELIMITER_MAXLEN + 1];
	char		item_description;
	char		item_description_delimiter[DELIMITER_MAXLEN + 1];
	int		n_items_per_feed;
	char		strip_html_tags;
	char		upper_case_text;
	char		homefeed[FILE_NAME_MAXLEN + 1];
	char		open_link_cmd[FILE_NAME_MAXLEN + 1];
	char		open_link_args[FILE_NAME_MAXLEN + 1];
	char		clock;
	char		clock_font_n_s[FONT_MAXLEN + 1];
	GdkColor	clock_fg_color;
	guint16		clock_fg_color_alpha;
	GdkColor	clock_bg_color;
	guint16		clock_bg_color_alpha;
	char		disable_popups;
	char		pause_on_mouseover;
	char		disable_leftclick;
	char		mouse_wheel_scroll;	/* Apply to s (speed) / f (feed) / n (none) */
	char		enable_feed_ordering;
/* Do we need both these auth/proxy structs and auth/proxy params? redundant... */
	char		use_authentication;
	char		user[USER_MAXLEN + 1];
	char		use_proxy;
	char		proxy_host[PROXY_HOST_MAXLEN + 1];
	char		proxy_port[PROXY_PORT_MAXLEN + 1];
	char		use_proxy_authentication;
	char		proxy_user[PROXY_USER_MAXLEN + 1];
} Params;

/* Error codes */
typedef enum {
	OK = SOCKET_LASTERRORCODE + 1,

	RESOURCE_ERROR,
	RESOURCE_UNSPECIFIED,
	RESOURCE_NOT_FOUND,
	RESOURCE_INVALID,
	RESOURCE_FORMAT_ERROR,
	RESOURCE_NONE,

	OPTION_ERROR,
	OPTION_TOO_MANY,
	OPTION_INVALID,
	OPTION_UNKNOWN,
	OPTION_VALUE_INVALID,

	SELECTION_ERROR,
	SELECTION_EMPTY,

	FEED_ERROR,
	FEED_EMPTY,
	FEED_UNPARSABLE,
	RSS_NO_ITEM_ELEMENT,
	ATOM_NO_ENTRY_ELEMENT,
	FEED_DOWNLOAD_ERROR,
	FEED_FORMAT_ERROR,	/* rss 2.0 or atom format error */

	RENDER_ERROR,
	RENDER_NO_RESOURCE,
	RENDER_NULL_ENDINGSTR,
	RENDER_GETLINE_ERROR,
	RENDER_LINE_TOO_LONG,
	RENDER_CAIRO_IMAGE_SURFACE_TOO_WIDE,
	RENDER_CREATE_CAIRO_IMAGE_SURFACE_ERROR,
	RENDER_OTHER_ERROR,

	SHIFT2LEFT_NULL_CAIRO_IMAGE_SURFACE,

	FLIST_ERROR,
	LOAD_URL_LIST_ERROR,
	LOAD_URL_LIST_EMPTY_LIST,
	SAVE_URL_LIST_ERROR,

	CREATE_FILE_ERROR,
	OPEN_FILE_ERROR,

	XML_ERROR,
	XML_UNPARSABLE,
	XML_EMPTY,

	OPML_ERROR,

	CONNECT_TOO_MANY_ERRORS,

	HTTP_ERROR,
	HTTP_UNSUPPORTED_SCHEME,
	HTTP_NO_AUTH_CREDENTIALS,
	HTTP_NO_PROXY_AUTH_CREDENTIALS,

	/* http status codes */
	HTTP_CONTINUE,
	HTTP_SWITCH_PROTO,
	HTTP_MOVED,
	HTTP_USE_PROXY,
	HTTP_UNAUTHORIZED,
	HTTP_BAD_REQUEST,
	HTTP_FORBIDDEN,
	HTTP_NOT_FOUND,
	HTTP_PROXY_AUTH_REQUIRED,
	HTTP_INT_SERVER_ERROR,
	HTTP_NO_STATUS_CODE,
	HTTP_TOO_MANY_REDIRECTS,

	WIN32V_ERROR
} tickr_error_code;

/* tickr_main.c */
TickerEnv	*get_ticker_env();
Resource	*get_resource();
FList		*get_feed_list();
void		set_feed_list(FList *);
FList		*get_feed_selection();
void		set_feed_selection(FList *);
Params		*get_params();
int		get_instance_id();
void		check_main_win_always_on_top();
char		*get_feed_extra_info(int);
/*gboolean	params_have_been_changed(Params *, int);*/
gboolean	win_params_have_been_changed(Params *, int);
gint		update_everything();

/* tickr_resource.c */
int		build_feed_selection_from_feed_list();
void		current_feed();
void		first_feed();
void		last_feed();
gboolean	previous_feed();
gboolean	next_feed();
int		load_resource(Resource *, FList *);
int		format_resource(Resource *, const char *);
void		set_tickr_icon_to_dialog(GtkWindow *);
FILE		*open_new_datafile_with_name(const char *, const char *);
char		*get_datafile_full_name_from_name(const char *);
char		*get_imagefile_full_name_from_name(const char *);
char		*get_datadir_full_path();
char		*usr_home_dir();
#ifdef G_OS_WIN32
const char	*get_appdata_dir_utf8();
#endif

/* tickr_render.c */
cairo_surface_t *render_stream_to_surface(FILE *, FeedLinkAndOffset *, const Params *, int *);
char		*stream_to_htext(FILE *, char *, PangoLayout *, const Params *, int *);
char 		*void_stream_to_htext(char *, PangoLayout *);
int		get_fsize_from_layout_height(gint, const char *);
gint		get_layout_height_from_fnamesize(const char *);
gint		get_layout_width(PangoLayout *, const char *);
gint		get_layout_height(PangoLayout *, const char *);
void		pango_layout_get_pixel_size2(PangoLayout *, int *, int *);

/* tickr_params.c */
void		set_default_options(Params *);
int		get_config_file_options(Params *);
int		parse_options_array(Params *, int, const char *[]);
int		get_name_value_from_option(Params *, const char*);
void		save_to_config_file(const Params *);
int		get_gdk_color_from_hexstr(const char *, GdkColor *, guint16 *);
const char	*get_hexstr_from_gdk_color(const GdkColor *, const guint16 *);
void		split_font(const char *, char *, char *);
void		compact_font(char *, const char *, const char *);

/* tickr_clock.c */
void		display_time(const Params *);
gint		get_clock_width(const Params *);

/* tickr_feedparser.c */
int		get_feed(Resource *, const Params *);
int		parse_rss20_xml_file(FILE *, FILE *, const char *, FeedLinkAndOffset *link_and_offset,\
			const Params *);
/*int		parse_rss10_xml_file(FILE *, FILE *, const char *, FeedLinkAndOffset *link_and_offset,\
			const Params *);*/
int		parse_atom_xml_file(FILE *, FILE *, const char *, FeedLinkAndOffset *link_and_offset,\
			const Params *);
void		get_rss20_selected_elements1(xmlNode *, xmlDoc *);
void		get_rss20_selected_elements2(xmlNode *, xmlDoc *, FILE *, FILE *,\
			FeedLinkAndOffset *link_and_offset, const Params *);
/*void		get_rss10_selected_elements1(xmlNode *, xmlDoc *);
void		get_rss10_selected_elements2(xmlNode *, xmlDoc *, FILE *, FILE *,\
*			FeedLinkAndOffset *link_and_offset, const Params *);*/
void		get_atom_selected_elements1(xmlNode *, xmlDoc *);
void		get_atom_selected_elements2(xmlNode *, xmlDoc *, FILE *, FILE *,\
			FeedLinkAndOffset *link_and_offset, const Params *);
int		get_feed_info(const char *, char *, char *, char *);
void		get_xml_first_element(xmlNode *, xmlDoc *, char *, char *, int);

/* tickr_feedpicker.c */
void		highlight_and_go_to_row(GtkTreeView *, GtkTreeSelection *, int);
void		get_new_url(Resource *);

/* tickr_prefwin.c */
int		modify_params(Params *);

/* tickr_otherwins.c */
gint		esc_key_pressed(GtkWidget *, GdkEventKey *);
void		force_quit_dialog(GtkWidget *);
void		open_new_txt_file(Resource *resrc);
void		help_win();
void		about_win();
void		info_win(const char *, const char *, info_type, gboolean);
void		info_win_wait(const char *, int);
int		question_win(const char *);
int		question_win_at(const char *, int);
void		win_with_spinner(win_with_spinner_mode, const char *);
void		win_with_progress_bar(win_with_progress_bar_mode, const char *);

/* tickr_misc.c */
void		import_params();
void		export_params();
void		online_help();
void		warning(gboolean, int, ...);
void		dump_font_list();

/* tickr_hlptxt.c */
const char	**get_help_str0();
const char	**get_help_str1();
const char	**get_license_str1();
const char	*get_license_str2();

/* tickr_ompl.c */
void		import_opml_file();
char		*pick_opml_file();
int		parse_opml_xml_file(const char *);
void		get_opml_selected_element(xmlNode *, const char *, const char *);
void		export_opml_file();
char		*create_opml_str_from_feed_list_node(FList *);
int		save_str_as_opml_file(const char *);

/* tickr_http.c */
void		remove_chunk_info(char **);
int		connect_with_url(sockt *, char *);
int		fetch_resource(const char *, const char *, char *);
const char	*build_http_request(const char *, const char *, const char *,\
			const char *);
int 		get_http_response(sockt, const char *, const char *, const char *,\
			char **, char **, int *);
int		get_http_status_code(const char *);
const char	*get_http_header_value(const char *, const char *);
int		go_after_next_cr_lf(const char *);
int		go_after_next_empty_line(const char *);
int		get_http_chunk_size(const char *);
const char	*get_scheme_from_url(const char*);
const char	*get_host_from_url(const char*);
const char	*get_path_from_url(const char*);

/* tickr_socket.c */
/* Proto moved into tickr_socket.h */

/* tickr_connectwin.c */
void		init_authentication();
void		init_proxy();
void		compute_auth_and_proxy_str();
gint		connection_settings(connection_settings_page);
gboolean	get_use_authentication();
void		set_use_authentication(gboolean);
char		*get_http_auth_user();
char		*get_http_auth_psw();
char		*get_http_auth_str();
gboolean	get_use_proxy();
void		set_use_proxy(gboolean);
char		*get_proxy_host();
char		*get_proxy_port();
char		*get_proxy_str();
gboolean	get_use_proxy_auth();
void		set_use_proxy_auth(gboolean);
char		*get_proxy_auth_user();
char		*get_proxy_auth_psw();
char		*get_proxy_auth_str();

/* tickr_quickfeedpicker.c */
void		quick_feed_picker(int);

/* tickr_quicksetup.c */
void		quick_setup(Params *);

/* tickr_check4updates.c */
void		check_for_updates();
#endif /* INC_TICKR_H */
