/*
 * this func's prototype is in libetm / error.h
 * this func is not defined in libetm but in app and it handles errors
 * from libetm and app
 */
int big_error(int error_code, const char *str1, const char *str2, const char *str3, const char *str4)
{
	char	error_str[64 * 6 + 1];

	str_n_cpy(error_str, "FATAL ERROR: ", 16);
	if (error_code >= LIBETM_OK && error_code <= LIBETM_LASTERRORCODE)
		str_n_cat(error_str, "Libetm:", 16);
	else
		str_n_cat(error_str, "App:", 16);
	if (str1[0] != '\0') {
		str_n_cat(error_str, " ", 1);
		str_n_cat(error_str, str1, 63);
	}
	if (str2[0] != '\0') {
		str_n_cat(error_str, " ", 1);
		str_n_cat(error_str, str2, 63);
	}
	if (str3[0] != '\0') {
		str_n_cat(error_str, " ", 1);
		str_n_cat(error_str, str3, 63);
	}
	if (str4[0] != '\0') {
		str_n_cat(error_str, " ", 1);
		str_n_cat(error_str, str4, 63);
	}
	if (error_code >= LIBETM_OK && error_code <= LIBETM_LASTERRORCODE) {
		str_n_cat(error_str, ": ", 2);
		str_n_cat(error_str, get_lib_error_str(error_code), 62);
	}
	str_n_cat(error_str, " - Will quit now", 32);

	fprintf(stderr, "%s\n", error_str);
	exit(error_code);
}
