/*
 *	NEWS - GTK-based RSS Ticker - Copyright (C) Emmanuel Thomas-Maurin 2009-2011
 *	<manutm007@gmail.com>
 *
 * 	This program is free software: you can redistribute it and/or modify
 * 	it under the terms of the GNU General Public License as published by
 * 	the Free Software Foundation, either version 3 of the License, or
 * 	(at your option) any later version.
 *
 * 	This program is distributed in the hope that it will be useful,
 * 	but WITHOUT ANY WARRANTY; without even the implied warranty of
 * 	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * 	GNU General Public License for more details.
 *
 * 	You should have received a copy of the GNU General Public License
 * 	along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#define APP_NAME		"Tickr"
#define APP_CMD			"tickr"
#define APP_VERSION_NUMBER	"0.5.3"
#define APP_WEBSITE		"http://www.newsrssticker.com"
#define APP_SUPPORT_WEBSITE	"http://www.newsrssticker.com/help.php"
#define APP_DOWNLOAD_WEBSITE	"http://www.newsrssticker.com/download.php"
#define APP_SUPPORT_EMAIL	"newsrssticker@gmail.com"/*"contact@newsrssticker.com"*/

#define _GNU_SOURCE
#define _ISOC99_SOURCE

/*#define WITHOUT_GTK_SPINNER*/		/* for karmic and jaunty */
#define VERBOSE_OUTPUT
/*#define DEBUG_OUTPUT*/

/* for info_win_wait(..., timeout) */
/*#define INFO_WIN_WAIT_POS	GTK_WIN_POS_CENTER*/	/* same as for info_win() */
#define INFO_WIN_WAIT_POS	GTK_WIN_POS_CENTER_ON_PARENT
/*#define INFO_WIN_WAIT_POS	GTK_WIN_POS_NONE*/
#define INFO_WIN_WAIT_TIMEOUT	2000	/* in ms */

#define CONNECT_FAIL_MAX	5
#define CONNECT_FAIL_TIMEOUT	1

/* for correctness, 'uri' should be used instead of 'url' */

#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <errno.h>
#include <time.h>
#include <unistd.h>
#include <ctype.h>
#include <fcntl.h>
#include <sys/stat.h>
#include <gtk/gtk.h>
#include <gdk/gdkkeysyms.h>
#ifndef G_OS_WIN32
# include <grp.h>
# include <pwd.h>
# include <sys/socket.h>
# include <netdb.h>
# include <arpa/inet.h>
# include <sys/select.h>
#else
/*# include <windows.h>*/
# define _WIN32_WINNT	0x0501	/* win version = xp or higher */
# include <winsock2.h>
# include <ws2tcpip.h>
# include <rpcdce.h>
# include <iphlpapi.h>
# include <winreg.h>
# include <shlobj.h>
#endif
#ifndef G_OS_WIN32
# include <glib-2.0/glib/gstdio.h>
#else
# include <../glib-2.0/glib/gstdio.h>
#endif
#include <libxml/parser.h>
#include <libxml/tree.h>
#include "../libetm-0.4/libetm.h"

#define	USE_GUI			TRUE	/* to implement or not gui/menu features at compile time
					 * otherwise, cli only app */
#if USE_GUI
# define RESOURCE_NONE_QUIT	FALSE	/* to quit or not if no resource id specified */
# define OPTION_ERROR_QUIT	FALSE	/* to quit or not if unknown or invalid option(s) */
#else
# define RESOURCE_NONE_QUIT	TRUE
# define OPTION_ERROR_QUIT	TRUE
#endif

#define DRWA_WIDTH_MIN		100
#define DRWA_HEIGHT_MIN		10
#define TAB_SIZE		8
/* ok? previous value was FILE_NAME_MAXLEN = 255 - apply to both full file names and urls
 * maybe we should change this so that file name max len = 255 and url max len = 2047 (or more) */
#define FILE_NAME_MAXLEN	(2 * 1024 - 1)
/*#define URL_MAXLEN		(2 * 1024 - 1)*/	/* unused so far, see above */
#define FONT_NAME_MAXLEN	64
#define FONT_SIZE_MAXLEN	3
#define FONT_MAXLEN		FONT_NAME_MAXLEN + 1 + FONT_SIZE_MAXLEN
#define DELIMITER_MAXLEN	80
#define OPTION_NAME_MAXLEN	31
#define OPTION_VALUE_MAXLEN	MAX(MAX(FILE_NAME_MAXLEN, FONT_MAXLEN), DELIMITER_MAXLEN)
#define OPTION_MAXLEN		OPTION_NAME_MAXLEN + OPTION_VALUE_MAXLEN + 4	/* -name="value" */
#define NOPTIONSMAX		64	/* max number of options */
#define NURLMAX			512	/* max number of url's */
#define NFEEDLINKANDOFFSETMAX	256	/* max number of "open-able" links per feed */
#define LINKTAG_CHAR		'^'	/* ascii 5E - char used internally for links, removed from feed text */
#define TMPSTR_SIZE		(2 * 1024 - 1)	/* used for most tmp strings - must be large enough */
#ifndef G_OS_WIN32
# define SEPARATOR_CHAR		'/'
#else
# define SEPARATOR_CHAR		'\\'
#endif
#define FEED_TITLE_MAXLEN	60
/* 7-bit ascii - of course, the following ones must match */
#define TITLE_TAG_CHAR		'>'
#define TITLE_TAG_STR		">"
#define SELECTED_URL_CHAR	'*'
#define SELECTED_URL_STR	"*"
#define UNSELECTED_URL_CHAR	'-'
#define UNSELECTED_URL_STR	"-"

/* make sure this stuff is robust enough */
#define XPIXMAP_MAXWIDTH	(32 * 1024 - 1)	/* 32 K - 1 = max supported width for xpixmaps
						 * (not 64 k - 1 as sometimes uncorrectly specified)
						 */
#define LINE_MAXLEN		128	/* max length of a single line (see news_render.c) */
#define WORD_MAXLEN		32	/* max length of a word that won't get cut off */
#if (LINE_MAXLEN <= WORD_MAXLEN)
# error LINE_MAXLEN must be > WORD_MAXLEN
#endif
#define FONT_MAXSIZE		200

/*
 * file names, paths and dirs stuff
 *
 * linux version:	/usr/bin/
 *			/usr/share/APP_CMD/
 *			/usr/share/APP_CMD/pixmpas/
 *			/home/<user_name>/.APP_CMD/
 *
 * win32 version:	C:\Program files\APP_NAME	(also location for pixmaps)
 *			C:\...\Application Data\APP_NAME
 */
#ifndef G_OS_WIN32
# define NEWS_DIR_NAME		"."APP_CMD
#else
# define NEWS_DIR_NAME		APP_NAME
#endif
#define CONFIGFILE		APP_CMD"-conf"
#define URLLIST			APP_CMD"-url-list"
#define RESOURCEDUMP		APP_CMD"-resrc-dump"
#define XMLDUMP			APP_CMD"-xml-dump"
#define TMP1			"tmp1"
#define TMP2			"tmp2"
#ifndef G_OS_WIN32
# define STD_OUT		stdout
# define STD_ERR		stderr
#else
# define STD_OUT		stdout_fp
# define STDOUT_FILENAME	"stdout.txt"
# define STD_ERR		stderr_fp
# define STDERR_FILENAME	"stderr.txt"
#endif
#ifndef G_OS_WIN32
# define INSTALL_PATH		"/usr/share/"APP_CMD
# define IMAGES_PATH		INSTALL_PATH"/pixmaps"
#else
# define IMAGES_PATH		APP_NAME	/* actually not a path but a dir name */
#endif
#define NEWS_ICON		APP_CMD"-icon.png"
#define NEWS_LOGO		APP_CMD"-logo.png"
#define RSS_ICON		APP_CMD"-rss-icon.png"

/* default config values */
#define DELAY			8
#define SHIFTSIZE		1
#ifndef G_OS_WIN32
# define FONTNAME		"Sans"
#else
# define FONTNAME		"Arial Unicode MS"
#endif
#define FONTSIZE		"14"
#define FGCOLOR			"#ffffffff"	/* white */
#define BGCOLOR			"#36516280"	/* some translucent blue */
#define WIN_X			0
#define WIN_Y			0
#define WIN_W			1024	/* unused, we use get_ticker_env()->screen_w instead */
#define WIN_H			0	/* if = 0, determined by font size */
#define WINDEC			'n'
#define ALWAYSONTOP		'y'
#ifndef G_OS_WIN32
# define WINTRANSPARENCY	1.0
#else
# define WINTRANSPARENCY	0.8
#endif
#define ICONINTASKBAR		'y'
#define WINSTICKY		'n'
#define SHADOW			'y'
#define SHADOWOFFSET_X		4
#define SHADOWOFFSET_Y		2
#define SHADOWFX		2
#define LINEDELIMITER		" "
#define CUTLINEDELIMITER	"..."LINEDELIMITER
#define RSSREFRESH		15
#define RSSTITLE		'y'
#define RSSTITLEDELIMITER	"        "
#define RSSDESCRIPTION		'n'
#define RSSDESCRIPTIONDELIMITER	"        -        "
#define NITEMSPERFEED		5
/*#define READINLOOP		'y'*/
#define STRIPHTMLTAGS		'y'
#define UPPERCASETEXT		'n'
#define HOMEFEED		"http://newsrss.bbc.co.uk/rss/newsonline_world_edition/front_page/rss.xml"
#ifndef G_OS_WIN32
# define OPENLINKCMD		"firefox"	/* firefox on linux */
#else
# define OPENLINKCMD		""
#endif
#define OPENLINKARGS		""
#define CLOCK			'n'
#define CFONTNAME		FONTNAME
#define CFONTSIZE		"12"
#define CFGCOLOR		FGCOLOR
#define CBGCOLOR		BGCOLOR
#define SPECIALCHARS		'n'
#define NEWPG			'`'
#define TABCH			'~'
#define USEAUTHENTICATION	'n'
#define USER			""
#define USEPROXY		'n'
#define PROXYHOST		""
#define PROXYPORT		"8080"
#define USEPROXYAUTHENTICATION	'n'
#define PROXYUSER		""
#define DISABLEPOPUPS		'n'

/* typedef enum's */
typedef enum {
	SINGLE,
	MULTIPLE
} _selection_mode;

typedef enum {
	RESRC_TYPE_UNDETERMINED,
	RESRC_UNSPECIFIED,
	RESRC_URL,		/* will be fetched and xml-parsed */
	RESRC_FILE		/* will be processed as non-xml text file */
} _resrc_type;

typedef enum {
	RSS_FORMAT_UNDETERMINED,
	RSS_1_0,
	RSS_2_0,
	RSS_ATOM
} _rss_format;

typedef enum {
	TIME_RESET,
	TIME_CHECK
} check_time_mode;

typedef enum {
	INFO,
	INFO_WARNING,
	INFO_ERROR
} info_type;

typedef enum {
	WIN_WITH_SPINNER_OPEN,
	WIN_WITH_SPINNER_CLOSE
} spinner_win_mode;

typedef enum {
	AUTH_PAGE,
	PROXY_PAGE
} connection_settings_page;

/* typedef struct's */
/* usefull graphical (and other) ticker 'environment' values */
typedef struct {
	GdkScreen	*screen;			/* gdk screen for win */
	GdkVisual	*visual;
	gint		screen_w, screen_h;		/* screen width & height */
	gint		depth;				/* screen depth */
	GtkWidget 	*win;				/* top level window */
	GtkWidget	*drw_a, *drwa_clock;		/* drawing areas (main / clock) */
	gint		drwa_width, drwa_height;	/* main drawing area dimensions */
	gint		drwa_clock_width;		/* clock drawing area width */
	cairo_surface_t	*c_surf;			/* cairo image surface onto which text is rendered */
	gint 		surf_width, surf_height;	/* cairo image surface dimensions */
	char		active_link[FILE_NAME_MAXLEN + 1];
	/* these flags are checked by callback */
	gboolean	suspend_rq;			/* request for doing nothing */
	gboolean	compute_rq;			/* request for (re)computing everything (surface and win) */
	gboolean	reload_rq;			/* request for (re)loading resource */
	_selection_mode	selection_mode;			/* default = MULTIPLE, set to SINGLE internally if selection
							 * is unavalaible/empty or after picking a single feed */
	gboolean	stream_fully_read;		/* set/checked only in render_stream_to_surface() and
							 * shift2left_callback() */
} TickerEnv;

typedef struct {
	char		url[FILE_NAME_MAXLEN + 1];
	gint		offset_in_surface;
} FeedLinkAndOffset;

typedef struct {
	_resrc_type	type;				/* text file or url */
	_rss_format	format;				/* RSS 1.0, RSS 2.0 or Atom */
	char		id[FILE_NAME_MAXLEN + 1];	/* local = file name or remote = feed url */
	/* apply only to url/rss */
	_rss_format	rss_format;
	char		feed_title[FEED_TITLE_MAXLEN + 1];
	char		resrc_dump[FILE_NAME_MAXLEN + 1];	/* downloaded file/resource */
	char		xml_dump[FILE_NAME_MAXLEN + 1];
	FILE		*fp;				/* file to be read (from xmldump) after some processing, */
	FeedLinkAndOffset link_and_offset[NFEEDLINKANDOFFSETMAX];
	int		rss_ttl;
} Resource;

#define USER_MAXLEN		63
#define PSW_MAXLEN		63
#define AUTH_STR_MAXLEN		127

/* do we need both these auth/proxy structs and auth/proxy params? redundant... */
typedef struct {
	gboolean	use_authentication;
	char		user[USER_MAXLEN + 1];
	char		psw[PSW_MAXLEN + 1];
	char		auth_str[AUTH_STR_MAXLEN + 1];
} Authentication;

#define PROXY_HOST_MAXLEN	127
#define PROXY_PORT_MAXLEN	15
#define PROXY_USER_MAXLEN	63
#define PROXY_PSW_MAXLEN	63
#define PROXY_AUTH_STR_MAXLEN	127
#define PROXY_STR_MAXLEN	255

typedef struct {
	gboolean	use_proxy;
	char		host[PROXY_HOST_MAXLEN + 1];
	char		port[PROXY_PORT_MAXLEN + 1];
	char		proxy_str[PROXY_STR_MAXLEN + 1];
	int		use_proxy_authentication;
	char		user[PROXY_USER_MAXLEN + 1];
	char		psw[PROXY_PSW_MAXLEN + 1];
	char		auth_str[PROXY_AUTH_STR_MAXLEN + 1];
} Proxy;

typedef struct {
	int		delay;
	int		shift_size;
	char		font_n_s[FONT_MAXLEN + 1];
	GdkColor	fg_color;
	guint16		fg_color_alpha;
	GdkColor	bg_color;
	guint16		bg_color_alpha;
	gint		win_x;
	gint		win_y;
	gint		win_w;
	gint		win_h;
	char		windec;
	char		always_on_top;
	gdouble		win_transparency;	/* 0.1 -> 1.0 */
	char		icon_in_taskbar;
	char		win_sticky;
	char		shadow;
	int		shadow_offset_x;
	int		shadow_offset_y;
	int		shadow_fx;
	char		line_delimiter[DELIMITER_MAXLEN + 1];
	char		cutline_delimiter[DELIMITER_MAXLEN + 1];
	int		rss_refresh;
	char		rss_title;
	char		rss_title_delimiter[DELIMITER_MAXLEN + 1];
	char		rss_description;
	char		rss_description_delimiter[DELIMITER_MAXLEN + 1];
	int		n_items_per_feed;
	/*char		read_in_loop;*/
	char		strip_html_tags;
	char		upper_case_text;
	char		homefeed[FILE_NAME_MAXLEN + 1];
	char		open_link_cmd[FILE_NAME_MAXLEN + 1];
	char		open_link_args[FILE_NAME_MAXLEN + 1];
	char		clock;
	char		clock_font_n_s[FONT_MAXLEN + 1];
	GdkColor	clock_fg_color;
	guint16		clock_fg_color_alpha;
	GdkColor	clock_bg_color;
	guint16		clock_bg_color_alpha;
	char		special_chars;
	char		new_page_char;
	char		tab_char;
/* do we need both these auth/proxy structs and auth/proxy params? redundant... */
	char		use_authentication;
	char		user[USER_MAXLEN + 1];
	char		use_proxy;
	char		proxy_host[PROXY_HOST_MAXLEN + 1];
	char		proxy_port[PROXY_PORT_MAXLEN + 1];
	char		use_proxy_authentication;
	char		proxy_user[PROXY_USER_MAXLEN + 1];
	char		disable_popups;
} Params;

/* error codes */
typedef enum {
	OK = LIBETM_LASTERRORCODE + 1,

	RESOURCE_ERROR, RESOURCE_UNSPECIFIED, RESOURCE_NOT_FOUND,
	RESOURCE_INVALID, RESOURCE_FORMAT_ERROR, RESOURCE_NONE,

	OPTION_ERROR, OPTION_TOO_MANY, OPTION_INVALID, OPTION_UNKNOWN,
	OPTION_VALUE_INVALID,

	SELECTION_ERROR, SELECTION_EMPTY,

	RSS_ERROR, RSS_EMPTY, RSS_UNPARSABLE, RSS_CANTCREATEXMLDUMP,
	RSS_CANTREADXMLDUMP, RSS_NO_ITEM_ELEMENT, ATOM_NO_ENTRY_ELEMENT,
	RSS_DOWNLOAD_ERROR, RSS_FORMAT_ERROR,	/* xml or rss or atom format error */

	RENDER_ERROR, RENDER_NO_RESOURCE, RENDER_NULL_ENDINGSTR,
	RENDER_GETLINE_ERROR, RENDER_LINE_TOO_LONG,
	RENDER_CAIRO_IMAGE_SURFACE_TOO_WIDE,
	RENDER_CREATE_CAIRO_IMAGE_SURFACE_ERROR, RENDER_OTHER_ERROR,

	LOAD_URL_LIST_ERROR, SAVE_URL_LIST_ERROR,

	CREATE_FILE_ERROR, OPEN_FILE_ERROR,

	XML_ERROR, XML_UNPARSABLE, XML_EMPTY,

	OPML_ERROR,

	SOCK_ERROR, SOCK_CANT_CONNECT, SOCKET_SHOULD_BE_CLOSED,


	SELECT_ERROR, SELECT_TIMED_OUT, SELECT_TRUE, SELECT_FALSE,

	SEND_ERROR, RECV_ERROR, CONNECTION_CLOSED_BY_SERVER,
	CONNECT_TOO_MANY_ERRORS,

	HTTP_ERROR, HTTP_UNSUPPORTED_SCHEME, HTTP_XML_FORMAT_ERROR,
	HTTP_NO_AUTH_CREDENTIALS, HTTP_NO_PROXY_AUTH_CREDENTIALS,
	/* http status codes */
	HTTP_MOVED, HTTP_USE_PROXY, HTTP_UNAUTHORIZED, HTTP_BAD_REQUEST,
	HTTP_FORBIDDEN, HTTP_NOT_FOUND, HTTP_PROXY_AUTH_REQUIRED,
	HTTP_INT_SERVER_ERROR, HTTP_NO_STATUS_CODE,

	WIN32V_ERROR
} news_error_code;

/* news_main.c */
void		check_main_win_always_on_top();
void		check_time_load_resource();
TickerEnv	*get_ticker_env();
Resource	*get_resource();
Params		*get_params();
char		**get_get_selected_url();
int		get_instance_id();
gint		update_everything();

/* news_resource.c */
void		current_feed();
gboolean	previous_feed();
gboolean	next_feed();
void		first_feed();
void		last_feed();
int		load_resource(Resource *, char **);
int		format_resource(Resource *);
void		set_news_icon_to_dialog(GtkWindow *);
FILE		*open_new_datafile_with_name(const char *, const char *);
const char	*get_datafile_full_name_from_name(const char *);
const char	*get_imagefile_full_name_from_name(const char *);
const char	*get_datadir_full_path();
const char	*usr_home_dir();

/* news_render.c */
cairo_surface_t *render_stream_to_surface(FILE *, FeedLinkAndOffset *, const Params *, int *);
char		*stream_to_htext(FILE *, char *, PangoLayout *, const Params *, int *);
char 		*void_stream_to_htext(char *, PangoLayout *);
int		get_fsize_from_layout_height(gint, const char *);
gint		get_layout_height_from_fnamesize(const char *);
gint		get_layout_width(PangoLayout *, const char *);
gint		get_layout_height(PangoLayout *, const char *);
void		pango_layout_get_pixel_size2(PangoLayout *, int *, int *);

/* news_params.c */
void		set_default_options(Params *);
int		get_config_file_options(Params *);
int		parse_options_array(Params *, int, const char *[]);
int		get_name_value_from_option(Params *, const char*);
void		save_to_config_file(const Params *);
int		get_gdk_color_from_hexstr(const char *, GdkColor *, guint16 *);
const char	*get_hexstr_from_gdk_color(const GdkColor *, const guint16 *);
void		split_font(const char *, char *, char *);
void		compact_font(char *, const char *, const char *);

/* news_clock.c */
void		display_time(const Params *);
gint		get_clock_width(const Params *);

/* news_rss.c */
int		get_feed(Resource *, const Params *);
int		parse_rss20_xml_file(FILE *, const char *, FeedLinkAndOffset *link_and_offset,\
			const Params *);
/*int		parse_rss10_xml_file(FILE *, const char *, FeedLinkAndOffset *link_and_offset,\
			const Params *);*/
int		parse_atom_xml_file(FILE *, const char *, FeedLinkAndOffset *link_and_offset,\
			const Params *);
void		get_rss20_selected_elements1(xmlNode *, xmlDoc *);
void		get_rss20_selected_elements2(xmlNode *, xmlDoc *,\
			FILE *, FeedLinkAndOffset *link_and_offset, const Params *);
/*void		get_rss10_selected_elements1(xmlNode *, xmlDoc *);
void		get_rss10_selected_elements2(xmlNode *, xmlDoc *,\
			FILE *, FeedLinkAndOffset *link_and_offset, const Params *);*/
void		get_atom_selected_elements1(xmlNode *, xmlDoc *);
void		get_atom_selected_elements2(xmlNode *, xmlDoc *,\
			FILE *, FeedLinkAndOffset *link_and_offset, const Params *);
int		get_feed_info(const char *, char *, char *, char *);
void		get_xml_first_element(xmlNode *, xmlDoc *, char *, char *, int);

/* news_list.c */
char		**init_url_list();
char		**init_selected_url_list();
char		**get_url_list();
char		**get_selected_url_list();
int		load_selected_url_list(char **);
int		load_url_list(char **);
void		sort_url_list(char **, int);
int		save_url_list(char **);
void		remove_url_from_list(char **, int);
gboolean	str_has_title(char *);
char		*str_without_title(char *);

/* news_rsswin.c */
void		get_new_url(Resource *);

/* news_prefwin.c */
int		modify_params(Params *);

/* news_otherwins.c */
void		open_new_txt_file(Resource *resrc);
void		help_win();
void		about_win();
void		info_win(const char *, const char *, info_type, gboolean);
void		info_win_wait(const char *, int);
int		question_win(const char *);
int		question_win_always_on_top(const char *);
void		win_with_spinner(spinner_win_mode, const char *);

/* news_misc.c */
void		online_help();
void		warning(const char *, const char*, const char*, const char *, gboolean);
void		dump_font_list();

/* news_hlptxt.c */
#if USE_GUI
const char	**get_help_str0();
#endif
const char	**get_help_str1();
const char	**get_license_str1();
const char	*get_license_str2();

/* news_ompl.c */
void		import_opml_file();
char		*pick_opml_file();
int		parse_opml_xml_file(const char *);
void		get_opml_selected_element(xmlNode *, const char *, const char *);
void		export_opml_file();
char		*create_opml_str_from_url_list(char **);
int		save_str_as_opml_file(const char *);

/* news_http.c */
#ifndef G_OS_WIN32
int		connect_with_url(int *, char *);
#else
int		connect_with_url(SOCKET *, char *);
#endif
int		fetch_resource(const char *, const char *, char *);
const char	*build_http_request(const char *, const char *, const char *,\
			const char *);
int 		get_http_response(int, const char *, const char *, const char *,\
			char **, char **, int *);
int		get_http_status_code(const char *);
const char	*get_http_header_value(const char *, const char *);
int		go_after_next_cr_lf(const char *);
int		go_after_next_empty_line(const char *);
int		get_http_chunk_size(const char *);
const char	*get_scheme_from_url(const char*);
const char	*get_host_from_url(const char*);
const char	*get_path_from_url(const char*);
#ifndef G_OS_WIN32
int		connect_to_host(const char *, const char *);
int		writable_data_is_available_on_socket(int);
int		readable_data_is_available_on_socket(int);
int		send_full(int, const char *);
char		*recv_full(int, int *, int *);
#else
SOCKET		connect_to_host(const char *, const char *);
int		writable_data_is_available_on_socket(SOCKET);
int		readable_data_is_available_on_socket(SOCKET);
int		send_full(SOCKET, const char *);
char		*recv_full(SOCKET, int *, int *);
#endif

/* news_connectwin.c */
void		init_authentication();
void		init_proxy();
void		compute_auth_and_proxy_str();
gint		connection_settings(connection_settings_page);
gboolean	get_use_authentication();
void		set_use_authentication(gboolean);
char		*get_http_auth_user();
char		*get_http_auth_psw();
char		*get_http_auth_str();
gboolean	get_use_proxy();
void		set_use_proxy(gboolean);
char		*get_proxy_host();
char		*get_proxy_port();
char		*get_proxy_str();
gboolean	get_use_proxy_auth();
void		set_use_proxy_auth(gboolean);
char		*get_proxy_auth_user();
char		*get_proxy_auth_psw();
char		*get_proxy_auth_str();
