/***************************************************************************
                            th-device-pool.h
                            ----------------
    begin                : Tue Oct 12 2004
    copyright            : (C) 2004 by Tim-Philipp Mller
    email                : t.i.m@orange.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef _th_device_pool_h_included_
#define _th_device_pool_h_included_

#include "th-device-tracker.h"

#define TH_TYPE_DEVICE_POOL            (th_device_pool_get_type())
#define TH_DEVICE_POOL(obj)            (G_TYPE_CHECK_INSTANCE_CAST (obj,  TH_TYPE_DEVICE_POOL, ThDevicePool))
#define TH_DEVICE_POOL_CLASS(klass)    (G_TYPE_CHECK_CLASS_CAST (klass,   TH_TYPE_DEVICE_POOL, ThDevicePoolClass))
#define TH_IS_DEVICE_POOL(obj)         (G_TYPE_CHECK_INSTANCE_TYPE (obj,  TH_TYPE_DEVICE_POOL))
#define TH_IS_DEVICE_POOL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TH_TYPE_DEVICE_POOL))

typedef struct _ThDevicePool        ThDevicePool;
typedef struct _ThDevicePoolClass   ThDevicePoolClass;
typedef struct _ThDevicePoolPrivate ThDevicePoolPrivate;

struct _ThDevicePool
{
	GObject object;
	
	ThDevicePoolPrivate *priv;
};

struct _ThDevicePoolClass
{
	GObjectClass  parent_class;
};

/* functions */

GType             th_device_pool_get_type  (void) G_GNUC_CONST;

ThDevicePool     *th_device_pool_new (void);

void              th_device_pool_add_tracker (ThDevicePool *pool, ThDeviceTracker *tracker);

#endif /* _th_device_pool_h_included_ */

