/*
    Theseus - maximum likelihood superpositioning of macromolecular structures

    Copyright (C) 2004-2009 Douglas L. Theobald

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the:

    Free Software Foundation, Inc.,
    59 Temple Place, Suite 330,
    Boston, MA  02111-1307  USA

    -/_|:|_|_\-
*/

#ifndef PDBSTATS_SEEN
#define PDBSTATS_SEEN

#include "pdbMalloc.h"

void
CalcStats(CdsArray *cdsA);

void
CalcPreStats(CdsArray *cdsA);

void
CopyStats(CdsArray *cdsA1, CdsArray *cdsA2);

void
CalcDf(CdsArray *cdsA);

double
VarianceCds(CdsArray *cdsA);

double
VarianceCdsOcc(CdsArray *cdsA);

void
WriteTransformations(CdsArray *cdsA, char *outfile_name);

void
WriteVariance(CdsArray *cdsA, char *outfile_name);

void
Bfacts2PrVars(CdsArray *cdsA, int coord);

double
CalcPRMSD(CdsArray *cdsA);

double
CalcMLRMSD(CdsArray *cdsA);

double
SqrCdsDist(const Cds *cds1, const int atom1, const Cds *cds2, const int atom2);

double
SqrCdsDistMahal(const Cds *cds1, const int atom1,
                   const Cds *cds2, const int atom2,
                   const double *weights);

double
SqrCdsDistMahal2(const Cds *cds1, const int atom1,
                    const Cds *cds2, const int atom2,
                    const double weight);

double
SqrPDBCdsDist(PDBCds *cds1, int atom1, PDBCds *cds2, int atom2);

double
CdsDist(Cds *cds1, int atom1, Cds *cds2, int atom2);

double
VecMag(const double *vec);

double
CoordMag(const Cds *cds, const int vec);

double
SqrCoordMag(const Cds *cds, const int vec);

double
CoordMult(const Cds *cds1, const Cds *cds2, const int vec);

double
RadiusGyration(Cds *cds, const double *weights);

double
TraceCds(const Cds *cds1, const Cds *cds2, const double *weights);

void
CalcResiduals(CdsArray *cdsA);

void
StudentizeResiduals(CdsArray *cdsA);

void
PrintResiduals(CdsArray *cdsA);

void
WriteResiduals(CdsArray *cdsA, char *outfile_name);

double
Durbin_Watson(CdsArray *cdsA);

void
ExpectationVector(CdsArray *cdsA);

void
MomentsCds(CdsArray *cdsA);

void
SkewnessCds(CdsArray *cdsA);

void
KurtosisCds(CdsArray *cdsA);

double
CoordxMatxCoord(const double *v1, const double *v2, const double **sigma);

double
CalcANOVAF(CdsArray *cdsA);

double
CalcHierarchLogL(CdsArray *cdsA);

double
CalcLogL(CdsArray *cdsA);

double
CalcMgLogL(CdsArray *cdsA);

double
CalcParamNum(CdsArray *cdsA);

void
CalcAIC(CdsArray *cdsA);

void
CalcBIC(CdsArray *cdsA);

double
TrCdsInnerProd(Cds *cds, const int len);

double
TrCdsInnerProdWt(Cds *cds, const int len, const double *w);

double
TrCdsInnerProd2(Cds *cds1, Cds *cds2, const int len);

double
TrCdsInnerProdWt2(Cds *cds1, Cds *cds2, const int len, const double *w);

void
UnbiasMean(CdsArray *scratchA);

void
CalcNormResiduals(CdsArray *cdsA);

void
CalcNormResidualsLS(CdsArray *cdsA);

double
FrobTerm(CdsArray *cdsA);

#endif
