/*
    Theseus - maximum likelihood superpositioning of macromolecular structures

    Copyright (C) 2004-2009 Douglas L. Theobald

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the:

    Free Software Foundation, Inc.,
    59 Temple Place, Suite 330,
    Boston, MA  02111-1307  USA

    -/_|:|_|_\-
*/

#ifndef LAPACK_DLT_SEEN
#define LAPACK_DLT_SEEN

#ifdef MKL
    #define DGESVD dgesvd
    #define DGEEV  dgeev
    #define DSYEV  dsyev
    #define DSYEVR dsyevr
    #define DPOTRF dpotrf
    #define DPOTRI dpotri
    #define DSYTRI dsytri
    #define DSYTRF dsytrf
#else
    #define DGESVD dgesvd_
    #define DGEEV  dgeev_
    #define DSYEV  dsyev_
    #define DSYEVR dsyevr_
    #define DPOTRF dpotrf_
    #define DPOTRI dpotri_
    #define DSYTRI dsytri_
    #define DSYTRF dsytrf_
#endif


#ifdef MKL
    #include <mkl_lapack.h>
#else
	#if defined(__APPLE__)
		#include <vecLib/clapack.h>
		#include <vecLib/cblas.h>
	#else
		#include "clapack.h"
	#endif
#endif


int
Dgesvd(char jobu, char jobvt, int m, int n, 
       double **a, int lda, double *s,
       double **u, int ldu, 
       double **vt, int ldvt,
       double *work, int lwork);

int
dgesvd_opt_dest(double **a, int m, int n,
                double **u, double *s, double **vt);

int
dgesvd_opt_save(double **a, int m, int n,
                double **u, double *s, double **vt);

int
Dsyev(char jobz_v, char uplo_u,
      int n, double **amat, double *w,
      double *work, int lwork);

int
dsyev_opt_dest(double **amat, int n, double *w);

int
dsyev_opt_save(double **amat, int n, double **evecs, double *evals);

int
Dsyevr(char jobz, char range, char uplo, int n, 
       double **a, int lda,
       double vl, double vu,
       int il, int iu,
       double abstol, int m, double *w, 
       double **z__, int ldz, int *isuppz,
       double *work, int lwork,
       int *iwork, int liwork);

int
dsyevr_dest(double **mat, int n,
            int lower, int upper,
            double *evals, double **evecs,
            double abstol);

int
dsyevr_opt_save(const double **amat, int n,
                int lower, int upper,
                double *evals, double **evecs);

void
dpotr_invert(double **mat, int idim);

int
dpotrf_opt_dest(double **amat, int dim);

int
pseudoinv_sym(double **inmat, double **outmat, int n, const double tol);

#endif
