/*
    Theseus - maximum likelihood superpositioning of macromolecular structures

    Copyright (C) 2004-2008 Douglas L. Theobald

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the:

    Free Software Foundation, Inc.,
    59 Temple Place, Suite 330,
    Boston, MA  02111-1307  USA

    -/_|:|_|_\-
*/

#ifndef THESEUS_SEEN
#define THESEUS_SEEN

/* #undef __APPLE__ */

#if __STDC__ != 1
    #error NOT a Standard C environment
#endif

/* Temporary workaround for broken OSX system headers, shipped in 
 XCode 1.5. They're declaring stuff 'static inline', and this is 
 incompatible with the '-ansi' flag I pass to gcc.
   See Apple bug #3805571. */ 
#if defined(__APPLE__) && !defined(inline) 
    #define inline __inline__ 
#endif

#if defined(__APPLE__)
    #include <vecLib/clapack.h>
    #include <vecLib/cblas.h>
    #include <CoreServices/CoreServices.h>
#endif

#include <pthread.h>
#include <stdlib.h>
#include <string.h>
#include <stdio.h>
#include <unistd.h>
#ifdef __linux__
  #include <getopt.h>
#endif
#include <ctype.h>
#include <math.h>
#include <time.h>
#include <signal.h>
#include <dirent.h>
#include <sys/time.h>
#include <sys/stat.h>
#ifndef __MINGW32__
    #include <sys/resource.h>
#endif
#include <sys/types.h>
#include <gsl/gsl_sf_gamma.h>
#include "Error.h"
#include "CovMat.h"
#include "DLTmath.h"
#include "distfit.h"
#include "Embed.h"
#include "FragDist.h"
#include "pdbUtils.h"
#include "pdbMalloc.h"
#include "pdbStats.h"
#include "pdbIO.h"
#include "PCAstats.h"
#include "RandCoords.h"
#include "MultiPose.h"
#include "MultiPose2MSA.h"
#include "MultiPoseMix.h"
#include "termcol.h"


#if defined(DEBUG)
    #include <CoreServices/CoreServices.h>
    #if defined(__GNUC__)
        #include <ppc_intrinsics.h>
    #endif
    #define  TRACE0 /* set to 0 to disable the trace */
    #if TRACE
        #define START_TRACE() {int result = __mfspr(1023);}
    #else
        #define START_TRACE()
    #endif
#endif

static void
ParseCmdLine(int argc, char *argv[], CoordsArray *baseA);

void
PrintSuperposStats(CoordsArray *cdsA);

#endif
