/*
    Theseus - maximum likelihood superpositioning of macromolecular structures

    Copyright (C) 2004-2008 Douglas L. Theobald

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the:

    Free Software Foundation, Inc.,
    59 Temple Place, Suite 330,
    Boston, MA  02111-1307  USA

    -/_|:|_|_\-
*/

#ifndef PDBIO_SEEN
#define PDBIO_SEEN

#include "pdbMalloc.h"

int
ReadPDBCoords(char *pdbfile_name, PDBCoordsArray *pdbA, int coords_index, int modelnum);

/* void */
/* XPLORcorrections(PDBCoords *pdbcoords, int record); */

void
GetCoordsSelection(CoordsArray *baseA, PDBCoordsArray *pdbA);

CoordsArray
*GetCoordsSel(CoordsArray *baseA, PDBCoordsArray *pdbA);

/* CoordsArray */
/* *GetDefaultCoordsSel(CoordsArray *baseA, PDBCoordsArray *pdbA); */

/* static int */
/* atom_selxn(char *record, int mode); */

/* int */
/* range_selxn(int chainID, char *chains, int resSeq, int *lower, int *upper, int range_num); */

PDBCoordsArray
*GetPDBCoords(char **argv_array, int narguments, int fmodel);

void
PrintCoords(Coords *coords);

void
PrintPDBCoords(FILE *pdbfile, PDBCoords *pdbcoords);

void
PrintOccPDBCoords(FILE *pdbfile, PDBCoords *pdbcoords);

int
IsNameCAorP(char *name);

/* int */
/* ReadCoords(char *pdbfile_name, CoordsArray *cdsA, int coords_index, int modelnum); */

void
WriteModelFile(PDBCoordsArray *pdbA, char *outfile_name);

void
WriteTheseusModelFile(PDBCoordsArray *pdbA, Algorithm *algo, Statistics *stats, char *outfile_name);

void
WriteTheseusPDBFiles(PDBCoordsArray *pdbA, Algorithm *algo, Statistics *stats);

void
PrintTheseusModelHeader(FILE *pdbfile);

void
PrintModelFileStats(FILE *pdbfile, PDBCoordsArray *pdbA, Algorithm *algo, Statistics *stats);

void
WriteOlveModelFile(PDBCoordsArray *pdbA, Algorithm *algo, Statistics *stats, char *outfile_name);

void
WriteCoordsFile(Coords *coords, char *outfile_name);

void
WritePDBCoordsFile(PDBCoords *coords, char *file_name);

void
WriteAveCoordsFile(CoordsArray *cdsA, char *outfile_name);

void
WriteAvePDBCoordsFile(PDBCoordsArray *pdbA, char *outfile_name);

void
WriteBinPDBCoordsArray(PDBCoordsArray *pdbA);

PDBCoordsArray
*ReadBinPDBCoordsArray(char *filename);

void
WriteBinPDBCoords(PDBCoords *pdbcoords, FILE *fp);

void
ReadBinPDBCoords(PDBCoords *pdbcoords, FILE *fp);

void
WriteBinMatrix(double **mat, int rows, int cols, FILE *fp);

void
ReadBinMatrix(double **mat, FILE *fp);

#endif
