#
#  The archiver and the flag(s) to use when building archive (library)
#  If you system has no ranlib, set RANLIB = echo.
#
ARCH     = ar
ARCHFLAGS= -rvs
RANLIB   = ranlib

#MACOSX_DEPLOYMENT_TARGET=10.4
#export MACOSX_DEPLOYMENT_TARGET

# Intel Xeon Mac OSX
LOCALLIBDIR = /Users/theobal/lib
LIBS = -lgsl -ldistfit -lmsa -ldssplite -ldltmath -lDLTutils -ltheseus
SYSLIBS = -framework CoreServices
LIBDIR = -L./lib
LAPACKLIB = -framework vecLib
INSTALLDIR = /usr/local/bin
OPT = -g -msse3 -O3 -ffast-math -fstrict-aliasing -funroll-loops -fomit-frame-pointer -mfpmath=sse -ftree-vectorize #-march=nocona
WARN = -Wall -pedantic -std=c99 -Wstrict-aliasing=2 # -Wshadow -Wbad-function-cast -Wunreachable-code
CFLAGS = $(WARN) -DNDEBUG
CC = /usr/bin/gcc-4.2

# Intel Core Duo Mac OSX
# LIBS = -lgsl -ldistfit -lmsa -ldssplite -ldltmath -lDLTutils -ltheseus
# SYSLIBS = -framework CoreServices
# LIBDIR = -L./lib
# LAPACKLIB = -framework vecLib
# INSTALLDIR = /usr/local/bin
# OPT = -msse3 -O3 -ffast-math -fstrict-aliasing -funroll-loops -msse3 -fomit-frame-pointer -mfpmath=sse -ftree-vectorize #-march=prescott
# #OPT = -g -march=pentium-m -msse3 -mfpmath=sse -ftree-vectorize
# WARN = -Wall -pedantic -std=c99
# CFLAGS = $(WARN) -DNDEBUG
# CC = gcc

# PowerPC G4
# LIBS = -lgsl -ldistfit -lmsa -ldssplite -ldltmath -lDLTutils
# SYSLIBS = -framework CoreServices
# LIBDIR = -L./lib
# LAPACKLIB = -framework vecLib
# INSTALLDIR = /usr/local/bin
# OPT = -O3 -ffast-math
# #OPT = -fast -mcpu=7450
# WARN = -Wall -pedantic -std=c99
# CFLAGS = $(WARN) -faltivec
# #-bind_at_load
# CC = gcc

# PowerPC G5
# LIBS = -lgsl -ldistfit -lmsa -ldssplite -ldltmath -lDLTutils
# SYSLIBS = -framework CoreServices
# LIBDIR = -L./lib
# LAPACKLIB = -framework vecLib
# INSTALLDIR = /usr/local/bin
# OPT = -fast
# WARN = -Wall -pedantic -std=c99
# CFLAGS = $(WARN) -faltivec #-bind_at_load
# CC = gcc

# LINUX FC4 or FC6 x86 after "yum install blas-devel lapack-devel" and # dependencies
# SYSLIBS = -lm -lc
# LIBS = -ldistfit -lmsa -ldssplite -ldltmath -lDLTutils
# BLASLIB = -lblas
# LAPACKLIB = -llapack
# INSTALLDIR = /usr/local/bin
# OPT = -O3 -funroll-loops -ffast-math
# WARN = -Wall -pedantic -std=c99
# CFLAGS = $(WARN) -pthread
# CC = gcc

# Ubunut LINUX Xeon Quad-core x86_64 (2008-02-19)
# SYSLIBS = -static -lgfortran -lpthread -lgsl -lm -lc
# LIBS = -ldistfit -lmsa -ldssplite -ldltmath -lDLTutils -ltheseus
# LIBDIR = -L./lib
# BLASLIB = -lf77blas -latlas
# #BLASLIBDIR = -L/usr/local/lib/
# LAPACKLIB = -llapack
# #LAPACKLIBDIR = -L/usr/local/lib/
# INSTALLDIR = /usr/local/bin
# OPT = -msse3 -march=nocona -O3 -ffast-math -fstrict-aliasing -funroll-loops -fomit-frame-pointer -mfpmath=sse -ftree-vectorize
# WARN = -Wall -pedantic -std=c99
# CFLAGS = $(WARN) -pthread
# CC = gcc

# LINUX x86 generic 1 (2008-02-20) -- 32-bit, works on most machines
# SYSLIBS = -static -lgfortran -lpthread -lgsl -lm -lc
# LIBS = -ldistfit -lmsa -ldssplite -ldltmath -lDLTutils
# LIBDIR = -L/mnt/oplab/theobal/lib -L./lib
# #LIBDIR = -L/usr/lib -L./lib
# BLASLIB = -lblas_LINUX
# #BLASLIBDIR = -L/mnt/oplab/theobal/lib
# LAPACKLIB = -llapack_LINUX
# #LAPACKLIBDIR = -L/mnt/oplab/theobal/lib
# INSTALLDIR = /mnt/oplab/theobal/bin
# OPT = -O3 -ffast-math
# WARN = -Wall -pedantic -std=c99
# CFLAGS = $(WARN) -pthread -I/mnt/oplab/theobal/include
# CC = gcc

# LINUX x86 generic 2
# SYSLIBS = -static -lgfortran -lpthread -lgsl -lm -lc
# LIBS = -ldistfit -lmsa -ldssplite -ldltmath -lDLTutils
# LIBDIR = -L./lib
# BLASLIB = -lf77blas -latlas
# BLASLIBDIR = -L/usr/local/atlas/lib/
# LAPACKLIB = -llapack
# LAPACKLIBDIR = -L/usr/local/lapack-3.1.1/
# INSTALLDIR = /usr/local/bin
# OPT = -O3 -funroll-loops -ffast-math -fomit-frame-pointer
# WARN = -Wall -pedantic -std=c99
# CFLAGS = $(WARN) -pthread
# CC = gcc

# LINUX x86_64 RedHat Enterprise Linux 64-bit Pentium-D processor
# SYSLIBS = -static -lgfortran -lg2c -lpthread -lm -lc
# LIBS = -ldistfit -lmsa -ldssplite -ldltmath -lDLTutils
# LIBDIR = -L/usr/lib/gcc/x86_64-redhat-linux/3.4.3/ -L./lib
# BLASLIB = -lf77blas -latlas
# #BLASLIBDIR = -L/usr/local/ATLAS/lib/Linux_UNKNOWNSSE2_2/
# BLASLIBDIR = -L/usr/local/ATLAS_GCC4/lib/Linux_PENTIUM-D_GCC4/
# LAPACKLIB = -llapack_LINUX_GCC4
# LAPACKLIBDIR = -L/usr/local/LAPACK_GCC4/
# INSTALLDIR = /usr/local/bin #/home/theobal/bin
# OPT = -O3 -funroll-loops -ffast-math -fomit-frame-pointer -march=nocona
# WARN = -Wall -pedantic -std=c99
# CFLAGS = $(WARN) -pthread
# CC = gcc

# LINUX x86 Fedora Core 4 (redhat)
# SYSLIBS = -static -lg2c -lpthread -lm -lc
# LIBS = -ldistfit -lmsa -ldssplite -ldltmath -lDLTutils
# LIBDIR = -L/usr/lib/gcc-lib/i386-redhat-linux/3.2.3/ -L./lib
# BLASLIB = -lcblaswr -lcblas -latlas
# BLASLIBDIR = -L/mnt/oplab/theobal/bin/ATLAS/lib/Linux_P4SSE2/
# LAPACKLIB = -llapack_LINUX
# LAPACKLIBDIR = -L/mnt/oplab/theobal/bin/CLAPACK/
# INSTALLDIR = /mnt/oplab/theobal/bin
# OPT = -O3 -funroll-loops -ffast-math -malign-double
# WARN = -Wall -pedantic -std=c99
# CFLAGS = $(WARN) -pthread
# CC = gcc

# LINUX athlon
# SYSLIBS = -static -lg2c -lpthread -lm -lc
# LIBS = -ldistfit -lmsa -ldssplite -ldltmath -lDLTutils
# LIBDIR = -L/usr/lib/gcc-lib/i386-redhat-linux/3.2.3/ -L./lib
# BLASLIB = -lblas
# BLASLIBDIR = -L/mnt/oplab/theobal/bin/LAPACK_ATHLON/
# LAPACKLIB = -llapack
# LAPACKLIBDIR = -L/mnt/oplab/theobal/bin/LAPACK_ATHLON/
# INSTALLDIR = /mnt/oplab/theobal/bin
# OPT = -O3 -funroll-loops -ffast-math -march=athlon
# WARN = -Wall -pedantic -std=c99
# CFLAGS = $(WARN) -pthread
# CC = gcc

# FreeBSD
# CC = gcc
# SYSLIBS = -lgfortran -lgsl -lpthread -lm -lg2c -static
# LIBS = -ldistfit -lmsa -ldssplite -ldltmath -lDLTutils
# LIBDIR = -L./lib -L/home/dtheobald/lib -L/usr/local/lib/gcc-4.2.3/ -L/usr/local/lib/gcc-4.2.0/gcc/i386-portbld-freebsd6.2/4.2.0 -L/usr/local/lib/gcc-4.2.0
# INCDIR = -I/home/dtheobald/include
# INSTALLDIR = /usr/local/bin
# LAPACKLIB = -llapack_p
# LAPACKLIBDIR = -L/usr/local/lib
# BLASLIB = -lblas#-latlas_r
# BLASLIBDIR = -L/usr/local/lib
# WARN = -Wall -pedantic -std=c99
# CFLAGS = $(WARN) -pthread
# OPT = -O5 -funroll-loops -ffast-math -march=nocona -fomit-frame-pointer -fstrict-aliasing

# Win32 using mingw -- requires win32 pthread library
# SYSLIBS = -static -lpthreadGC2 -lg2c -lm
# LIBS = -ldistfit -lmsa -ldssplite -ldltmath -lDLTutils
# LIBDIR = -L./lib
# BLASLIB = -lblas
# LAPACKLIB = -llapack
# INSTALLDIR = /usr/local/bin
# OPT = -O3 -ffast-math -fstrict-aliasing -funroll-loops
# WARN = -Wall -pedantic -std=c99
# CFLAGS = $(WARN) -DNDEBUG
# CC = /usr/local/cross-tools/i386-mingw32msvc/bin/cc

# IRIX new 32-bit binary -- this probably needs some work to get it to compile
# SYSLIBS = -lm
# LIBS = -ldistfit -lmsa -ldssplite -ldltmath -lDLTutils
# LIBDIR = -L/usr/lib32/ -L./lib
# BLASLIB = 
# BLASLIBDIR =
# LAPACKLIB = -llapack_n32
# LAPACKLIBDIR = -L/home/wuttke/lib/
# INSTALLDIR = /home/wuttke/bin/
# OPT = -Ofast -n32 -mips4
# WARN = #-ansi #-fullwarn -woff 1209
# CFLAGS = $(WARN)
# CC = cc

