/*
    Theseus - maximum likelihood superpositioning of macromolecular structures

    Copyright (C) 2004-2008 Douglas L. Theobald

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the:

    Free Software Foundation, Inc.,
    59 Temple Place, Suite 330,
    Boston, MA  02111-1307  USA

    -/_|:|_|_\-
*/

#include <stdlib.h>
#include <string.h>
#include <stdio.h>
#include <math.h>
#include <float.h>
#include <time.h>
#include "DLTutils.h"
#include "FragCoords.h"
#include "QuarticHornFrag.h"
#include "FragDist.h"

void
FragDist(CoordsArray *cdsA, int fraglen, int center_ca)
{
    int             coord1, coord2;
    int             i, k, offset, tmp, num, count;
    FragCoords     *frag1 = NULL, *frag2 = NULL;
    double         *coeff = NULL;
    double          var;
    FILE           *distfile = NULL, *distfile2 = NULL;
    double          biggest;
    double         *array = NULL;

    distfile = fopen("frags_dist.txt", "w");
    distfile2 = fopen("frags_dist2.txt", "w");
    coeff = (double *) calloc(5, sizeof(double));

    frag1 = FragCoordsAlloc(fraglen);
    frag2 = FragCoordsAlloc(fraglen);

    offset = (fraglen - 1) / 2;

    num = cdsA->vlen * (mysquare(cdsA->cnum) - cdsA->cnum) / 2;

    array = (double *) calloc(num,  sizeof(double));

    biggest = 0.0;
    count = 0;
    for (coord1 = 0; coord1 < cdsA->cnum; ++coord1)
    {
        for (coord2 = coord1 + 1; coord2 < cdsA->cnum; ++coord2)
        {
            for (i = offset; i < cdsA->vlen - offset; ++i)
            {
                for (k = 0; k < fraglen; ++k)
                {
                    tmp = i + k - offset;
    
                    frag1->x[k] = cdsA->coords[coord1]->x[tmp];
                    frag1->y[k] = cdsA->coords[coord1]->y[tmp];
                    frag1->z[k] = cdsA->coords[coord1]->z[tmp];
    
                    frag2->x[k] = cdsA->coords[coord2]->x[tmp];
                    frag2->y[k] = cdsA->coords[coord2]->y[tmp];
                    frag2->z[k] = cdsA->coords[coord2]->z[tmp];
                }
    
                if (center_ca == 1)
                {
                    CenterFragCA(frag1);
                    CenterFragCA(frag2);
                }
                else if (center_ca == 2)
                {
                    CenterFrag(frag1);
                    CenterFrag(frag2);
                }
    
                var = QuarticHornFrag((const FragCoords *) frag1, (const FragCoords *) frag2, coeff);

                fprintf(distfile, "%-16.8e \n", var);
                fprintf(distfile2, "%-16.8e \n", sqrt(var));

                if (var > biggest)
                    biggest = var;

                array[count] = sqrt(var);
                ++count;
            }
        }
    }

    FragCoordsFree(frag1);
    FragCoordsFree(frag2);
    free(coeff);
    fclose(distfile);
    fclose(distfile2);
    free(array);

    exit(EXIT_SUCCESS);
}
