/*
    Theseus - maximum likelihood superpositioning of macromolecular structures

    Copyright (C) 2004-2007 Douglas L. Theobald

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the:

    Free Software Foundation, Inc.,
    59 Temple Place, Suite 330,
    Boston, MA  02111-1307  USA

    -/_|:|_|_\-
*/

#ifndef PDBUTILS_SEEN
#define PDBUTILS_SEEN

#include <pthread.h>
#include "pdbMalloc.h"
#include "Threads.h"

void
CoordsCopyXYZ(Coords *coords1, const Coords *coords2);

void
CoordsCopyAll(Coords *coords1, const Coords *coords2);

void
CoordsDelete(CoordsArray *cdsA, int omit);

void
CoordsArrayCopy(CoordsArray *cdsA1, const CoordsArray *cdsA2);

void
AlgorithmCopy(Algorithm *algo1, const Algorithm *algo2);

void
StatisticsCopy(Statistics *stats1, const Statistics *stats2);

void
CoordsCopy(Coords *coords1, const Coords *coords2);

void
PDBCoordsCopyAll(PDBCoords *coords1, const PDBCoords *coords2);

void
CoordsAdd(Coords *coords1, const Coords *coords2);

void
RotMatAddIp(double **mat1, const double **mat2);

void
NormJKCoords(CoordsArray *cdsA);

void
CopyCoords2PDB(PDBCoords *pdbcoords, const Coords *coords);

int
NMRCheckPDBCoordsArray(PDBCoordsArray *pdbA);

void
TransformPDBCoordsIp(PDBCoords *pdbcoords);

void
RotateCoordsIp(Coords *coords, const double **U);

void
RotateCoordsArrayIp(CoordsArray *cdsA, const double **rmat);

void
RotateCoordsOp(const Coords *coords1, const double **U, Coords *coords2);

void
TransformCoordsIp(Coords *coords);

void
ScaleCoords(Coords *coords, const double scale);

double
NormalizeWeights(double *w, int vlen);

double
NormalizeWeightsOcc(double *w, double *o, int vlen);

void
UnityWeightsCoordsArray(CoordsArray *cdsA);

void
CenMass(Coords *coords);

void
CenMassWtOp(Coords *coords, const CoordsArray *weights);

void
CenMassWtIp(Coords *coords, const double *weights);

void
CenMassCovOp(Coords *coords, const CoordsArray *weights);

void
CenMassCov(Coords *coords, const double **wtmat);

void
CenMassWt(Coords *coords);

void
CenMassOccVec(Coords *coords, double *cenmass);

void
CenMassWtIpOcc(Coords *coords, const double *wts);

void
ApplyCenter(Coords *coords, const double cenx, const double ceny, const double cenz);

void
ApplyNegCenterIp(Coords *coords);

void
ApplyCenterIp(Coords *coords);

void
ApplyCenterOp(Coords *coords1, const Coords *coords2);

void
TransCoordsIp(Coords *coords, const double *trans);

void
NegTransCoordsIp(Coords *coords, const double *trans);

void
EM_MissingCoords(CoordsArray *cdsA);

void
AveCoords_pth(CoordsArray *cdsA, AveData **avedata, pthread_t *callThd,
              pthread_attr_t *attr, const int thrdnum);

void
AveCoords(CoordsArray *cdsA);

void
AveCoordsOcc(CoordsArray *cdsA);

void
CalcCoordsPrincAxes(Coords *coords, double **rotmat);

void
SumCoordsTB(CoordsArray *cdsA, const int exclude);

double
*ConcatQuatsIp(const double *quat1, double *quat2);

#endif
