/*
    Theseus - maximum likelihood superpositioning of macromolecular structures

    Copyright (C) 2004-2007 Douglas L. Theobald

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the:

    Free Software Foundation, Inc.,
    59 Temple Place, Suite 330,
    Boston, MA  02111-1307  USA

    -/_|:|_|_\-
*/

#ifndef RANDCOORDS_SEEN
#define RANDCOORDS_SEEN

void
rand_rotation(const double *x, double **M);

void
rand_translation(double *x, double ave);

void
RandRotCoordsArray(CoordsArray *cdsA);

void
RandTransCoordsArray(CoordsArray *cdsA, const double var);

double
thirdOpoly_dev(const double b, const double c, const double d);

int
quadratic_solver(const double a, const double b, const double c,
                 double *x1, double *x2);

void
RandCoords(CoordsArray *cdsA);

void
RandFillMat(double **mat, int rows, int cols, int randmeth,
            double b, double c, double d);

double
RandScale(double variance, int randmeth, double a, double b);

PDBCoordsArray
*GetRandPDBCoords(char *pdbfile_name, int cnum, int vlen0);

PDBCoordsArray
*MakeRandPDBCoords(int cnum, int vlen, double *radii);

void
RandUsage(void);

#endif
