/**
 * @file thlangdata.cxx
 * Therion language translations module.
 *
 * THIS FILE IS GENERATED AUTOMATICALLY, DO NOT MODIFY IT !!!
 */

 
typedef const char * thlang_pchar;


static const thstok thtt_lang [] = {
  {"bg", THLANG_BG},
  {"cz", THLANG_CZ},
  {"de", THLANG_DE},
  {"el", THLANG_EL},
  {"en", THLANG_EN},
  {"en_UK", THLANG_EN_UK},
  {"en_US", THLANG_EN_US},
  {"es", THLANG_ES},
  {"fr", THLANG_FR},
  {"it", THLANG_IT},
  {"mi", THLANG_MI},
  {"pt", THLANG_PT},
  {"pt_BR", THLANG_PT_BR},
  {"pt_PT", THLANG_PT_PT},
  {"ru", THLANG_RU},
  {"sk", THLANG_SK},
  {"sq", THLANG_SQ},
  {NULL, THLANG_UNKNOWN},
};



static const thlang_pchar thlang__cxxids []  = {
  "THLANG_BG",
  "THLANG_CZ",
  "THLANG_DE",
  "THLANG_EL",
  "THLANG_EN",
  "THLANG_EN_UK",
  "THLANG_EN_US",
  "THLANG_ES",
  "THLANG_FR",
  "THLANG_IT",
  "THLANG_MI",
  "THLANG_PT",
  "THLANG_PT_BR",
  "THLANG_PT_PT",
  "THLANG_RU",
  "THLANG_SK",
  "THLANG_SQ",
};



static const int thlang__alternatives [] = {
  THLANG_UNKNOWN,
  THLANG_UNKNOWN,
  THLANG_UNKNOWN,
  THLANG_UNKNOWN,
  THLANG_UNKNOWN,
  THLANG_EN,
  THLANG_EN,
  THLANG_UNKNOWN,
  THLANG_UNKNOWN,
  THLANG_UNKNOWN,
  THLANG_UNKNOWN,
  THLANG_UNKNOWN,
  THLANG_PT,
  THLANG_PT,
  THLANG_UNKNOWN,
  THLANG_UNKNOWN,
  THLANG_UNKNOWN,
};



static const thstok thtt__texts [161] = {
  {"area bedrock",0},
  {"area blocks",1},
  {"area clay",2},
  {"area debris",3},
  {"area flowstone",4},
  {"area ice",5},
  {"area moonmilk",6},
  {"area pebbles",7},
  {"area sand",8},
  {"area snow",9},
  {"area sump",10},
  {"area water",11},
  {"line border",12},
  {"line border:presumed",13},
  {"line border:temporary",14},
  {"line border:visible",15},
  {"line ceiling-meander",16},
  {"line ceiling-step",17},
  {"line chimney",18},
  {"line contour",19},
  {"line floor-meander",20},
  {"line floor-step",21},
  {"line flowstone",22},
  {"line gradient",23},
  {"line label",24},
  {"line map-connection",25},
  {"line moonmilk",26},
  {"line overhang",27},
  {"line pit",28},
  {"line rock-border",29},
  {"line rock-edge",30},
  {"line section",31},
  {"line slope",32},
  {"line survey",33},
  {"line wall",34},
  {"line wall:bedrock",35},
  {"line wall:blocks",36},
  {"line wall:clay",37},
  {"line wall:debris",38},
  {"line wall:flowstone",39},
  {"line wall:ice",40},
  {"line wall:moonmilk",41},
  {"line wall:overlying",42},
  {"line wall:pebbles",43},
  {"line wall:pit",44},
  {"line wall:presumed",45},
  {"line wall:sand",46},
  {"line wall:underlying",47},
  {"line wall:unsurveyed",48},
  {"line water-flow",49},
  {"line water-flow:conjectural",50},
  {"line water-flow:intermittent",51},
  {"line water-flow:permanent",52},
  {"point air-draught",53},
  {"point air-draught:summer",54},
  {"point air-draught:winter",55},
  {"point altitude",56},
  {"point anastomosis",57},
  {"point anchor",58},
  {"point aragonite",59},
  {"point archeo-material",60},
  {"point bedrock",61},
  {"point blocks",62},
  {"point breakdown-choke",63},
  {"point bridge",64},
  {"point camp",65},
  {"point cave-pearl",66},
  {"point clay",67},
  {"point clay-choke",68},
  {"point clay-tree",69},
  {"point continuation",70},
  {"point crystal",71},
  {"point curtain",72},
  {"point date",73},
  {"point debris",74},
  {"point dig",75},
  {"point dimensions",76},
  {"point disk",77},
  {"point entrance",78},
  {"point fixed-ladder",79},
  {"point flowstone",80},
  {"point flowstone-choke",81},
  {"point flute",82},
  {"point gradient",83},
  {"point guano",84},
  {"point gypsum",85},
  {"point gypsum-flower",86},
  {"point height",87},
  {"point height:negative",88},
  {"point height:positive",89},
  {"point height:unsigned",90},
  {"point helictite",91},
  {"point ice",92},
  {"point ice-pillar",93},
  {"point ice-stalactite",94},
  {"point ice-stalagmite",95},
  {"point karren",96},
  {"point label",97},
  {"point low-end",98},
  {"point moonmilk",99},
  {"point narrow-end",100},
  {"point no-equipment",101},
  {"point paleo-material",102},
  {"point passage-height",103},
  {"point passage-height:both",104},
  {"point passage-height:negative",105},
  {"point passage-height:positive",106},
  {"point passage-height:unsigned",107},
  {"point pebbles",108},
  {"point pillar",109},
  {"point popcorn",110},
  {"point raft",111},
  {"point raft-cone",112},
  {"point remark",113},
  {"point rimstone-dam",114},
  {"point rimstone-pool",115},
  {"point root",116},
  {"point rope",117},
  {"point rope-ladder",118},
  {"point sand",119},
  {"point scallop",120},
  {"point section",121},
  {"point sink",122},
  {"point snow",123},
  {"point soda-straw",124},
  {"point spring",125},
  {"point stalactite",126},
  {"point stalagmite",127},
  {"point station",128},
  {"point station-name",129},
  {"point station:fixed",130},
  {"point station:natural",131},
  {"point station:painted",132},
  {"point station:temporary",133},
  {"point steps",134},
  {"point traverse",135},
  {"point vegetable-debris",136},
  {"point wall-altitude",137},
  {"point wall-calcite",138},
  {"point water",139},
  {"point water-flow",140},
  {"point water-flow:intermittent",141},
  {"point water-flow:paleo",142},
  {"point water-flow:permanent",143},
  {"title carto",144},
  {"title carto (plural)",145},
  {"title cave depth",146},
  {"title cave length",147},
  {"title color-legend-altitude",148},
  {"title color-legend-map",149},
  {"title explo",150},
  {"title explo (plural)",151},
  {"title legend",152},
  {"title preview above",153},
  {"title preview below",154},
  {"title surface bitmap",155},
  {"title topo",156},
  {"title topo (plural)",157},
  {"units ft",158},
  {"units m",159},
  {NULL, -1},
};



static thlang_pchar thlang__translations [160][17] = {
  {
    "основна скала",
    "pevná skála",
    "Deckgebirge",
    "πέτρωμα",
    "bedrock",
    NULL,
    NULL,
    "roca madre",
    "roche",
    "roccia",
    NULL,
    "rocha encaixante",
    NULL,
    NULL,
    "коренная порода",
    "pevná skala",
    "shtrat shkembi",
  },
  {
    "блокаж",
    "skalní bloky",
    "Fläche mit Blöcken",
    "ογκόλιθοι",
    "blocks, breakdown",
    NULL,
    NULL,
    "bloques",
    "blocs",
    "massi",
    "pakaru a kōhatunui",
    "blocos",
    NULL,
    NULL,
    "навал глыб",
    "skalné bloky",
    "blloqe",
  },
  {
    "глина",
    "bahno",
    "Lehmfläche",
    "άργιλος",
    "clay",
    NULL,
    NULL,
    "arcilla",
    "argile",
    "argilla",
    "oneuku",
    "lama",
    NULL,
    NULL,
    "глина",
    "íl",
    "argjil",
  },
  {
    "чакъл",
    "štěrk",
    "Schuttfläche",
    "χαλάσματα",
    "debris",
    NULL,
    NULL,
    "derrubios",
    "débris",
    "detriti",
    "otaota",
    "escombros",
    NULL,
    NULL,
    "щебень",
    "štrk",
    "mbetje-gurresh",
  },
  {
    "каменен водопад",
    "sintrové náteky",
    "flächiger Sinter",
    "σταλαγμιτικό υλικό δαπέδου",
    "flowstone",
    NULL,
    NULL,
    "concreción",
    "concrétion",
    "concrezione",
    NULL,
    "escorrimento",
    NULL,
    NULL,
    "натечный каскад",
    "sintrové náteky",
    "gurre-rrjedhes",
  },
  {
    "лед",
    "led",
    "Eisfläche",
    "πάγος",
    "ice",
    NULL,
    NULL,
    "hielo",
    "glace",
    "ghiaccio",
    "kōpaka",
    "gelo",
    NULL,
    NULL,
    "лёд",
    "ľad",
    "akull",
  },
  {
    "пещерно мляко",
    "nickamínek",
    "Bergmilch",
    "γάλα σπηλαίου",
    "moonmilk",
    NULL,
    NULL,
    NULL,
    "mondmilch",
    "moonmilk",
    NULL,
    NULL,
    NULL,
    NULL,
    "лунное молоко",
    "náteky mäkkého sintra",
    "qumesht-hena",
  },
  {
    "камъчета",
    "valouny",
    "Kiesfläche",
    "χαλίκια",
    "pebbles",
    NULL,
    NULL,
    "cantos rodados",
    "galets/pierres",
    "ciotoli",
    "nga kōhatu iti",
    "seixos",
    NULL,
    NULL,
    "галька",
    "okrúhliaky",
    "gurralece",
  },
  {
    "пясък",
    "písek",
    "Sandfläche",
    "άμμος",
    "sand",
    NULL,
    NULL,
    "arena",
    "sable",
    "sabbia",
    "onepū",
    "areia",
    NULL,
    NULL,
    "песок",
    "piesok",
    "rane",
  },
  {
    "сняг",
    "sníh",
    "Schneefläche",
    "χιόνι",
    "snow",
    NULL,
    NULL,
    "nieve",
    "neige",
    "neve",
    "huka",
    "neve",
    NULL,
    NULL,
    "снег",
    "sneh",
    "bore",
  },
  {
    "сифон",
    "sifon",
    "Siphonfläche",
    "σιφόνι",
    "sump",
    NULL,
    NULL,
    "sifón",
    "siphon",
    "sifone",
    "kari a wai",
    "sifão",
    NULL,
    NULL,
    "сифон",
    "zatopená plocha (sifón)",
    "sifoni",
  },
  {
    "вода",
    "vodní plocha",
    "Wasserfläche",
    "νερό",
    "water",
    NULL,
    NULL,
    "agua",
    "eau",
    "acqua",
    "wai",
    "água",
    NULL,
    NULL,
    "вода",
    "vodná plocha",
    "uje",
  },
  {
    "граница",
    "ohraničení",
    "Begrenzung",
    "άκρη",
    "border",
    NULL,
    NULL,
    "límite",
    "bord",
    "bordo",
    "rohe",
    "borda",
    NULL,
    NULL,
    "граница",
    "ohraničenie",
    "kufiri",
  },
  {
    "предполагаема граница",
    "předpokládané ohraničení",
    "geschätzte Begrenzung",
    "υποθετική άκρη",
    "presumed border",
    NULL,
    NULL,
    "límite supuesto",
    "bord, supposé",
    "bordo presunto",
    "rohe whakaaringa whakaaro",
    "borda presumida",
    NULL,
    NULL,
    "предполагаемая граница",
    "predpokladané ohraničenie",
    "kufij I supozuar",
  },
  {
    "временна граница",
    "nestálé ohraničení",
    "vorübergehende Begrenzung",
    "προσωρινή άκρη",
    "temporary border",
    NULL,
    NULL,
    "límite temporal",
    "bord, temporaire",
    "bordo temporaneo",
    "rohe mo te wā",
    "borda temporária",
    NULL,
    NULL,
    "временная граница",
    "nestále ohraničenie",
    "kufij i perkohshem",
  },
  {
    "видима граница",
    "ohraničení",
    "sichtbare Begrenzung",
    "άκρη",
    "border",
    NULL,
    NULL,
    "límite",
    "bord",
    "bordo",
    "rohe",
    "borda",
    NULL,
    NULL,
    "видимая граница",
    "ohraničenie",
    "vije kufiri-e dukshme",
  },
  {
    "меандър, канал в тавана",
    "stropní meandr",
    "Deckenmäander",
    "μαίανδρος οροφής",
    "ceiling meander",
    NULL,
    NULL,
    "meandro inverso",
    "méandre de plafond",
    "canale di volta",
    "kopiko tuanui",
    "meandro no teto",
    "meandro no teto",
    "meandro no tecto",
    "меандр, канал в потолке",
    "stropný meander",
    "rrjedhe uji gjarperore ne tavan",
  },
  {
    "ниша в тавана",
    "změna výšky stropu",
    "Deckenstufe",
    "σκαλοπάτι οροφής",
    "ceiling step",
    NULL,
    NULL,
    "resalte inverso",
    "marche de plafond",
    "gradino a soffitto",
    "tapuae ki te tuanui",
    "degrau no teto",
    "degrau no teto",
    "degrau no tecto",
    "уступ потолка",
    "zmena výšky stropu",
    "shkalle ne tavan",
  },
  {
    "комин",
    "komín",
    "Schlot",
    "καμινάδα",
    "chimney",
    NULL,
    NULL,
    "chimenea",
    "cheminée",
    "camino",
    "tumera",
    "chaminé",
    NULL,
    NULL,
    "труба",
    "komín",
    "oxhak",
  },
  {
    "контур",
    "vrstevnice",
    "Höhenlinie",
    "ισοϋψής",
    "contour",
    NULL,
    NULL,
    "contorno",
    "contour",
    "contorno",
    "koru",
    "contorno",
    NULL,
    NULL,
    "контур",
    "vrstevnica",
    "kontura",
  },
  {
    "меандър, канал в пода",
    "meandr ve dně",
    "Bodenmäander",
    "μαίανδρος δαπέδου",
    "floor meander",
    NULL,
    NULL,
    "meandro",
    "méandre au sol",
    "meandro",
    "kopiko",
    "meandro no piso",
    NULL,
    NULL,
    "меандр, канал в полу",
    "meander v dne",
    "rrjedhe uji gjarperore",
  },
  {
    "праг",
    "stupeň",
    "Bodenstufe",
    "σκαλοπάτι",
    "floor step",
    NULL,
    NULL,
    "resalte",
    "marche",
    "gradino",
    "tapuae",
    "degrau",
    NULL,
    NULL,
    "уступ пола",
    "stupeň",
    "shkalle ne dysheme",
  },
  {
    "каменен водопад",
    "sintrové náteky",
    "flächiger Sinter",
    "σταλαγμιτικό υλικό δαπέδου",
    "flowstone",
    NULL,
    NULL,
    "concreción",
    "concrétion",
    "concrezione",
    "pari kōhatu",
    "escorrimento",
    NULL,
    NULL,
    "натечный каскад",
    "sintrové náteky",
    "gurre-rrjedhes",
  },
  {
    "наклон на галерията",
    "sklon chodby",
    "Gefälle",
    "κλίση στοάς",
    "passage gradient",
    NULL,
    NULL,
    "gradiente",
    "pente",
    "scivolo",
    "heke",
    "declividade da galeria",
    NULL,
    NULL,
    "уклон хода",
    "sklon chodby",
    "pjertesia e kalimit",
  },
  {
    "етикет",
    "pojmenování",
    "Beschriftung",
    "περιγραφή",
    "label",
    NULL,
    NULL,
    "etiqueta",
    "libellé",
    "etichetta",
    "ingoa",
    "indicação",
    NULL,
    NULL,
    "текстовая метка",
    "pomenovanie",
    "mbishkrim",
  },
  {
    "свързване на карти",
    "spojení map",
    "zusammenhängende Pläne",
    "ένωση χαρτών",
    "map connection",
    NULL,
    NULL,
    NULL,
    "jonction de carte",
    "riporto di mappa",
    "mahere whenua ki te hui",
    NULL,
    NULL,
    NULL,
    "линия выноса",
    "prepojenie máp",
    "lidhjet ne harta",
  },
  {
    "пещерно мляко",
    "nickamínek",
    "Bergmilch",
    "γάλα σπηλαίου",
    "moonmilk",
    NULL,
    NULL,
    NULL,
    "mondmilch",
    "moonmilk",
    "mirika marama",
    NULL,
    NULL,
    NULL,
    "лунное молоко",
    "náteky mäkkého sintra",
    "qumesht-hena",
  },
  {
    "скална площадка",
    "převis",
    "Überhang",
    "προέκταση οροφής",
    "overhang",
    NULL,
    NULL,
    "extraplomo",
    "surplomb",
    "sporgenza",
    "tauwharenga",
    "projeção",
    "projeção",
    "projecção",
    "нависание потолка",
    "previs",
    "varese",
  },
  {
    "кладенец",
    "propast",
    "Schacht",
    "πηγάδι",
    "pitch",
    "pitch",
    "pit",
    "pozo",
    "puits",
    "pozzo",
    "tupari",
    "desnível",
    NULL,
    NULL,
    "колодец",
    "priepasť",
    "ngjitje",
  },
  {
    "външен ръб на камък",
    "kameny",
    "Umriss eines Felsens",
    "περίγραμμα βράχου",
    "rock border",
    NULL,
    NULL,
    "contorno bloque",
    "bord d’un rocher",
    "bordo masso",
    "rohe kōhatu",
    "lateral da rocha",
    NULL,
    NULL,
    "внешний кромка глыбы",
    "obrys kameňa",
    "kufij shkembinjsh",
  },
  {
    "вътрешен ръб на камък",
    "hrany kamenů",
    "Struktur eines Felsens",
    "άκρη βράχου",
    "rock edges",
    NULL,
    NULL,
    "arista bloque",
    "arête d’un rocher",
    "spigolo masso",
    "mata kohatu",
    "bordas da rocha",
    NULL,
    NULL,
    "внутренняя кромка глыбы",
    "hrany kameňa",
    "skaji I shkembit",
  },
  {
    "напречно сечение",
    "příčný řez",
    "Schnittlinie",
    "τομή",
    "cross-section",
    NULL,
    NULL,
    "sección",
    "section",
    "sezione trasversale",
    "taha papahanga",
    "corte",
    NULL,
    NULL,
    "выносная линия сечения",
    "priečny rez",
    "kryq-ndarje",
  },
  {
    "склон",
    "svah",
    "Hangform",
    "κλίση",
    "slope",
    NULL,
    NULL,
    "pendiente",
    "pente",
    "scivolo",
    "tupari",
    "declive",
    NULL,
    NULL,
    "склон",
    "šikmá plocha",
    "breg",
  },
  {
    "антена",
    "polygonový tah",
    "Messzug",
    "γραμμή χαρτογράφησης",
    "survey lines",
    NULL,
    NULL,
    "poligonal",
    "visée topo",
    "poligonale",
    "ruri rārangi",
    "linha de topografia",
    NULL,
    NULL,
    "нитка хода",
    "polygónový ťah",
    "vijat matese-vrojtuese",
  },
  {
    "стена",
    "stěna",
    "Wand",
    "τοίχος",
    "wall",
    NULL,
    NULL,
    "pared",
    "mur",
    "parete",
    "tarā",
    "parede",
    NULL,
    NULL,
    "стена",
    "stena",
    "muri",
  },
  {
    "стена (основна скала)",
    "stěna",
    "Wand zum Deckgebirge",
    "τοίχος",
    "wall",
    NULL,
    NULL,
    "pared",
    "mur",
    "roccia",
    "tarā",
    "parede",
    NULL,
    NULL,
    "стена",
    "stena",
    "shkembi-muri",
  },
  {
    "стена - блокаж",
    "zával",
    "Wand aus Versturz",
    "ογκόλιθοι",
    "blocks, breakdown",
    NULL,
    NULL,
    "bloques",
    "effrondrement",
    "massi",
    "pakaru",
    "desmoronamento",
    NULL,
    NULL,
    "глыбы",
    "stena tvorená závalom",
    "blloqe",
  },
  {
    "глина",
    "bahno",
    "Wand aus Lehm",
    "άργιλος",
    "clay",
    NULL,
    NULL,
    "arcilla",
    "argile",
    "argilla",
    "oneuku",
    "lama",
    NULL,
    NULL,
    "глина",
    "stena tvorená ílom",
    "argjil",
  },
  {
    "чакъл",
    "štěrk",
    "Wand aus Schutt",
    "χαλάσματα",
    "debris",
    NULL,
    NULL,
    "derrubios",
    "débris de roche",
    "detriti",
    "otaota",
    "escombros",
    NULL,
    NULL,
    "щебень",
    "stena tvorená suťou",
    "depozitime/mbetje gurresh",
  },
  {
    NULL,
    NULL,
    "Wand aus Sinter",
    NULL,
    "flowstone wall",
    NULL,
    NULL,
    NULL,
    NULL,
    "colata",
    "tāra a pari kōhatu",
    NULL,
    NULL,
    NULL,
    NULL,
    "stena tvorená sintrom",
    NULL,
  },
  {
    "лед/фирн",
    "led",
    "Wand aus Eis",
    "πάγος",
    "ice",
    NULL,
    NULL,
    "hielo",
    "glace",
    "ghiaccio",
    "kōpaka",
    "gelo",
    NULL,
    NULL,
    "лед, фирн",
    "stena tvorená ľadom",
    "akull",
  },
  {
    NULL,
    NULL,
    "Wand aus Bergmilch",
    NULL,
    "moonmilk wall",
    NULL,
    NULL,
    NULL,
    NULL,
    "moonmilk",
    "tāra a mirika marama",
    NULL,
    NULL,
    NULL,
    NULL,
    "stena tvorená mäkkým sintrom",
    NULL,
  },
  {
    NULL,
    NULL,
    "überlagerter Wandverlauf",
    NULL,
    "overlying wall",
    NULL,
    NULL,
    NULL,
    NULL,
    "parete:sovrastante",
    "tāra ki runga",
    NULL,
    NULL,
    NULL,
    NULL,
    "stena vyššej úrovne",
    NULL,
  },
  {
    "камъчета",
    "valouny",
    "Wand aus Kies",
    "χαλίκια",
    "pebbles",
    NULL,
    NULL,
    "cantos rodados",
    "cailloux",
    "ciotoli",
    "nga kōhatu iti",
    "seixos",
    NULL,
    NULL,
    "галька",
    "stena tvorená okruhliakmi",
    "gurralece",
  },
  {
    NULL,
    NULL,
    "Eingangsschacht",
    NULL,
    "entrance pit",
    NULL,
    NULL,
    NULL,
    NULL,
    "parete:pozzo",
    "rua",
    NULL,
    NULL,
    NULL,
    NULL,
    "vstupná priepasť",
    NULL,
  },
  {
    "предполагаема стена",
    "předpokládaná stěna",
    "Wand geschätzt",
    "τοίχος υποθετικός",
    "presumed wall",
    NULL,
    NULL,
    "pared supuesta",
    "mur supposé",
    "parete:presunta",
    "tāra whakaaro",
    "parede presumida",
    NULL,
    NULL,
    "предпологаемая стена",
    "predpokladaná stena",
    "muri I supozuar",
  },
  {
    "пясък",
    "písek",
    "Wand aus Sand",
    "άμμος",
    "sand",
    NULL,
    NULL,
    "arena",
    "sable",
    "sabbia",
    "onepū",
    "areia",
    NULL,
    NULL,
    "песок",
    "stena tvorená pieskom",
    "rane",
  },
  {
    "по-ниско разположена стена",
    "stěna nižší úrovně",
    "Wand unterlagernder Gang",
    "υποκείμενος τοίχος",
    "underlying wall",
    NULL,
    NULL,
    "pared subyacente",
    "mur sousjacent",
    "parete:sottostante",
    "tāra ki raro",
    "parede subjacente",
    NULL,
    NULL,
    "нижерасположенная стена",
    "stena nižšej úrovne",
    "muri I shtrire",
  },
  {
    "окомерна скица на стените",
    "nezaměřená stěna",
    "Wand unvermessen",
    "τοίχος (μη χαρτογραφημένος)",
    "unsurveyed wall",
    NULL,
    NULL,
    "pared no topografiada",
    "mur non topographié",
    "parete:stimata",
    "ka rūri tāra",
    "parede não-topografada",
    NULL,
    NULL,
    "глазомерная съемка стен",
    "nezameraná stena",
    "muri I pamatur",
  },
  {
    "водно течение",
    "vodní tok",
    "Gerinne",
    "υδρορροή",
    "water flow",
    NULL,
    NULL,
    "curso agua",
    "rivière",
    "corso d'acqua",
    "wairere",
    "fluxo de água",
    NULL,
    NULL,
    "водоток",
    "vodný tok",
    "rrjedhe uji",
  },
  {
    "предполагаемо водно течение",
    "předpokládaný vodní tok",
    "vermutetes Gerinne",
    "υποτιθέμενη υδρορροή",
    "conjectural water flow",
    NULL,
    NULL,
    "curso agua supuesto",
    "rivière, conjoncturelle",
    "corso d'acqua presunto",
    "wairere a pātai",
    "fluxo de água suposto",
    NULL,
    NULL,
    "предполагаемый водоток",
    "predpokladaný vodný tok",
    "rrjedhe uji e supozuar",
  },
  {
    "периодично водно течение",
    "občasný vodní tok",
    "zeitweises Gerinne",
    "διακοπτόμενη υδρορροή",
    "intermittent water flow",
    NULL,
    NULL,
    "curso agua intermitente",
    "rivière, intermittente",
    "corso d'acqua temporaneo",
    "wairere taumutumutu",
    "fluxo de água intermitente",
    NULL,
    NULL,
    "непостоянный водоток",
    "občasný vodný tok",
    "rrjedhe uji me force",
  },
  {
    "постоянно водно течение",
    "vodní tok",
    "ständiges Gerinne",
    "μόνιμη υδρορροή",
    "water flow",
    NULL,
    NULL,
    "curso agua",
    "rivière, permanente",
    "corso d'acqua permanente",
    "wairere",
    "fluxo de água permanente",
    NULL,
    NULL,
    "постоянный водоток",
    "vodný tok",
    "rrjedhe uji e perhershme",
  },
  {
    "въздушно течение",
    "průvan",
    "Luftzug",
    "ροή αέρα",
    "air draught",
    NULL,
    NULL,
    "corriente aire",
    "courant d’air",
    "corrente d'aria",
    "tawhiri",
    "presença de vento",
    NULL,
    NULL,
    "ток воздуха",
    "prievan",
    "rrymim i ajrit",
  },
  {
    "летен въздушно течение",
    "letní průvan",
    "Luftzug im Sommer",
    "θερινή ροή αέρα",
    "summer air draught",
    NULL,
    NULL,
    NULL,
    "courant d’air d’été",
    "circolazione estiva",
    "tawhiri a raumati",
    NULL,
    NULL,
    NULL,
    "ток воздуха летний",
    "letný prievan",
    "rrymim ajri-veror",
  },
  {
    "зимен въздушно течение",
    "zimní průvan",
    "Luftzug im Winter",
    "χειμερινή ροή αέρα",
    "winter air draught",
    NULL,
    NULL,
    NULL,
    "courant d’air d’hiver",
    "circolazione invernale",
    "tawhiri a takurua",
    NULL,
    NULL,
    NULL,
    "ток воздуха зимний",
    "zimný prievan",
    "rrymim ajri-dimeror",
  },
  {
    "н.м. височина",
    "nadmořská výška bodu v chodbě",
    "Höhe über Koordinatenursprung",
    "ύψος",
    "altitude",
    NULL,
    NULL,
    "altura",
    "altitude",
    "quota",
    "teitei, tiketike",
    "altura",
    NULL,
    NULL,
    "высотная отметка",
    "nadmorská výška bodu v chodbe",
    "lartesia mbidetare",
  },
  {
    "анастомоза",
    "anastomóza",
    "Anastomose",
    "αναστόμωση",
    "anastomosis",
    NULL,
    NULL,
    "anastomosis",
    "anastomose",
    "anastomosi",
    "peka hono",
    "anastomose",
    NULL,
    NULL,
    "анастомозис",
    "anastomóza",
    "anastomosa(kuartz)",
  },
  {
    "закрепване",
    "kotvení",
    "Seilbefestigung",
    "αγκύρωση",
    "anchor",
    NULL,
    NULL,
    "anclaje",
    "ancrage",
    "ancoraggio",
    "punga",
    "ancoragem",
    NULL,
    NULL,
    "ИТО",
    "kotvenie",
    "pike-sigurimi",
  },
  {
    "арагонит",
    "aragonit",
    "Aragonit",
    "αραγονίτης",
    "aragonite",
    NULL,
    NULL,
    "aragonito",
    "aragonite",
    "aragonite",
    "pākeho tuarua",
    "aragonita",
    "aragonita",
    "aragonite",
    "арагонит",
    "aragonit",
    "aragonite",
  },
  {
    "археологическа находка",
    "archeologické nálezy",
    "archäologischer Fund",
    "αρχαιολογικό εύρημα",
    "archaeological material",
    NULL,
    NULL,
    "yacimiento (arq)",
    "matériel archéo",
    "materiale archeologico",
    "taonga o nehe",
    "material arqueológico",
    NULL,
    NULL,
    "археологическая находка",
    "archeologické nálezy",
    "material arkeologjik",
  },
  {
    "основна скала",
    "pevná skála",
    "Deckgebirge",
    "πέτρωμα",
    "bedrock",
    NULL,
    NULL,
    "roca madre",
    "roche",
    "roccia",
    "koiwi a papa",
    "rocha encaixante",
    NULL,
    NULL,
    "коренная порода",
    "pevná skala",
    "shtrat shkembi",
  },
  {
    "камъни, блокаж",
    "kamenné bloky",
    "Blöcke",
    "ογκόλιθοι",
    "blocks, breakdown",
    NULL,
    NULL,
    "bloques",
    "blocs",
    "massi",
    "pakaru",
    "blocos, desmoronamento",
    NULL,
    NULL,
    "глыбы, завал",
    "kamenné bloky",
    "blloqe, shembje",
  },
  {
    "затворено от срутище",
    "zavalený konec",
    "Fortsetzung verstürzt",
    "κλείσιμο στοάς λόγο χαλάσματος",
    "breakdown choke",
    NULL,
    NULL,
    "colmatado por derrumbe",
    "trémie",
    "chiude su frana",
    "nati Pakaru",
    "obstrução por desmoronamento",
    NULL,
    NULL,
    "блокировано обвалом",
    "zavalený koniec",
    "gurre rrjedhes-fund",
  },
  {
    "мост",
    "most",
    "Brücke",
    "γέφυρα",
    "bridge",
    NULL,
    NULL,
    "puente roca",
    "pont",
    "ponte di roccia",
    "piriti",
    "ponte",
    NULL,
    NULL,
    "мост",
    "most",
    "ure",
  },
  {
    "лагер",
    "bivak",
    "Biwak",
    "κατασκήνωση",
    "camp",
    NULL,
    NULL,
    "campamento",
    "camp",
    "campo",
    "topuni",
    "acampamento",
    NULL,
    NULL,
    "ПБЛ",
    "bivak",
    "vend-pushim",
  },
  {
    "пещерен бисер",
    "jeskynní perly",
    "Höhlenperle",
    "μαργαριτάρι των σπηλαίων",
    "cave pearl",
    NULL,
    NULL,
    "perla de caverna",
    "perle des cavernes",
    "pisolite",
    "ana kahurangi",
    "pérolas",
    "pérolas",
    "pérolas de Gruta",
    "пещерный жемчуг",
    "jaskynné perly",
    "margaritar te shpelles",
  },
  {
    "глина",
    "bahno",
    "Lehm",
    "άργιλος",
    "clay",
    NULL,
    NULL,
    "arcilla",
    "argile",
    "argilla",
    "oneuku",
    "lama",
    NULL,
    NULL,
    "глина",
    "íl",
    "argjil",
  },
  {
    NULL,
    NULL,
    "Fortsetzung verlehmt",
    NULL,
    "clay choke",
    NULL,
    NULL,
    NULL,
    NULL,
    "chiude su riempimento",
    "uku pari",
    NULL,
    NULL,
    NULL,
    NULL,
    "koniec uzavretý ílom",
    NULL,
  },
  {
    NULL,
    NULL,
    "Lehmbäumchen",
    NULL,
    "clay tree",
    NULL,
    NULL,
    NULL,
    NULL,
    "pini d'argilla",
    "rakau oneuku",
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
  },
  {
    "възможно продължение",
    "možné pokračování",
    "Fortsetzung",
    "πιθανή συνέχεια",
    "possible continuation",
    NULL,
    NULL,
    "continuación",
    "suite possible",
    "possibile prosecuzione",
    "roanga taea",
    "possível continuação",
    NULL,
    NULL,
    "возможное продолжение",
    "možné pokračovanie",
    "vazhdim I mundshem",
  },
  {
    "кристал",
    "krystal",
    "Kristall",
    "κρύσταλλο",
    "crystal",
    NULL,
    NULL,
    "cristal",
    "cristaux",
    "cristallo",
    "kohatu piata",
    "cristal",
    NULL,
    NULL,
    "кристаллы",
    "kryštál",
    "kristale",
  },
  {
    "драперия",
    "sintrové záclony",
    "Sinterfahne",
    "κουρτίνα",
    "curtain",
    NULL,
    NULL,
    "cortina",
    "rideau",
    "cortina",
    "araia",
    "cortina",
    NULL,
    NULL,
    "натечный занавес",
    "sintrové záclony",
    "perde",
  },
  {
    "дата на наблюдението",
    "datum pozorování",
    "Datum",
    "ημερομηνία",
    "date of observation",
    NULL,
    NULL,
    "fecha",
    "date",
    "data d'osservazione",
    "rā o te titiro",
    "data de observação",
    NULL,
    NULL,
    "дата наблюдения",
    "dátum pozorovania",
    "data e vrojtimit",
  },
  {
    "чакъл",
    "štěrk",
    "Schutt",
    "χαλάσματα",
    "debris",
    NULL,
    NULL,
    "derrubios",
    "débris",
    "detriti",
    "otaota",
    "escombros",
    NULL,
    NULL,
    "щебень",
    "sutina",
    "mbetje-mbeturina",
  },
  {
    "изкоп",
    "sonda",
    "Grabung",
    "διάνοιξη",
    "dig",
    NULL,
    NULL,
    NULL,
    "désobstruction",
    "disostruzione",
    "kari",
    NULL,
    NULL,
    NULL,
    NULL,
    "sonda",
    "mihje",
  },
  {
    "размери на галерията",
    "rozměry",
    "Ausdehnung",
    "διαστάσεις",
    "dimensions",
    NULL,
    NULL,
    "dimensiones",
    "proportions",
    "dimensione",
    "rahinga, meiha",
    "dimensões",
    NULL,
    NULL,
    "размеры хода",
    "rozmery",
    "dimenzionet",
  },
  {
    "диск",
    "disk",
    "Diskus",
    "δίσκος",
    "disk",
    NULL,
    NULL,
    "disco",
    "disque",
    "disco",
    "kiwhi",
    "disco",
    NULL,
    NULL,
    "диск",
    "disk",
    "pllake",
  },
  {
    "вход",
    "vchod",
    "Eingang",
    "είσοδος",
    "entrance",
    NULL,
    NULL,
    "boca",
    "entrée",
    "ingresso",
    "ana ngutu",
    "entrada",
    NULL,
    NULL,
    "вход",
    "vchod",
    "hyrja",
  },
  {
    "стационарна стълба",
    "pevný žebřík",
    "feste Leiter",
    "μόνιμη σκάλα",
    "fixed ladder",
    NULL,
    NULL,
    "escala fija",
    "échelle fixe",
    "scala fissa",
    "arawhata",
    "escada fixa",
    NULL,
    NULL,
    "жесткая лестница",
    "fixný rebrík",
    "shkalle fikse",
  },
  {
    "натек",
    "sintr",
    "flächiger Sinter",
    "σταλαγμιτικό υλικό δαπέδου",
    "flowstone",
    NULL,
    NULL,
    "concreción",
    "concrétions",
    "concrezione",
    "pari kōhatu",
    "escorrimento",
    NULL,
    NULL,
    "натек",
    "sinter",
    "gurre-rrjedhes",
  },
  {
    "блокирано от натеци",
    "zasintrovaný konec",
    "Fortsetzung zugesintert",
    "κλείσιμο στοάς λόγο σταλαγμιτικού αποθέματος",
    "flowstone choke",
    NULL,
    NULL,
    "colmatado por concreción",
    "trémie calcifiée",
    "chiude su colata",
    "nati Pari kōhatu",
    "obstrução por escorrimento",
    NULL,
    NULL,
    "блокировано натеками",
    "zasintrený koniec",
    "mbyllje me gurre-rrjedhes",
  },
  {
    "карни жлебове",
    "píšťaly",
    "Kolk",
    "αυλάκι διάβρωσης",
    "flute",
    NULL,
    NULL,
    "canaleta",
    "marmites",
    "scanalatura",
    "koauau",
    "marcas de fluxo",
    NULL,
    NULL,
    "канавки",
    "píšťaly",
    "flauta",
  },
  {
    "наклон на галерията",
    "sklon chodby",
    "Gefälle",
    "κλίση στοάς",
    "passage gradient",
    NULL,
    NULL,
    "gradiente",
    "pente",
    "scivolo",
    "harapaki putanga",
    "declividade da galeria",
    NULL,
    NULL,
    "уклон хода",
    "sklon chodby",
    "pjertesia e kalimit",
  },
  {
    "гуано",
    "guano",
    "Guano",
    "γκουανό (περιττώματα νυχτερίδων)",
    "guano",
    NULL,
    NULL,
    "guano",
    "guano",
    "guano",
    "tutae",
    "guano",
    NULL,
    NULL,
    "гуано",
    "guáno",
    "jashteqitje e lakuriqeve-guano",
  },
  {
    "гипс",
    "sádrovec",
    "Gips",
    "γύψος",
    "gypsum",
    NULL,
    NULL,
    "yeso",
    "gypse",
    "gesso",
    "tote",
    "gipsita",
    NULL,
    NULL,
    "гипс",
    "sádrovec",
    "gjips",
  },
  {
    "гипсово цвете",
    "sádrovcový květ",
    "Gipsblume",
    "άνθος γύψου",
    "gypsum flower",
    NULL,
    NULL,
    "flor yeso",
    "fleur de gypse",
    "fiore di gesso",
    "putiputi tote",
    "flor de gipsita",
    NULL,
    NULL,
    "гипсовые цветы",
    "sádrovcový kvet",
    "lule gjipsi",
  },
  {
    "височина на праг/комин/кладенец",
    "výška stupně/komínu/hloubka propasti",
    "Höhe der Stufe oder des Schlotes oder Tiefe des Schachts",
    "ύψος σκαλοπατιού/καμινάδας ή βάθος πηγαδιού",
    "floor step/chimney/pit height/depth",
    NULL,
    NULL,
    "altura resalte/chimenea/profundidad pozo",
    "hauteur d’une marche/d’une cheminée/profondeur",
    "altezza",
    "papa tapuae/tumera/teitei rua/hōhonu",
    "altura do chão para degrau/chaminé/desnível",
    NULL,
    NULL,
    "высота уступа/трубы/колодца",
    "výška/hĺbka stupňa/komína",
    "lartesia e shkalles ne dysheme/oxhaku/thellesia e leshimit",
  },
  {
    "Дълбочина на кладенец",
    "hloubka propasti",
    "Tiefe des Schachts",
    "βάθος πηγαδιού",
    "pit depth",
    NULL,
    NULL,
    "profundidad pozo",
    "profondeur",
    "prodondità pozzo",
    "rua hōhonu",
    "profundidade do desnível",
    NULL,
    NULL,
    "высота колодца",
    "hĺbka priepasti",
    "thellesia e leshimit",
  },
  {
    "височина на комин",
    "výška komínu",
    "Höhe des Schlotes",
    "ύψος καμινάδας",
    "chimney height",
    NULL,
    NULL,
    "altura chimenea",
    "hauteur d’une cheminée",
    "altezza camino",
    "teitei tumera",
    "altura da chaminé",
    NULL,
    NULL,
    "высота трубы",
    "výška komína",
    "lartesia e oxhakut",
  },
  {
    "височина на ниша в тавана",
    "výška stupně",
    "Höhe der Bodenstufe",
    "ύψος σκαλοπατιού",
    "floor step height",
    NULL,
    NULL,
    "altura resalte",
    "hauteur d’une marche",
    "altezza camino",
    "teitei papa tapuae",
    "altura do degrau no chão",
    NULL,
    NULL,
    "высота уступа",
    "výška stupňa",
    "lartesia e shkalles se dyshemes",
  },
  {
    "хеликтити",
    "heliktit",
    "Excentrique",
    "ελικτίτης",
    "helictite",
    NULL,
    NULL,
    "excéntrica",
    "excentrique/hélictite",
    "eccentrica",
    "pākeho torotoro",
    "helictite",
    "helictite",
    "excêntrica",
    "геликтиты",
    "heliktit",
    "heliktite",
  },
  {
    "лед",
    "led",
    "Eis",
    "πάγος",
    "ice",
    NULL,
    NULL,
    "hielo",
    "glace",
    "ghiaccio",
    "kōpaka",
    "gelo",
    NULL,
    NULL,
    "лёд",
    "ľad",
    "akull",
  },
  {
    NULL,
    NULL,
    "Eissäule",
    NULL,
    "ice pillar",
    NULL,
    NULL,
    NULL,
    NULL,
    "colonna di ghiaccio",
    "pou Kōpaka",
    NULL,
    NULL,
    NULL,
    NULL,
    "ľadový stalagnát",
    NULL,
  },
  {
    NULL,
    NULL,
    "Eisstalaktit",
    NULL,
    "ice stalactite",
    NULL,
    NULL,
    NULL,
    NULL,
    "stalattite di ghiaccio",
    "kōpaka ki te haere ki runga",
    NULL,
    NULL,
    NULL,
    NULL,
    "ľadový stalaktit",
    NULL,
  },
  {
    NULL,
    NULL,
    "Eisstalagmit",
    NULL,
    "ice stalagmite",
    NULL,
    NULL,
    NULL,
    NULL,
    "stalagmite di ghiaccio",
    "kōpaka ki te haere ki raro",
    NULL,
    NULL,
    NULL,
    NULL,
    "ľadový stalagmit",
    NULL,
  },
  {
    "кари",
    "škrapy",
    "Karren",
    "κάρρεν - γυμνός καρστικοποιημένος βράχος",
    "karren",
    NULL,
    NULL,
    "lapiaz",
    "lapiez",
    "karren",
    "awaawa",
    "lapiás",
    NULL,
    NULL,
    "карры",
    "škrapy",
    "karreni",
  },
  {
    "етикет",
    "pojmenování",
    "Beschriftung",
    "περιγραφή",
    "label",
    NULL,
    NULL,
    "etiqueta",
    "libellé",
    "etichetta",
    "ingoa",
    "indicação",
    NULL,
    NULL,
    "текстовая метка",
    "pomenovanie",
    "mbishkrim-etiket",
  },
  {
    "хоризонтално стеснение",
    "neprůlezné snížení",
    "Engstelle, zu flach",
    "κλείσιμο στοάς λόγω χαμηλής οροφής",
    "passage end, low",
    NULL,
    NULL,
    "final bajo",
    "passage bas",
    "chiude su laminatoio",
    "putanga pāpaku mutunga",
    "passagem com final baixo",
    NULL,
    NULL,
    "горизонтальная узость",
    "neprielezné zníženie",
    "kalim I poshtem-fund",
  },
  {
    "пещерно мляко",
    "nickamínek",
    "Bergmilch",
    "γάλα σπηλαίου",
    "moonmilk",
    NULL,
    NULL,
    "mondmilch",
    "mondmilch",
    "moonmilk",
    "mirika marama",
    "leite-de-lua",
    NULL,
    NULL,
    "лунное молоко",
    "mäkký sinter",
    "qumesht-hena",
  },
  {
    "непроходимо снижаване",
    "neprůlezné zúžení",
    "Engstelle, zu schmal",
    "κλείσιμο στοάς λόγω στενώματος",
    "passage end, narrow",
    NULL,
    NULL,
    "final estrecho",
    "passage impénétrable",
    "chiude su strettoia",
    "putanga kuiti mutunga",
    "passagem com final estreito",
    NULL,
    NULL,
    "вертикальная узость",
    "neprielezné zúženie",
    "kalim I ngushte-fund",
  },
  {
    "липсва екипировка!",
    "nevystrojené místo",
    "keine Ausrüstung",
    "χωρίς υλικά",
    "no equipment!",
    NULL,
    NULL,
    "sin equipar",
    "pas d’équipement",
    "senza armo",
    "wahi a taonga mahi kore",
    "local sem equipamento",
    NULL,
    NULL,
    "снаряжение отутствует!",
    "nevystrojené miesto",
    "vend pa pajisje",
  },
  {
    "палеонтологична находка",
    "paleontologické nálezy",
    "paläontologischer Fund",
    "παλαιοντολογικό εύρημα",
    "paleo material",
    NULL,
    NULL,
    "yacimiento (pal)",
    "matériel paléo",
    "materiale paleologico",
    "taiao taonga o nehe",
    "material paleontológico",
    NULL,
    NULL,
    "палео-находка",
    "paleontologické nálezy",
    "paleo-material",
  },
  {
    "височина на галерията",
    "výška chodby",
    "Raumhöhe",
    "ύψος στοάς",
    "passage height",
    NULL,
    NULL,
    "altura galería",
    "hauteur du passage",
    "altezza galleria",
    "ara teitei",
    "altura da galeria",
    NULL,
    NULL,
    "высота хода",
    "výška chodby",
    "lartesia e kalimit",
  },
  {
    "височина над и дълбочина под водата",
    "výška nad i pod hladinou",
    "Raumhöhe gesamt",
    "ύψος και βάθος στοάς πάνω και κάτω από νερό",
    "height above, depth below water",
    NULL,
    NULL,
    "altura y profundidad respecto nivel del mar",
    "hauteur au dessous et au dessus de l’eau",
    "altezza sopra e sotto il livello dell'acqua",
    "karewa ki runga ki raro",
    "altura acima e profundidade abaixo do nível da água",
    NULL,
    NULL,
    "высота над и глубина ниже уровня воды",
    "výška nad a hĺbka pod hladinou",
    "lartesia mbi dhe nen nivelin e ujit",
  },
  {
    "дълбочина на галерията под водата",
    "výška chodby pod hladinou",
    "Raumhöhe nach unten",
    "βάθος στοάς κάτω από νερό",
    "depth below water level",
    NULL,
    NULL,
    "profundidad bajo nivel del mar",
    "hauteur en dessous de l’eau",
    "profondità sotto il livello dell'acqua",
    "te hōhunu a karewa ki raro",
    "profundidade abaixo do nível da água",
    NULL,
    NULL,
    "глубина ниже уровня воды",
    "hĺbka pod hladinou",
    "thellesia nen nivelin e ujit",
  },
  {
    "височина на галерията над водата",
    "výška chodby nad hladinou",
    "Raumhöhe nach oben",
    "ύψος στοάς πάνω από νερό",
    "height above water level",
    NULL,
    NULL,
    "altura sobre nivel del mar",
    "hauteur au-dessus de l’eau",
    "altezza sopra il livello dell'acqua",
    "te teitei a karewa ki runga",
    "altura acima do nível da água",
    NULL,
    NULL,
    "высота над уровнем воды",
    "výška nad hladinou",
    "lartesia mbi nivelin e ujit",
  },
  {
    "височина на галерията",
    "výška chodby",
    "Raumhöhe",
    "ύψος στοάς",
    "passage height",
    NULL,
    NULL,
    "altura galería",
    "hauteur du passage",
    "altezza galleria",
    "ara teitei",
    "altura da galeria",
    NULL,
    NULL,
    "высота хода",
    "výška chodby",
    "lartesia e kalimit-e pashenuar",
  },
  {
    "камъчета",
    "valouny",
    "Kies",
    "χαλίκια",
    "pebbles",
    NULL,
    NULL,
    "cantos rodados",
    "galets",
    "ciotoli",
    "nga kōhatu iti",
    "seixos",
    NULL,
    NULL,
    "галька",
    "okruhliaky",
    "gurralece",
  },
  {
    "сталактон",
    "stalagnát",
    "Säule",
    "κολόνα",
    "pillar",
    NULL,
    NULL,
    "pilar",
    "pillier",
    "colonna",
    "pou",
    "coluna",
    NULL,
    NULL,
    "колонна",
    "stalagnát",
    "shtylle",
  },
  {
    "коралити",
    "pizolity",
    "Blumenkohlsinter",
    "μανιτάρια από σταλαγμιτικό υλικό",
    "popcorn",
    NULL,
    NULL,
    "coliflor",
    "choux-fleur",
    "cavolfiore",
    "kanga pāhuuhuu",
    "couve-flor",
    NULL,
    NULL,
    "коралиты",
    "pizolity",
    "palagaqa-kokorroshka",
  },
  {
    "насип",
    "náplav",
    "schwimmendes Kalkhäutchen",
    "σταλαγμιτικό υλικό που επιπλέει",
    "calcite raft",
    NULL,
    NULL,
    "calcita flotante",
    "calcite flottante",
    "calcite flottante",
    "mōkihi o kōhatu hōhonu",
    "jangada",
    NULL,
    NULL,
    "высыпка",
    "náplav",
    "trap-skele",
  },
  {
    "насипен конус",
    "náplavový kužel",
    "schwimmendes Kalkhäutchen",
    "σταλαγμιτικός κώνος που επιπλέει",
    "raft cone",
    NULL,
    NULL,
    "conos",
    "cone",
    "calcite flottante",
    "korere a mōkihi kōhatu hōhonu",
    "cone de jangada",
    NULL,
    NULL,
    "высыпной конус",
    "náplavový kužeľ",
    "rrjedhe uji konike",
  },
  {
    "забележка",
    "poznámka",
    "Bemerkung",
    "σχόλιο",
    "remark",
    NULL,
    NULL,
    "nota",
    "remarque",
    "nota",
    "korero",
    "anotação",
    NULL,
    NULL,
    "заметка",
    "poznámka",
    "shenim",
  },
  {
    "сухо синтрово езеро",
    "sintrová hrázka",
    "Sinterbarriere",
    "γκουρ (λιθωματικό φράγμα)",
    "rimstone dam",
    NULL,
    NULL,
    "gour-presa",
    "gours",
    "gour",
    "kōhatu matatara",
    "travertino",
    NULL,
    NULL,
    "гуры без воды",
    "sintrová hrádza",
    "penda guri",
  },
  {
    "синтрово езеро",
    "sintrové jezírko",
    "Sinterbecken",
    "γκουρ (λιθωματική λεκάνη)",
    "rimstone pool",
    NULL,
    NULL,
    "gour-poza",
    "gour",
    "vasca",
    "kōhatu kopua wai",
    "lago travertino",
    NULL,
    NULL,
    "гуры с водой",
    "sintrové jazierko",
    "vaska uji",
  },
  {
    "корени",
    "kořeny",
    "Holzreste",
    "ρίζες",
    "root",
    NULL,
    NULL,
    "raíz",
    "racine",
    "radice",
    "pakiaka",
    "raiz",
    NULL,
    NULL,
    "корни растений",
    "korene",
    "rrenje",
  },
  {
    "въже",
    "lano",
    "Seil",
    "σχοινί",
    "rope",
    NULL,
    NULL,
    "cuerda",
    "corde",
    "corda",
    "taura",
    "corda",
    NULL,
    NULL,
    "линейная опора",
    "lano",
    "litar",
  },
  {
    "пещерна стълба",
    "lanový žebřík",
    "Drahtseilleiter",
    "ανεμόσκαλα",
    "rope ladder",
    NULL,
    NULL,
    "escala",
    "échelle de corde",
    "scala di corda",
    "arawhata taura",
    "escada de corda",
    NULL,
    NULL,
    "гибкая лестница",
    "lanový rebrík",
    "shkalle litari",
  },
  {
    "пясък",
    "písek",
    "Sand",
    "άμμος",
    "sand",
    NULL,
    NULL,
    "arena",
    "sable",
    "sabbia",
    "onepū",
    "areia",
    NULL,
    NULL,
    "песок",
    "piesok",
    "rane",
  },
  {
    "фасетки",
    "erozní útvary",
    "Fließfacette",
    "σκάλοπ (κενά διάβρωσης)",
    "scallop",
    NULL,
    NULL,
    "cavitaciones",
    "vagues d’érosion (coups de gouge)",
    "scallop",
    "anatipa",
    "marcas de fluxo",
    NULL,
    NULL,
    "фасетки",
    "lastúrovité jamky",
    "guacat",
  },
  {
    "място на сечение",
    "příčný řez",
    "Schnitt",
    "τομή",
    "section",
    NULL,
    NULL,
    "sección",
    "section",
    "sezione",
    "roherohenga",
    "seção",
    "seção",
    "secção",
    "сечение",
    "priečny rez",
    "pike-ndarje",
  },
  {
    "понор",
    "ponor",
    "Schluckloch",
    "καταβόθρα",
    "sink",
    NULL,
    NULL,
    "sumidero",
    "perte",
    "perdita",
    "tapoko",
    "sumidouro",
    NULL,
    NULL,
    "сток",
    "ponor",
    "pus",
  },
  {
    "сняг",
    "sníh",
    "Schnee",
    "χιώνι",
    "snow",
    NULL,
    NULL,
    "nieve",
    "neige",
    "neve",
    "huka",
    "neve",
    NULL,
    NULL,
    "снег",
    "sneh",
    "bore",
  },
  {
    "цевичен сталактит",
    "brčka",
    "Makkaroni",
    "μακαρόνια",
    "soda straw",
    NULL,
    NULL,
    "fistulosa",
    "fistuleuse",
    "tubolare",
    "pū ngote",
    "canudos",
    NULL,
    "tubulares",
    "сталактиты-соломины",
    "brčká",
    "shkopinje sode",
  },
  {
    "извор",
    "vývěr",
    "Quelle",
    "πηγή",
    "spring",
    NULL,
    NULL,
    "surgencia",
    "source",
    "sorgente",
    "waipuna",
    "nascente",
    NULL,
    NULL,
    "исток",
    "výver",
    "burim",
  },
  {
    "сталактит",
    "stalaktit",
    "Stalaktit",
    "σταλακτίτης",
    "stalactite",
    NULL,
    NULL,
    "estalactita",
    "stalactite",
    "stalattite",
    "kōhatu ki te haere ki runga",
    "estalactite",
    NULL,
    NULL,
    "сталактит",
    "stalaktit",
    "stalaktit",
  },
  {
    "сталагмит",
    "stalagmit",
    "Stalagmit",
    "σταλαγμίτης",
    "stalagmite",
    NULL,
    NULL,
    "estalagmita",
    "stalagmite",
    "stalagmite",
    "kōhatu ki te haere ki raro",
    "estalagmite",
    NULL,
    NULL,
    "сталагмит",
    "stalagmit",
    "stalagmit",
  },
  {
    "реперна точка",
    "měřičský bod",
    "Messpunkt",
    "σημείο χαρτογράφησης",
    "survey station",
    NULL,
    NULL,
    "estación",
    "station topo",
    "caposaldo",
    "kaimataara",
    "base",
    NULL,
    NULL,
    "пикет",
    "meračský bod",
    "stacioni I matjes",
  },
  {
    "име на реперна точка",
    "číslo měřičského bodu",
    "Messpunktname",
    "όνομα σημείου χαρτογράφησης",
    "survey station name",
    NULL,
    NULL,
    "nombre estacion",
    "station topo, nom",
    "node del caposaldo",
    "kaimatara ingoa",
    "nome de base",
    NULL,
    NULL,
    "номер пикета",
    "číslo meračského bodu",
    "emri I stacionit-mates",
  },
  {
    "реперна точка (стабилизирана)",
    "měřičský bod (stabilizovaný)",
    "dauerhafter Messpunkt",
    "μόνιμο σημείο χαρτογράφησης",
    "fixed survey station",
    NULL,
    NULL,
    "estación (fija)",
    "station topo, fixe",
    "caposaldo fisso",
    "kaimataara whakakōhatu",
    "base fixa",
    NULL,
    NULL,
    "репер",
    "meračský bod (stabilizovaný)",
    "stacion mates I palevizshem",
  },
  {
    "реперна точка (естествена)",
    "měřičský bod (přírodní)",
    "natürlicher Messpunkt",
    "σημείο χαρτογράφησης (φυσικό)",
    "natural survey station",
    NULL,
    NULL,
    "estación (natural)",
    "station topo, naturelle",
    "caposaldo naturale",
    "kaimataara a papa",
    "base natural",
    NULL,
    NULL,
    "естественная точка привязки",
    "meračský bod (prírodný)",
    "stacion mates natyral",
  },
  {
    "реперна точка (боядисана)",
    "měřičský bod (zabarvený)",
    "farbig markierter Messpunkt",
    "σημείο χαρτογράφησης (βαμμένο)",
    "painted survey station",
    NULL,
    NULL,
    "estación (pintada)",
    "station topo, peinte",
    "caposaldo verniciato",
    "kaimataara tohi",
    "base pintada",
    NULL,
    NULL,
    "нарисованный пикет",
    "meračský bod (zafarbený)",
    "stacion mates I ngjyrosur",
  },
  {
    "временна реперна точка",
    "měřičský bod (nestabilizovaný)",
    "unmarkierter Messpunkt",
    "προσωρινό σημείο χαρτογράφησης",
    "temporary survey station",
    NULL,
    NULL,
    "estación topográfica",
    "station topo temporaire",
    "caposaldo termporaneo",
    "kaimataara mo te wā",
    "base temporária",
    NULL,
    NULL,
    "временный пикет",
    "meračský bod (nestabilizovaný)",
    "stacion mates I perkohshem",
  },
  {
    "стъпала",
    "schody",
    "Stufen",
    "σκαλοπάτια",
    "steps",
    NULL,
    NULL,
    "escalones",
    "marches",
    "scalini",
    "nga tapuae",
    "degraus",
    NULL,
    NULL,
    "ступени",
    "schody",
    "shkalle",
  },
  {
    "траверс",
    "traverz",
    "Querung",
    "τραβέρσα",
    "traverse",
    NULL,
    NULL,
    "pasamanos",
    "traversée",
    "traverso",
    "hikoi a tupari",
    "travessia",
    NULL,
    NULL,
    "троллей",
    "traverz",
    "kalim anesore",
  },
  {
    "останки от растителност",
    "zbytky rostlin",
    "Pflanzenreste",
    "φυτικά κατάλοιπα",
    "vegetable debris",
    NULL,
    NULL,
    "detritus vegetales",
    "débris végétaux",
    "detriti vegetali",
    "otaota a hua whenua",
    "restos vegetais",
    NULL,
    NULL,
    "останки растительности",
    "zvyšky rastlín",
    "mbetje perimesh",
  },
  {
    "височинна отметка на стената",
    "nadmořská výška bodu na stěně",
    "Höhe über Koordinatenursprung",
    "ύψος τοίχου",
    "altitude",
    NULL,
    NULL,
    "altura pared",
    "altitude",
    "altezza",
    "teitei, tiketike",
    "altura",
    NULL,
    NULL,
    "высотная отметка стены",
    "nadmorská výška bodu na stene",
    "lartesia mbidetare e murit",
  },
  {
    "повлек",
    "vápencový povlak",
    "Wandsinter",
    "ασβεστίτης τοιχώματος",
    "wall calcite",
    NULL,
    NULL,
    "calcita",
    "mur, calcite",
    "calcite",
    "tāra a nga roimata a pakeho",
    "parede de calcita",
    "parede de calcita",
    "parede de calcite",
    "настенный кальцит",
    "vápencový povlak",
    "kalcit-muri",
  },
  {
    "вода",
    "voda",
    "Wasser",
    "νερό",
    "water",
    NULL,
    NULL,
    "agua",
    "eau",
    "acqua",
    "wai",
    "água",
    NULL,
    NULL,
    "вода",
    "voda",
    "uje",
  },
  {
    "водно течение",
    "vodní tok",
    "Gerinne",
    "υδρορροή",
    "water flow",
    NULL,
    NULL,
    "curso agua",
    "rivière",
    "corso d'acqua",
    "wairere",
    "fluxo de água",
    NULL,
    NULL,
    "водоток",
    "vodný tok",
    "rrjedhe uji",
  },
  {
    "непостоянно водно течение",
    "občasný vodní tok",
    "zeitweises Gerinne",
    "διακοπτόμενη υδρορροή",
    "intermittent water flow",
    NULL,
    NULL,
    "curso agua intermitente",
    "rivière, intermittente",
    "corso d'acqua temporaneo",
    "wairere taumutumutu",
    "fluxo de água intermitente",
    NULL,
    NULL,
    "непостоянный водоток",
    "občasný vodný tok",
    "rrjedhe uji me force",
  },
  {
    "палео речно легло",
    "paleořečiště",
    "ehemaliges Gerinne",
    "παλαιουδρορροή",
    "paleo water flow (scallops)",
    NULL,
    NULL,
    "paleocurso agua",
    "rivière fossile",
    "paleocorso d'acqua",
    "wairere nehera",
    "paleo-fluxo de água",
    NULL,
    NULL,
    "палео-поток",
    "paleoriečisko",
    "rrjedhe uji e vjeter",
  },
  {
    "постоянно водно течение",
    "vodní tok",
    "ständiges Gerinne",
    "μόνιμη υδρορροή",
    "water flow",
    NULL,
    NULL,
    "curso agua",
    "rivière, permanente",
    "corso d'acqua permanente",
    "wairere",
    "fluxo de água permanente",
    NULL,
    NULL,
    "постоянный водоток",
    "vodný tok",
    "rrjedhe uji e perhershme",
  },
  {
    "Гл. картировач",
    "Kreslil",
    "Zeichnung",
    "Σκαρίφημα",
    "Drawn by",
    NULL,
    NULL,
    "Cartografía",
    "Dessinateur",
    "Cartografia",
    "Kaituhi",
    "Desenhada por",
    NULL,
    NULL,
    "Камеральная обработка",
    "Kreslil",
    "vizatuar nga",
  },
  {
    "Гл. картировачи",
    "Kreslili",
    "Zeichnung",
    "Σκαρίφημα",
    "Drawn by",
    NULL,
    NULL,
    "Cartografía",
    "Dessinateurs",
    "Cartografia",
    "Kaituhi",
    "Desenhadas por",
    NULL,
    NULL,
    "Камеральная обработка",
    "Kreslili",
    "vizatuar nga",
  },
  {
    "Денивелация",
    "Převýšení",
    "Niveaudifferenz",
    "Βάθος",
    "Depth",
    NULL,
    NULL,
    "Desnivel",
    "Profondeur",
    "Profondità",
    "Hōhonu a ana, Rētōtanga",
    "Desnível",
    NULL,
    NULL,
    "Глубина",
    "Prevýšenie",
    "thellesia",
  },
  {
    "Дължина",
    "Délka",
    "Gesamtlänge",
    "Μήκος",
    "Length",
    NULL,
    NULL,
    "Desarrollo",
    "Longueur",
    "Sviluppo",
    "Roa a ana",
    "Extensão",
    NULL,
    NULL,
    "Длина",
    "Dĺžka",
    "gjatesia",
  },
  {
    "Височинна скала",
    "Nadmořské výšky",
    "Höhe des Titelfeldes",
    "Υψομετρικά",
    "Altitudes",
    NULL,
    NULL,
    "color (altitud)",
    "Altitudes",
    "Profondità",
    "Teitei, Tiketike",
    "Altitudes",
    NULL,
    NULL,
    "Высотная шкала",
    "Nadmorské výšky",
    "titulli ngjyra-permbajtja-lartesia mbidetare",
  },
  {
    "Карти",
    "Mapy",
    "Karten",
    "Χάρτες",
    "Maps",
    NULL,
    NULL,
    "color (mapa)",
    "Cartes",
    "Mappa",
    "Mahere whenua",
    "Mapas",
    NULL,
    NULL,
    "Карты",
    "Mapy",
    "hartat",
  },
  {
    "Изследване",
    "Objevil",
    "Entdeckung",
    "Εξερευνητής",
    "Explored by",
    NULL,
    NULL,
    "Exploración",
    "Explorateur",
    "Esplorazione",
    "Kaipokai whenua",
    "Explorada por",
    NULL,
    NULL,
    "Исследование",
    "Objavil",
    "hulumtuar nga",
  },
  {
    "Изследване",
    "Objevili",
    "Entdeckung",
    "Εξερευνητές",
    "Explored by",
    NULL,
    NULL,
    "Exploración",
    "Explorateurs",
    "Esplorazione",
    "Kaipokai whenua",
    "Exploradas por",
    NULL,
    NULL,
    "Исследование",
    "Objavili",
    "hulumtuar nga",
  },
  {
    "Легенда",
    "Legenda",
    "Legende",
    "Τίτλος",
    "Legend",
    NULL,
    NULL,
    "Leyenda",
    "Légende",
    "Legenda",
    "Kaiwhakaatu",
    "Legenda",
    NULL,
    NULL,
    "Условные обозначения",
    "Legenda",
    "permbajtja",
  },
  {
    "Изглед от горе",
    "[Náhled horních vrstev]",
    "Vorschau oben",
    "[προεπισκόπηση πάνω]",
    "[Preview above]",
    NULL,
    NULL,
    "Vista previa superior",
    "[Prévisualisation au-dessus]",
    "Anteprima sopra",
    "Tuhi a ana ki runga",
    "[Visualização acima]",
    NULL,
    NULL,
    "[Вид выше]",
    "[Náhľad horných vrstiev]",
    "parashiqimi lart",
  },
  {
    "Изглед от долу",
    "[Náhled dolních vrstev]",
    "Vorschau unten",
    "[προεπισκόπηση κάτω]",
    "[Preview below]",
    NULL,
    NULL,
    "Vista previa inferior",
    "[Prévisualisation au-dessous]",
    "Anteprima sotto",
    "Tuhi a ana ki raro",
    "[Visualização abaixo]",
    NULL,
    NULL,
    "[Вид ниже]",
    "[Náhľad spodných vrstiev]",
    "parashiqimi perfundi",
  },
  {
    "Карта на повърхността",
    "[Povrchová mapa]",
    "Erdoberfläche",
    "[χάρτης επιφάνειας]",
    "[Surface Image]",
    NULL,
    NULL,
    "Mapa superficie",
    "[Carte extérieure]",
    "Mappa superficie",
    "Konohi o te whenua",
    "[Mapa de superfície]",
    NULL,
    NULL,
    "[Карта поверхности]",
    "[Povrchová mapa]",
    "harta e siperfaqes",
  },
  {
    "Картирал",
    "Měřil",
    "Vermessung",
    "Χαρτογραφήθηκε από τον",
    "Surveyed by",
    NULL,
    NULL,
    "Topografía",
    "Topographe",
    "Topografia",
    "Kairūri",
    "Topografada por",
    NULL,
    NULL,
    "Съемка",
    "Zameral",
    "matur nga",
  },
  {
    "Картирали",
    "Měřili",
    "Vermessung",
    "Χαρτογραφήθηκε από τους",
    "Surveyed by",
    NULL,
    NULL,
    "Espeleometría",
    "Topographes",
    "Topografia",
    "Kairūri",
    "Topografadas por",
    NULL,
    NULL,
    "Съемка",
    "Zamerali",
    "matur nga",
  },
  {
    "футове",
    "ft",
    "ft",
    "πόδια",
    "ft",
    NULL,
    NULL,
    "ft",
    "ft",
    "ft",
    "whīti",
    "pés",
    NULL,
    NULL,
    "футов",
    "ft",
    "njesia matese-kembe",
  },
  {
    "м",
    "m",
    "m",
    "μ",
    "m",
    NULL,
    NULL,
    "m",
    "m",
    "m",
    "mehua",
    "m",
    NULL,
    NULL,
    "м",
    "m",
    "njesia matese-metri",
  },
};

 
 
