/**
 * @file thlangdata.cxx
 * Therion language translations module.
 *
 * THIS FILE IS GENERATED AUTOMATICALLY, DO NOT MODIFY IT !!!
 */

 
typedef const char * thlang_pchar;


static const thstok thtt_lang [] = {
  {"cz", THLANG_CZ},
  {"de", THLANG_DE},
  {"el", THLANG_EL},
  {"en", THLANG_EN},
  {"en_UK", THLANG_EN_UK},
  {"en_US", THLANG_EN_US},
  {"es", THLANG_ES},
  {"fr", THLANG_FR},
  {"it", THLANG_IT},
  {"pt", THLANG_PT},
  {"pt_BR", THLANG_PT_BR},
  {"pt_PT", THLANG_PT_PT},
  {"ru", THLANG_RU},
  {"sk", THLANG_SK},
  {"sq", THLANG_SQ},
  {NULL, THLANG_UNKNOWN},
};



static const thlang_pchar thlang__cxxids []  = {
  "THLANG_CZ",
  "THLANG_DE",
  "THLANG_EL",
  "THLANG_EN",
  "THLANG_EN_UK",
  "THLANG_EN_US",
  "THLANG_ES",
  "THLANG_FR",
  "THLANG_IT",
  "THLANG_PT",
  "THLANG_PT_BR",
  "THLANG_PT_PT",
  "THLANG_RU",
  "THLANG_SK",
  "THLANG_SQ",
};



static const int thlang__alternatives [] = {
  THLANG_UNKNOWN,
  THLANG_UNKNOWN,
  THLANG_UNKNOWN,
  THLANG_UNKNOWN,
  THLANG_EN,
  THLANG_EN,
  THLANG_UNKNOWN,
  THLANG_UNKNOWN,
  THLANG_UNKNOWN,
  THLANG_UNKNOWN,
  THLANG_PT,
  THLANG_PT,
  THLANG_UNKNOWN,
  THLANG_UNKNOWN,
  THLANG_UNKNOWN,
};



static const thstok thtt__texts [150] = {
  {"area blocks",0},
  {"area clay",1},
  {"area debris",2},
  {"area ice",3},
  {"area pebbles",4},
  {"area sand",5},
  {"area snow",6},
  {"area sump",7},
  {"area water",8},
  {"line arrow",9},
  {"line border",10},
  {"line border:presumed",11},
  {"line border:temporary",12},
  {"line border:visible",13},
  {"line ceiling-meander",14},
  {"line ceiling-step",15},
  {"line chimney",16},
  {"line contour",17},
  {"line floor-meander",18},
  {"line floor-step",19},
  {"line flowstone",20},
  {"line gradient",21},
  {"line label",22},
  {"line map-connection",23},
  {"line moonmilk",24},
  {"line overhang",25},
  {"line pit",26},
  {"line rock-border",27},
  {"line rock-edge",28},
  {"line section",29},
  {"line slope",30},
  {"line survey",31},
  {"line wall",32},
  {"line wall:bedrock",33},
  {"line wall:blocks",34},
  {"line wall:clay",35},
  {"line wall:debris",36},
  {"line wall:ice",37},
  {"line wall:pebbles",38},
  {"line wall:presumed",39},
  {"line wall:sand",40},
  {"line wall:underlying",41},
  {"line wall:unsurveyed",42},
  {"line water-flow",43},
  {"line water-flow:conjectural",44},
  {"line water-flow:intermittent",45},
  {"line water-flow:permanent",46},
  {"point air-draught",47},
  {"point air-draught:summer",48},
  {"point air-draught:winter",49},
  {"point altitude",50},
  {"point anastomosis",51},
  {"point anchor",52},
  {"point aragonite",53},
  {"point archeo-material",54},
  {"point bedrock",55},
  {"point blocks",56},
  {"point breakdown-choke",57},
  {"point bridge",58},
  {"point camp",59},
  {"point cave-pearl",60},
  {"point clay",61},
  {"point continuation",62},
  {"point crystal",63},
  {"point curtain",64},
  {"point date",65},
  {"point debris",66},
  {"point dig",67},
  {"point dimensions",68},
  {"point disk",69},
  {"point entrance",70},
  {"point fixed-ladder",71},
  {"point flowstone",72},
  {"point flowstone-choke",73},
  {"point flute",74},
  {"point gradient",75},
  {"point guano",76},
  {"point gypsum",77},
  {"point gypsum-flower",78},
  {"point height",79},
  {"point height:negative",80},
  {"point height:positive",81},
  {"point height:unsigned",82},
  {"point helictite",83},
  {"point ice",84},
  {"point karren",85},
  {"point label",86},
  {"point low-end",87},
  {"point moonmilk",88},
  {"point narrow-end",89},
  {"point no-equipment",90},
  {"point paleo-material",91},
  {"point passage-height",92},
  {"point passage-height:both",93},
  {"point passage-height:negative",94},
  {"point passage-height:positive",95},
  {"point passage-height:unsigned",96},
  {"point pebbles",97},
  {"point pillar",98},
  {"point popcorn",99},
  {"point raft",100},
  {"point raft-cone",101},
  {"point remark",102},
  {"point rimstone-dam",103},
  {"point rimstone-pool",104},
  {"point root",105},
  {"point rope",106},
  {"point rope-ladder",107},
  {"point sand",108},
  {"point scallop",109},
  {"point section",110},
  {"point sink",111},
  {"point snow",112},
  {"point soda-straw",113},
  {"point spring",114},
  {"point stalactite",115},
  {"point stalagmite",116},
  {"point station",117},
  {"point station-name",118},
  {"point station:fixed",119},
  {"point station:natural",120},
  {"point station:painted",121},
  {"point station:temporary",122},
  {"point steps",123},
  {"point traverse",124},
  {"point vegetable-debris",125},
  {"point wall-altitude",126},
  {"point wall-calcite",127},
  {"point water",128},
  {"point water-flow",129},
  {"point water-flow:intermittent",130},
  {"point water-flow:paleo",131},
  {"point water-flow:permanent",132},
  {"title carto",133},
  {"title carto (plural)",134},
  {"title cave depth",135},
  {"title cave length",136},
  {"title color-legend-altitude",137},
  {"title color-legend-map",138},
  {"title explo",139},
  {"title explo (plural)",140},
  {"title legend",141},
  {"title preview above",142},
  {"title preview below",143},
  {"title surface bitmap",144},
  {"title topo",145},
  {"title topo (plural)",146},
  {"units ft",147},
  {"units m",148},
  {NULL, -1},
};



static thlang_pchar thlang__translations [149][15] = {
  {
    "skalní bloky",
    "Fläche mit Blöcken",
    "ογκόλιθοι",
    "blocks",
    NULL,
    NULL,
    "bloques",
    "blocs",
    "massi",
    "blocos",
    NULL,
    NULL,
    "навал глыб",
    "skalné bloky",
    "blloqe",
  },
  {
    "bahno",
    "Lehmfläche",
    "άργιλος",
    "clay",
    NULL,
    NULL,
    "arcilla",
    "argile",
    "argilla",
    "lama",
    NULL,
    NULL,
    "глина",
    "íl",
    "argjil",
  },
  {
    "štěrk",
    "Schuttfläche",
    "χαλάσματα",
    "debris",
    NULL,
    NULL,
    "derrubios",
    "débris",
    "detriti",
    "escombros",
    NULL,
    NULL,
    "щебень",
    "štrk",
    "mbetje-gurresh",
  },
  {
    "led",
    "Eisfläche",
    "πάγος",
    "ice",
    NULL,
    NULL,
    "hielo",
    "glace",
    "ghiaccio",
    "gelo",
    NULL,
    NULL,
    "лёд",
    "ľad",
    "akull",
  },
  {
    "valouny",
    "Kiesfläche",
    "χαλίκια",
    "pebbles",
    NULL,
    NULL,
    "cantos rodados",
    "galets/pierres",
    "ciotoli",
    "seixos",
    NULL,
    NULL,
    "галька",
    "okrúhliaky",
    "gurralece",
  },
  {
    "písek",
    "Sandfläche",
    "άμμος",
    "sand",
    NULL,
    NULL,
    "arena",
    "sable",
    "sabbia",
    "areia",
    NULL,
    NULL,
    "песок",
    "piesok",
    "rane",
  },
  {
    "sníh",
    "Schneefläche",
    "χιόνι",
    "snow",
    NULL,
    NULL,
    "nieve",
    "neige",
    "neve",
    "neve",
    NULL,
    NULL,
    "снег",
    "sneh",
    "bore",
  },
  {
    "sifon",
    "Siphonfläche",
    "σιφόνι",
    "sump",
    NULL,
    NULL,
    "sifón",
    "siphon",
    "sifone",
    "sifão",
    NULL,
    NULL,
    "сифон",
    "zatopená plocha (sifón)",
    "sifoni",
  },
  {
    "vodní plocha",
    "Wasserfläche",
    "νερό",
    "water",
    NULL,
    NULL,
    "agua",
    "eau",
    "acqua",
    "água",
    NULL,
    NULL,
    "вода",
    "vodná plocha",
    "uje",
  },
  {
    "pomocná šipka",
    "Pfeil",
    "βέλος",
    "arrow",
    NULL,
    NULL,
    "flecha",
    "flèche",
    "freccia",
    "seta",
    NULL,
    NULL,
    "стрелка",
    "pomocná šípka",
    "shigjeta",
  },
  {
    "ohraničení",
    "Begrenzung",
    "άκρη",
    "border",
    NULL,
    NULL,
    "límite",
    "bord",
    "bordo",
    "borda",
    NULL,
    NULL,
    "граница",
    "ohraničenie",
    "kufiri",
  },
  {
    "předpokládané ohraničení",
    "geschätzte Begrenzung",
    "υποθετική άκρη",
    "presumed border",
    NULL,
    NULL,
    "límite supuesto",
    "bord, supposé",
    "bordo presunto",
    "borda presumida",
    NULL,
    NULL,
    "предполагаемая граница",
    "predpokladané ohraničenie",
    "kufij I supozuar",
  },
  {
    "nestálé ohraničení",
    "vorübergehende Begrenzung",
    "προσωρινή άκρη",
    "temporary border",
    NULL,
    NULL,
    "límite temporal",
    "bord, temporaire",
    "bordo temporaneo",
    "borda temporária",
    NULL,
    NULL,
    "временная граница",
    "nestále ohraničenie",
    "kufij i perkohshem",
  },
  {
    "ohraničení",
    "sichtbare Begrenzung",
    "άκρη",
    "border",
    NULL,
    NULL,
    "límite",
    "bord",
    "bordo",
    "borda",
    NULL,
    NULL,
    "видимая граница",
    "ohraničenie",
    "vije kufiri-e dukshme",
  },
  {
    "stropní meandr",
    "Deckenmäander",
    "μαίανδρος οροφής",
    "ceiling meander",
    NULL,
    NULL,
    "meandro inverso",
    "méandre de plafond",
    "canale di volta",
    "meandro no teto",
    "meandro no teto",
    "meandro no tecto",
    "меандр, канал в потолке",
    "stropný meander",
    "rrjedhe uji gjarperore ne tavan",
  },
  {
    "změna výšky stropu",
    "Deckenstufe",
    "σκαλοπάτι οροφής",
    "step on the ceiling",
    NULL,
    NULL,
    "resalte inverso",
    "marche de plafond",
    "camino",
    "degrau no teto",
    "degrau no teto",
    "degrau no tecto",
    "уступ потолка",
    "zmena výšky stropu",
    "shkalle ne tavan",
  },
  {
    "komín",
    "Kamin",
    "καμινάδα",
    "chimney",
    NULL,
    NULL,
    "chimenea",
    "cheminée",
    "camino",
    "chaminé",
    NULL,
    NULL,
    "труба",
    "komín",
    "oxhak",
  },
  {
    "vrstevnice",
    "Höhenlinie",
    "ισοϋψής",
    "contour",
    NULL,
    NULL,
    "contorno",
    "contour",
    "contorno",
    "contorno",
    NULL,
    NULL,
    "контур",
    "vrstevnica",
    "kontura",
  },
  {
    "meandr ve dně",
    "Bodenmäander",
    "μαίανδρος δαπέδου",
    "floor meander",
    NULL,
    NULL,
    "meandro",
    "méandre au sol",
    "meandro",
    "meandro no piso",
    NULL,
    NULL,
    "меандр, канал в полу",
    "meander v dne",
    "rrjedhe uji gjarperore",
  },
  {
    "stupeň",
    "Bodenstufe",
    "σκαλοπάτι",
    "floor step",
    NULL,
    NULL,
    "resalte",
    "marche",
    "gradino",
    "degrau",
    NULL,
    NULL,
    "уступ пола",
    "stupeň",
    "shkalle ne dysheme",
  },
  {
    "sintrové náteky",
    "flächiger Sinter",
    "σταλαγμιτικό υλικό δαπέδου",
    "flowstone",
    NULL,
    NULL,
    "concreción",
    "concrétion",
    "concrezione",
    "escorrimento",
    NULL,
    NULL,
    "натечный каскад",
    "sintrové náteky",
    "gurre-rrjedhes",
  },
  {
    "sklon chodby",
    "Gefälle",
    "κλίση στοάς",
    "passage gradient",
    NULL,
    NULL,
    "gradiente",
    "pente",
    "scivolo",
    "declividade da galeria",
    NULL,
    NULL,
    "уклон хода",
    "sklon chodby",
    "pjertesia e kalimit",
  },
  {
    "pojmenování",
    "Beschriftung",
    "περιγραφή",
    NULL,
    NULL,
    NULL,
    "etiqueta",
    "libellé",
    "etichetta",
    "indicação",
    NULL,
    NULL,
    "текстовая метка",
    "pomenovanie",
    "mbishkrim",
  },
  {
    "spojení map",
    "Verbindung zwischen Karten",
    "ένωση χαρτών",
    "map connection",
    NULL,
    NULL,
    NULL,
    "jonction de carte",
    "riporto di mappa",
    NULL,
    NULL,
    NULL,
    "линия выноса",
    "prepojenie máp",
    "lidhjet ne harta",
  },
  {
    "nickamínek",
    "Mondmilch",
    "γάλα σπηλαίου",
    NULL,
    NULL,
    NULL,
    NULL,
    "mondmilch",
    "moonmilk",
    NULL,
    NULL,
    NULL,
    "лунное молоко",
    "náteky mäkkého sintra",
    "qumesht-hena",
  },
  {
    "převis",
    "Überhang",
    "προέκταση οροφής",
    "overhang",
    NULL,
    NULL,
    "extraplomo",
    "surplomb",
    "sporgenza",
    "projeção",
    "projeção",
    "projecção",
    "нависание потолка",
    "previs",
    "varese",
  },
  {
    "propast",
    "Schacht",
    "πηγάδι",
    "pitch",
    "pitch",
    "pit",
    "pozo",
    "puits",
    "pozzo",
    "desnível",
    NULL,
    NULL,
    "колодец",
    "priepasť",
    "ngjitje",
  },
  {
    "kameny",
    "Umriss eines Felsens",
    "περίγραμμα βράχου",
    "rock border",
    NULL,
    NULL,
    "contorno bloque",
    "bord d’un rocher",
    "bordo masso",
    "lateral da rocha",
    NULL,
    NULL,
    "внешний кромка глыбы",
    "obrys kameňa",
    "kufij shkembinjsh",
  },
  {
    "hrany kamenů",
    "Struktur eines Felsens",
    "άκρη βράχου",
    "rock edges",
    NULL,
    NULL,
    "arista bloque",
    "arête d’un rocher",
    "spigolo masso",
    "bordas da rocha",
    NULL,
    NULL,
    "внутренняя кромка глыбы",
    "hrany kameňa",
    "skaji I shkembit",
  },
  {
    "příčný řez",
    "Schnittlinie",
    "τομή",
    "cross-section",
    NULL,
    NULL,
    "sección",
    "section",
    "sezione trasversale",
    "corte",
    NULL,
    NULL,
    "выносная линия сечения",
    "priečny rez",
    "kryq-ndarje",
  },
  {
    "svah",
    "Hangform",
    "κλίση",
    "slope",
    NULL,
    NULL,
    "pendiente",
    "pente",
    "scivolo",
    "declive",
    NULL,
    NULL,
    "склон",
    "šikmá plocha",
    "breg",
  },
  {
    "polygonový tah",
    "Messzug",
    "γραμμή χαρτογράφησης",
    "survey lines",
    NULL,
    NULL,
    "poligonal",
    "visée topo",
    "poligonale",
    "linha de topografia",
    NULL,
    NULL,
    "нитка хода",
    "polygónový ťah",
    "vijat matese-vrojtuese",
  },
  {
    "stěna",
    "Wand",
    "τοίχος",
    "wall",
    NULL,
    NULL,
    "pared",
    "mur",
    "parete",
    "parede",
    NULL,
    NULL,
    "стена",
    "stena",
    "muri",
  },
  {
    "stěna",
    "Wand zum Deckgebirge",
    "τοίχος",
    "wall",
    NULL,
    NULL,
    "pared",
    "mur",
    "roccia",
    "parede",
    NULL,
    NULL,
    "стена",
    "stena",
    "shkembi-muri",
  },
  {
    "zával",
    "Wand aus Versturz",
    "ογκόλιθοι",
    "breakdown",
    NULL,
    NULL,
    "bloques",
    "effrondrement",
    "massi",
    "desmoronamento",
    NULL,
    NULL,
    "глыбы",
    "stena tvorená závalom",
    "blloqe",
  },
  {
    "bahno",
    "Wand aus Lehm",
    "άργιλος",
    "clay",
    NULL,
    NULL,
    "arcilla",
    "argile",
    "argilla",
    "lama",
    NULL,
    NULL,
    "глина",
    "stena tvorená ílom",
    "argjil",
  },
  {
    "štěrk",
    "Wand aus Schutt",
    "χαλάσματα",
    "debris",
    NULL,
    NULL,
    "derrubios",
    "débris de roche",
    "detriti",
    "escombros",
    NULL,
    NULL,
    "щебень",
    "stena tvorená suťou",
    "depozitime/mbetje gurresh",
  },
  {
    "led",
    "Wand aus Eis",
    "πάγος",
    "ice",
    NULL,
    NULL,
    "hielo",
    "glace",
    "ghiaccio",
    "gelo",
    NULL,
    NULL,
    "лед, фирн",
    "stena tvorená ľadom",
    "akull",
  },
  {
    "valouny",
    "Wand aus Kies",
    "χαλίκια",
    "pebbles",
    NULL,
    NULL,
    "cantos rodados",
    "cailloux",
    "ciotoli",
    "seixos",
    NULL,
    NULL,
    "галька",
    "stena tvorená okruhliakmi",
    "gurralece",
  },
  {
    "předpokládaná stěna",
    "Wand geschätzt",
    "τοίχος υποθετικός",
    "presumed wall",
    NULL,
    NULL,
    "pared supuesta",
    "mur supposé",
    "parete presunta",
    "parede presumida",
    NULL,
    NULL,
    "предпологаемая стена",
    "predpokladaná stena",
    "muri I supozuar",
  },
  {
    "písek",
    "Wand aus Sand",
    "άμμος",
    "sand",
    NULL,
    NULL,
    "arena",
    "sable",
    "sabbia",
    "areia",
    NULL,
    NULL,
    "песок",
    "stena tvorená pieskom",
    "rane",
  },
  {
    "stěna nižší úrovně",
    "Wand unterlagernder Gang",
    "υποκείμενος τοίχος",
    "underlying wall",
    NULL,
    NULL,
    "pared subyacente",
    "mur sousjacent",
    "parete soggiacente",
    "parede subjacente",
    NULL,
    NULL,
    "нижерасположенная стена",
    "stena nižšej úrovne",
    "muri I shtrire",
  },
  {
    "nezaměřená stěna",
    "Wand unvermessen",
    "τοίχος (μη χαρτογραφημένος)",
    "unsurveyed wall",
    NULL,
    NULL,
    "pared no topografiada",
    "mur non topographié",
    "parete stimata",
    "parede não-topografada",
    NULL,
    NULL,
    "глазомерная съемка стен",
    "nezameraná stena",
    "muri I pamatur",
  },
  {
    "vodní tok",
    "Gerinne",
    "υδρορροή",
    "water flow",
    NULL,
    NULL,
    "curso agua",
    "rivière",
    "corso d'acqua",
    "fluxo de água",
    NULL,
    NULL,
    "водоток",
    "vodný tok",
    "rrjedhe uji",
  },
  {
    "předpokládaný vodní tok",
    "vermutetes Gerinne",
    "υποτιθέμενη υδρορροή",
    "conjectural water flow",
    NULL,
    NULL,
    "curso agua supuesto",
    "rivière, conjoncturelle",
    "corso d'acqua presunto",
    "fluxo de água suposto",
    NULL,
    NULL,
    "предполагаемый водоток",
    "predpokladaný vodný tok",
    "rrjedhe uji e supozuar",
  },
  {
    "občasný vodní tok",
    "zeitweises Gerinne",
    "διακοπτόμενη υδρορροή",
    "intermittent water flow",
    NULL,
    NULL,
    "curso agua intermitente",
    "rivière, intermittente",
    "corso d'acqua temporaneo",
    "fluxo de água intermitente",
    NULL,
    NULL,
    "непостоянный водоток",
    "občasný vodný tok",
    "rrjedhe uji me force",
  },
  {
    "vodní tok",
    "ständiges Gerinne",
    "μόνιμη υδρορροή",
    "water flow",
    NULL,
    NULL,
    "curso agua",
    "rivière, permanente",
    "corso d'acqua permanente",
    "fluxo de água permanente",
    NULL,
    NULL,
    "постоянный водоток",
    "vodný tok",
    "rrjedhe uji e perhershme",
  },
  {
    "průvan",
    "Luftzug",
    "ροή αέρα",
    "air draught",
    NULL,
    NULL,
    "corriente aire",
    "courant d’air",
    "corrente d'aria",
    "presença de vento",
    NULL,
    NULL,
    "ток воздуха",
    "prievan",
    "rrymim i ajrit",
  },
  {
    "letní průvan",
    "Luftzug Sommer",
    "θερινή ροή αέρα",
    "summer air draught",
    NULL,
    NULL,
    NULL,
    "courant d’air d’été",
    "circolazione estiva",
    NULL,
    NULL,
    NULL,
    "ток воздуха летний",
    "letný prievan",
    "rrymim ajri-veror",
  },
  {
    "zimní průvan",
    "Luftzug Winter",
    "χειμερινή ροή αέρα",
    "winter air draught",
    NULL,
    NULL,
    NULL,
    "courant d’air d’hiver",
    "circolazione invernale",
    NULL,
    NULL,
    NULL,
    "ток воздуха зимний",
    "zimný prievan",
    "rrymim ajri-dimeror",
  },
  {
    "nadmořská výška bodu v chodbě",
    "Höhe über Koordinatenursprung",
    "ύψος",
    "altitude",
    NULL,
    NULL,
    "altura",
    "altitude",
    "quota",
    "altura",
    NULL,
    NULL,
    "высотная отметка",
    "nadmorská výška bodu v chodbe",
    "lartesia mbidetare",
  },
  {
    "anastomóza",
    "Anastomose",
    "αναστόμωση",
    "anastomosis",
    NULL,
    NULL,
    "anastomosis",
    "anastomose",
    "anastomosi",
    "anastomose",
    NULL,
    NULL,
    "анастомозис",
    "anastomóza",
    "anastomosa(kuartz)",
  },
  {
    "kotvení",
    "Seilbefestigung",
    "αγκύρωση",
    "anchor",
    NULL,
    NULL,
    "anclaje",
    "ancrage",
    "ancoraggio",
    "ancoragem",
    NULL,
    NULL,
    "ИТО",
    "kotvenie",
    "pike-sigurimi",
  },
  {
    "aragonit",
    "Aragonit",
    "αραγονίτης",
    "aragonite",
    NULL,
    NULL,
    "aragonito",
    "aragonite",
    "aragonite",
    "aragonita",
    "aragonita",
    "aragonite",
    "арагонит",
    "aragonit",
    "aragonite",
  },
  {
    "archeologické nálezy",
    "archäologischer Fund",
    "αρχαιολογικό εύρημα",
    "archeo material",
    NULL,
    NULL,
    "yacimiento (arq)",
    "matériel archéo",
    "materiale archeologico",
    "material arqueológico",
    NULL,
    NULL,
    "археологическая находка",
    "archeologické nálezy",
    "material arkeologjik",
  },
  {
    "pevná skála",
    "Deckgebirge",
    "πέτρωμα",
    "bedrock",
    NULL,
    NULL,
    "roca madre",
    "roche",
    "roccia",
    "rocha encaixante",
    NULL,
    NULL,
    "коренная порода",
    "pevná skala",
    "shtrat shkembi",
  },
  {
    "kamenné bloky",
    "Blöcke",
    "ογκόλιθοι",
    "blocks, breakdown",
    NULL,
    NULL,
    "bloques",
    "blocs",
    "massi",
    "blocos, desmoronamento",
    NULL,
    NULL,
    "глыбы, завал",
    "kamenné bloky",
    "blloqe, shembje",
  },
  {
    "zavalený konec",
    "Fortsetzung verstürzt",
    "κλείσιμο στοάς λόγο χαλάσματος",
    "breakdown choke",
    NULL,
    NULL,
    "colmatado por derrumbe",
    "trémie",
    "chiude su frana",
    "obstrução por desmoronamento",
    NULL,
    NULL,
    "блокировано обвалом",
    "zavalený koniec",
    "gurre rrjedhes-fund",
  },
  {
    "most",
    "Brücke",
    "γέφυρα",
    "bridge",
    NULL,
    NULL,
    "puente roca",
    "pont",
    "ponte di roccia",
    "ponte",
    NULL,
    NULL,
    "мост",
    "most",
    "ure",
  },
  {
    "bivak",
    "Biwak",
    "κατασκήνωση",
    "camp",
    NULL,
    NULL,
    "campamento",
    "camp",
    "campo",
    "acampamento",
    NULL,
    NULL,
    "ПБЛ",
    "bivak",
    "vend-pushim",
  },
  {
    "jeskynní perly",
    "Höhlenperle",
    "μαργαριτάρι των σπηλαίων",
    "cave pearl",
    NULL,
    NULL,
    "perla de caverna",
    "perle des cavernes",
    "pisolite",
    "pérolas",
    "pérolas",
    "pérolas de Gruta",
    "пещерный жемчуг",
    "jaskynné perly",
    "margaritar te shpelles",
  },
  {
    "bahno",
    "Lehm",
    "άργιλος",
    "clay",
    NULL,
    NULL,
    "arcilla",
    "argile",
    "argilla",
    "lama",
    NULL,
    NULL,
    "глина",
    "íl",
    "argjil",
  },
  {
    "možné pokračování",
    "Fortsetzung",
    "πιθανή συνέχεια",
    "possible continuation",
    NULL,
    NULL,
    "continuación",
    "suite possible",
    "possibile prosecuzione",
    "possível continuação",
    NULL,
    NULL,
    "возможное продолжение",
    "možné pokračovanie",
    "vazhdim I mundshem",
  },
  {
    "krystal",
    "Kristall",
    "κρύσταλλο",
    "crystal",
    NULL,
    NULL,
    "cristal",
    "cristaux",
    "cristallo",
    "cristal",
    NULL,
    NULL,
    "кристаллы",
    "kryštál",
    "kristale",
  },
  {
    "sintrové záclony",
    "Sinterfahne",
    "κουρτίνα",
    "curtain",
    NULL,
    NULL,
    "cortina",
    "rideau",
    "cortina",
    "cortina",
    NULL,
    NULL,
    "натечный занавес",
    "sintrové záclony",
    "perde",
  },
  {
    "datum pozorování",
    "Datum",
    "ημερομηνία",
    "date of observation",
    NULL,
    NULL,
    "fecha",
    "date",
    "data d'osservazione",
    "data de observação",
    NULL,
    NULL,
    "дата наблюдения",
    "dátum pozorovania",
    "data e vrojtimit",
  },
  {
    "štěrk",
    "Schutt",
    "χαλάσματα",
    "debris",
    NULL,
    NULL,
    "derrubios",
    "débris",
    "detriti",
    "escombros",
    NULL,
    NULL,
    "щебень",
    "sutina",
    "mbetje-mbeturina",
  },
  {
    "sonda",
    "Grabungsstelle",
    "διάνοιξη",
    "dig",
    NULL,
    NULL,
    NULL,
    "désobstruction",
    "disostruzione",
    NULL,
    NULL,
    NULL,
    NULL,
    "sonda",
    "mihje",
  },
  {
    "rozměry",
    "Ausdehnung",
    "διαστάσεις",
    NULL,
    NULL,
    NULL,
    "dimensiones",
    "proportions",
    "dimensione",
    "dimensões",
    NULL,
    NULL,
    "размеры хода",
    "rozmery",
    "dimenzionet",
  },
  {
    "disk",
    "Diskus",
    "δίσκος",
    "disk",
    NULL,
    NULL,
    "disco",
    "disque",
    "disco",
    "disco",
    NULL,
    NULL,
    "диск",
    "disk",
    "pllake",
  },
  {
    "vchod",
    "Eingang",
    "είσοδος",
    "entrance",
    NULL,
    NULL,
    "boca",
    "entrée",
    "ingresso",
    "entrada",
    NULL,
    NULL,
    "вход",
    "vchod",
    "hyrja",
  },
  {
    "pevný žebřík",
    "feste Leiter",
    "μόνιμη σκάλα",
    "fixed ladder",
    NULL,
    NULL,
    "escala fija",
    "échelle fixe",
    "scala fissa",
    "escada fixa",
    NULL,
    NULL,
    "жесткая лестница",
    "fixný rebrík",
    "shkalle fikse",
  },
  {
    "sintr",
    "flächiger Sinter",
    "σταλαγμιτικό υλικό δαπέδου",
    "flowstone",
    NULL,
    NULL,
    "concreción",
    "concrétions",
    "concrezione",
    "escorrimento",
    NULL,
    NULL,
    "натек",
    "sinter",
    "gurre-rrjedhes",
  },
  {
    "zasintrovaný konec",
    "Fortsetzung zugesintert",
    "κλείσιμο στοάς λόγο σταλαγμιτικού αποθέματος",
    "flowstone choke",
    NULL,
    NULL,
    "colmatado por concreción",
    "trémie calcifiée",
    "chiude su colata",
    "obstrução por escorrimento",
    NULL,
    NULL,
    "блокировано натеками",
    "zasintrený koniec",
    "mbyllje me gurre-rrjedhes",
  },
  {
    "píšťaly",
    "Kolk",
    "αυλάκι διάβρωσης",
    "flute",
    NULL,
    NULL,
    "canaleta",
    "marmites",
    "scanalatura",
    "marcas de fluxo",
    NULL,
    NULL,
    "канавки",
    "píšťaly",
    "flauta",
  },
  {
    "sklon chodby",
    "Gefälle",
    "κλίση στοάς",
    "passage gradient",
    NULL,
    NULL,
    "gradiente",
    "pente",
    "scivolo",
    "declividade da galeria",
    NULL,
    NULL,
    "уклон хода",
    "sklon chodby",
    "pjertesia e kalimit",
  },
  {
    "guano",
    "Guano",
    "γκουανό (περιττώματα νυχτερίδων)",
    "guano",
    NULL,
    NULL,
    "guano",
    "guano",
    "guano",
    "guano",
    NULL,
    NULL,
    "гуано",
    "guáno",
    "jashteqitje e lakuriqeve-guano",
  },
  {
    "sádrovec",
    "Gips",
    "γύψος",
    "gypsum",
    NULL,
    NULL,
    "yeso",
    "gypse",
    "gesso",
    "gipsita",
    NULL,
    NULL,
    "гипс",
    "sádrovec",
    "gjips",
  },
  {
    "sádrovcový květ",
    "Gipsblume",
    "άνθος γύψου",
    "gypsum flower",
    NULL,
    NULL,
    "flor yeso",
    "fleur de gypse",
    "fiore di gesso",
    "flor de gipsita",
    NULL,
    NULL,
    "гипсовые цветы",
    "sádrovcový kvet",
    "lule gjipsi",
  },
  {
    "výška stupně/komínu/hloubka propasti",
    "Höhe der Stufe oder des Kamins oder Tiefe des Schachts",
    "ύψος σκαλοπατιού/καμινάδας ή βάθος πηγαδιού",
    "the height of floor step/chimney/pit depth",
    NULL,
    NULL,
    "altura resalte/chimenea/profundidad pozo",
    "hauteur d’une marche/d’une cheminée/profondeur",
    "altezza",
    "altura do chão para degrau/chaminé/desnível",
    NULL,
    NULL,
    "высота уступа/трубы/колодца",
    "výška/hĺbka stupňa/komína",
    "lartesia e shkalles ne dysheme/oxhaku/thellesia e leshimit",
  },
  {
    "hloubka propasti",
    "Tiefe des Schachts",
    "βάθος πηγαδιού",
    "pit depth",
    NULL,
    NULL,
    "profundidad pozo",
    "profondeur",
    "prodondità pozzo",
    "profundidade do desnível",
    NULL,
    NULL,
    "высота колодца",
    "hĺbka priepasti",
    "thellesia e leshimit",
  },
  {
    "výška komínu",
    "Höhe des Kamins",
    "ύψος καμινάδας",
    "chimney height",
    NULL,
    NULL,
    "altura chimenea",
    "hauteur d’une cheminée",
    "altezza camino",
    "altura da chaminé",
    NULL,
    NULL,
    "высота трубы",
    "výška komína",
    "lartesia e oxhakut",
  },
  {
    "výška stupně",
    "Höhe der Bodenstufe",
    "ύψος σκαλοπατιού",
    "the height of floor step",
    NULL,
    NULL,
    "altura resalte",
    "hauteur d’une marche",
    "altezza camino",
    "altura do degrau no chão",
    NULL,
    NULL,
    "высота уступа",
    "výška stupňa",
    "lartesia e shkalles se dyshemes",
  },
  {
    "heliktit",
    "Excentrique",
    "ελικτίτης",
    "helictite",
    NULL,
    NULL,
    "excéntrica",
    "excentrique/hélictite",
    "eccentrica",
    "helictite",
    "helictite",
    "excêntrica",
    "геликтиты",
    "heliktit",
    "heliktite",
  },
  {
    "led",
    "Eis",
    "πάγος",
    "ice",
    NULL,
    NULL,
    "hielo",
    "glace",
    "ghiaccio",
    "gelo",
    NULL,
    NULL,
    "лёд",
    "ľad",
    "akull",
  },
  {
    "škrapy",
    "Karren",
    "κάρρεν - γυμνός καρστικοποιημένος βράχος",
    "karren",
    NULL,
    NULL,
    "lapiaz",
    "lapiez",
    "karren",
    "lapiás",
    NULL,
    NULL,
    "карры",
    "škrapy",
    "karreni",
  },
  {
    "pojmenování",
    "Beschriftung",
    "περιγραφή",
    NULL,
    NULL,
    NULL,
    "etiqueta",
    "libellé",
    "etichetta",
    "indicação",
    NULL,
    NULL,
    "текстовая метка",
    "pomenovanie",
    "mbishkrim-etiket",
  },
  {
    "neprůlezné snížení",
    "Engstelle, zu flach",
    "κλείσιμο στοάς λόγω χαμηλής οροφής",
    "passage low end",
    NULL,
    NULL,
    "final bajo",
    "passage bas",
    "chiude su laminatoio",
    "passagem com final baixo",
    NULL,
    NULL,
    "горизонтальная узость",
    "neprielezné zníženie",
    "kalim I poshtem-fund",
  },
  {
    "nickamínek",
    "Mondmilch",
    "γάλα σπηλαίου",
    "moonmilk",
    NULL,
    NULL,
    "mondmilch",
    "mondmilch",
    "moonmilk",
    "leite-de-lua",
    NULL,
    NULL,
    "лунное молоко",
    "mäkký sinter",
    "qumesht-hena",
  },
  {
    "neprůlezné zúžení",
    "Engstelle, zu schmal",
    "κλείσιμο στοάς λόγω στενώματος",
    "passage narrow end",
    NULL,
    NULL,
    "final estrecho",
    "passage impénétrable",
    "chiude su strettoia",
    "passagem com final estreito",
    NULL,
    NULL,
    "вертикальная узость",
    "neprielezné zúženie",
    "kalim I ngushte-fund",
  },
  {
    "nevystrojené místo",
    "keine Ausrüstung",
    "χωρίς υλικά",
    "place without equipement",
    NULL,
    NULL,
    "sin equipar",
    "pas d’équipement",
    "senza armo",
    "local sem equipamento",
    NULL,
    NULL,
    "снаряжение отутствует!",
    "nevystrojené miesto",
    "vend pa pajisje",
  },
  {
    "paleontologické nálezy",
    "paläontologischer Fund",
    "παλαιοντολογικό εύρημα",
    "paleo material",
    NULL,
    NULL,
    "yacimiento (pal)",
    "matériel paléo",
    "materiale paleologico",
    "material paleontológico",
    NULL,
    NULL,
    "палео-находка",
    "paleontologické nálezy",
    "paleo-material",
  },
  {
    "výška chodby",
    "Raumhöhe",
    "ύψος στοάς",
    "passage height",
    NULL,
    NULL,
    "altura galería",
    "hauteur du passage",
    "altezza galleria",
    "altura da galeria",
    NULL,
    NULL,
    "высота хода",
    "výška chodby",
    "lartesia e kalimit",
  },
  {
    "výška nad i pod hladinou",
    "Raumhöhe gesamt",
    "ύψος και βάθος στοάς πάνω και κάτω από νερό",
    "height above and depth below water level",
    NULL,
    NULL,
    "altura y profundidad respecto nivel del mar",
    "hauteur au dessous et au dessus de l’eau",
    "altezza sopra e sotto il livello dell'acqua",
    "altura acima e profundidade abaixo do nível da água",
    NULL,
    NULL,
    "высота над и глубина ниже уровня воды",
    "výška nad a hĺbka pod hladinou",
    "lartesia mbi dhe nen nivelin e ujit",
  },
  {
    "výška chodby pod hladinou",
    "Raumhöhe nach unten",
    "βάθος στοάς κάτω από νερό",
    "depth below water level",
    NULL,
    NULL,
    "profundidad bajo nivel del mar",
    "hauteur en dessous de l’eau",
    "profondità sotto il livello dell'acqua",
    "profundidade abaixo do nível da água",
    NULL,
    NULL,
    "глубина ниже уровня воды",
    "hĺbka pod hladinou",
    "thellesia nen nivelin e ujit",
  },
  {
    "výška chodby nad hladinou",
    "Raumhöhe nach oben",
    "ύψος στοάς πάνω από νερό",
    "height above water level",
    NULL,
    NULL,
    "altura sobre nivel del mar",
    "hauteur au-dessus de l’eau",
    "altezza sopra il livello dell'acqua",
    "altura acima do nível da água",
    NULL,
    NULL,
    "высота над уровнем воды",
    "výška nad hladinou",
    "lartesia mbi nivelin e ujit",
  },
  {
    "výška chodby",
    "Raumhöhe",
    "ύψος στοάς",
    "passage height",
    NULL,
    NULL,
    "altura galería",
    "hauteur du passage",
    "altezza galleria",
    "altura da galeria",
    NULL,
    NULL,
    "высота хода",
    "výška chodby",
    "lartesia e kalimit-e pashenuar",
  },
  {
    "valouny",
    "Kies",
    "χαλίκια",
    "pebbles",
    NULL,
    NULL,
    "cantos rodados",
    "galets",
    "ciotoli",
    "seixos",
    NULL,
    NULL,
    "галька",
    "okruhliaky",
    "gurralece",
  },
  {
    "stalagnát",
    "Säule",
    "κολόνα",
    "pillar",
    NULL,
    NULL,
    "pilar",
    "pillier",
    "colonna",
    "coluna",
    NULL,
    NULL,
    "колонна",
    "stalagnát",
    "shtylle",
  },
  {
    "pizolity",
    "Blumenkohlsinter",
    "μανιτάρια από σταλαγμιτικό υλικό",
    "popcorn",
    NULL,
    NULL,
    "coliflor",
    "choux-fleur",
    "cavolfiore",
    "couve-flor",
    NULL,
    NULL,
    "коралиты",
    "pizolity",
    "palagaqa-kokorroshka",
  },
  {
    "náplav",
    "schwimmendes Kalkhäutchen",
    "σταλαγμιτικό υλικό που επιπλέει",
    "raft",
    NULL,
    NULL,
    "calcita flotante",
    "calcite flottante",
    "calcite flottante",
    "jangada",
    NULL,
    NULL,
    "высыпка",
    "náplav",
    "trap-skele",
  },
  {
    "náplavový kužel",
    "schwimmendes Kalkhäutchen",
    "σταλαγμιτικός κώνος που επιπλέει",
    "raft cone",
    NULL,
    NULL,
    "conos",
    "cone",
    "calcite flottante",
    "cone de jangada",
    NULL,
    NULL,
    "высыпной конус",
    "náplavový kužeľ",
    "rrjedhe uji konike",
  },
  {
    "poznámka",
    "Bemerkung",
    "σχόλιο",
    NULL,
    NULL,
    NULL,
    "nota",
    "remarque",
    "nota",
    "anotação",
    NULL,
    NULL,
    "заметка",
    "poznámka",
    "shenim",
  },
  {
    "sintrová hrázka",
    "Sinterbarriere",
    "γκουρ (λιθωματικό φράγμα)",
    "rimstone dam",
    NULL,
    NULL,
    "gour-presa",
    "gours",
    "gour",
    "travertino",
    NULL,
    NULL,
    "гуры без воды",
    "sintrová hrádza",
    "penda guri",
  },
  {
    "sintrové jezírko",
    "Sinterbecken",
    "γκουρ (λιθωματική λεκάνη)",
    "rimstone pool",
    NULL,
    NULL,
    "gour-poza",
    "gour",
    "vasca",
    "lago travertino",
    NULL,
    NULL,
    "гуры с водой",
    "sintrové jazierko",
    "vaska uji",
  },
  {
    "kořeny",
    "Holzreste",
    "ρίζες",
    "root",
    NULL,
    NULL,
    "raíz",
    "racine",
    "radice",
    "raiz",
    NULL,
    NULL,
    "корни растений",
    "korene",
    "rrenje",
  },
  {
    "lano",
    "Seil",
    "σχοινί",
    "rope",
    NULL,
    NULL,
    "cuerda",
    "corde",
    "corda",
    "corda",
    NULL,
    NULL,
    "линейная опора",
    "lano",
    "litar",
  },
  {
    "lanový žebřík",
    "Drahtseilleiter",
    "ανεμόσκαλα",
    "rope ladder",
    NULL,
    NULL,
    "escala",
    "échelle de corde",
    "scala di corda",
    "escada de corda",
    NULL,
    NULL,
    "гибкая лестница",
    "lanový rebrík",
    "shkalle litari",
  },
  {
    "písek",
    "Sand",
    "άμμος",
    "sand",
    NULL,
    NULL,
    "arena",
    "sable",
    "sabbia",
    "areia",
    NULL,
    NULL,
    "песок",
    "piesok",
    "rane",
  },
  {
    "erozní útvary",
    "Fließfacette",
    "σκάλοπ (κενά διάβρωσης)",
    "scallop",
    NULL,
    NULL,
    "cavitaciones",
    "vagues d’érosion (coups de gouge)",
    "scallop",
    "marcas de fluxo",
    NULL,
    NULL,
    "фасетки",
    "lastúrovité jamky",
    "guacat",
  },
  {
    "příčný řez",
    "Schnitt",
    "τομή",
    NULL,
    NULL,
    NULL,
    "sección",
    "section",
    "sezione",
    "seção",
    "seção",
    "secção",
    "сечение",
    "priečny rez",
    "pike-ndarje",
  },
  {
    "ponor",
    "Schluckloch",
    "καταβόθρα",
    "sink",
    NULL,
    NULL,
    "sumidero",
    "perte",
    "perdita",
    "sumidouro",
    NULL,
    NULL,
    "сток",
    "ponor",
    "pus",
  },
  {
    "sníh",
    "Schnee",
    "χιώνι",
    "snow",
    NULL,
    NULL,
    "nieve",
    "neige",
    "neve",
    "neve",
    NULL,
    NULL,
    "снег",
    "sneh",
    "bore",
  },
  {
    "brčka",
    "Makkaroni",
    "μακαρόνια",
    "soda straw",
    NULL,
    NULL,
    "fistulosa",
    "fistuleuse",
    "tubolare",
    "canudos",
    NULL,
    "tubulares",
    "сталактиты-соломины",
    "brčká",
    "shkopinje sode",
  },
  {
    "vývěr",
    "Quelle",
    "πηγή",
    "spring",
    NULL,
    NULL,
    "surgencia",
    "source",
    "sorgente",
    "nascente",
    NULL,
    NULL,
    "исток",
    "výver",
    "burim",
  },
  {
    "stalaktit",
    "Stalaktit",
    "σταλακτίτης",
    "stalactite",
    NULL,
    NULL,
    "estalactita",
    "stalactite",
    "stalattite",
    "estalactite",
    NULL,
    NULL,
    "сталактит",
    "stalaktit",
    "stalaktit",
  },
  {
    "stalagmit",
    "Stalagmit",
    "σταλαγμίτης",
    "stalagmite",
    NULL,
    NULL,
    "estalagmita",
    "stalagmite",
    "stalagmite",
    "estalagmite",
    NULL,
    NULL,
    "сталагмит",
    "stalagmit",
    "stalagmit",
  },
  {
    "měřičský bod",
    "Messpunkt",
    "σημείο χαρτογράφησης",
    "survey station",
    NULL,
    NULL,
    "estación",
    "station topo",
    "caposaldo",
    "base",
    NULL,
    NULL,
    "пикет",
    "meračský bod",
    "stacioni I matjes",
  },
  {
    "číslo měřičského bodu",
    "Messpunktname",
    "όνομα σημείου χαρτογράφησης",
    "survey station name",
    NULL,
    NULL,
    "nombre estacion",
    "station topo, nom",
    "node del caposaldo",
    "nome de base",
    NULL,
    NULL,
    "номер пикета",
    "číslo meračského bodu",
    "emri I stacionit-mates",
  },
  {
    "měřičský bod (stabilizovaný)",
    "dauerhafter Messpunkt",
    "μόνιμο σημείο χαρτογράφησης",
    "fixed survey station",
    NULL,
    NULL,
    "estación (fija)",
    "station topo, fixe",
    "caposaldo fisso",
    "base fixa",
    NULL,
    NULL,
    "репер",
    "meračský bod (stabilizovaný)",
    "stacion mates I palevizshem",
  },
  {
    "měřičský bod (přírodní)",
    "natürlicher Messpunkt",
    "σημείο χαρτογράφησης (φυσικό)",
    "natural survey station",
    NULL,
    NULL,
    "estación (natural)",
    "station topo, naturelle",
    "caposaldo naturale",
    "base natural",
    NULL,
    NULL,
    "естественная точка привязки",
    "meračský bod (prírodný)",
    "stacion mates natyral",
  },
  {
    "měřičský bod (zabarvený)",
    "farbig markierter Messpunkt",
    "σημείο χαρτογράφησης (βαμμένο)",
    "painted survey station",
    NULL,
    NULL,
    "estación (pintada)",
    "station topo, peinte",
    "caposaldo verniciato",
    "base pintada",
    NULL,
    NULL,
    "нарисованный пикет",
    "meračský bod (zafarbený)",
    "stacion mates I ngjyrosur",
  },
  {
    "měřičský bod (nestabilizovaný)",
    "unmarkierter Messpunkt",
    "προσωρινό σημείο χαρτογράφησης",
    "temporary survey station",
    NULL,
    NULL,
    "estación topográfica",
    "station topo temporaire",
    "caposaldo termporaneo",
    "base temporária",
    NULL,
    NULL,
    "временный пикет",
    "meračský bod (nestabilizovaný)",
    "stacion mates I perkohshem",
  },
  {
    "schody",
    "Stufen",
    "σκαλοπάτια",
    "steps",
    NULL,
    NULL,
    "escalones",
    "marches",
    "scalini",
    "degraus",
    NULL,
    NULL,
    "ступени",
    "schody",
    "shkalle",
  },
  {
    "traverz",
    "Querung",
    "τραβέρσα",
    "traverse",
    NULL,
    NULL,
    "pasamanos",
    "traversée",
    "traverso",
    "travessia",
    NULL,
    NULL,
    "троллей",
    "traverz",
    "kalim anesore",
  },
  {
    "zbytky rostlin",
    "Pflanzenreste",
    "φυτικά κατάλοιπα",
    "vegetable debris",
    NULL,
    NULL,
    "detritus vegetales",
    "débris végétaux",
    "detriti vegetali",
    "restos vegetais",
    NULL,
    NULL,
    "останки растительности",
    "zvyšky rastlín",
    "mbetje perimesh",
  },
  {
    "nadmořská výška bodu na stěně",
    "Höhe über Koordinatenursprung",
    "ύψος τοίχου",
    "altitude",
    NULL,
    NULL,
    "altura pared",
    "altitude",
    "altezza",
    "altura",
    NULL,
    NULL,
    "высотная отметка стены",
    "nadmorská výška bodu na stene",
    "lartesia mbidetare e murit",
  },
  {
    "vápencový povlak",
    "Wandsinter",
    "ασβεστίτης τοιχώματος",
    "wall calcite",
    NULL,
    NULL,
    "calcita",
    "mur, calcite",
    "calcite",
    "parede de calcita",
    "parede de calcita",
    "parede de calcite",
    "настенный кальцит",
    "vápencový povlak",
    "kalcit-muri",
  },
  {
    "voda",
    "Wasser",
    "νερό",
    "water",
    NULL,
    NULL,
    "agua",
    "eau",
    "acqua",
    "água",
    NULL,
    NULL,
    "вода",
    "voda",
    "uje",
  },
  {
    "vodní tok",
    "Gerinne",
    "υδρορροή",
    "water flow",
    NULL,
    NULL,
    "curso agua",
    "rivière",
    "corso d'acqua",
    "fluxo de água",
    NULL,
    NULL,
    "водоток",
    "vodný tok",
    "rrjedhe uji",
  },
  {
    "občasný vodní tok",
    "zeitweises Gerinne",
    "διακοπτόμενη υδρορροή",
    "intermittent water flow",
    NULL,
    NULL,
    "curso agua intermitente",
    "rivière, intermittente",
    "corso d'acqua temporaneo",
    "fluxo de água intermitente",
    NULL,
    NULL,
    "непостоянный водоток",
    "občasný vodný tok",
    "rrjedhe uji me force",
  },
  {
    "paleořečiště",
    "ehemaliges Gerinne",
    "παλαιουδρορροή",
    "paleo water flow",
    NULL,
    NULL,
    "paleocurso agua",
    "rivière fossile",
    "paleocorso d'acqua",
    "paleo-fluxo de água",
    NULL,
    NULL,
    "палео-поток",
    "paleoriečisko",
    "rrjedhe uji e vjeter",
  },
  {
    "vodní tok",
    "ständiges Gerinne",
    "μόνιμη υδρορροή",
    "water flow",
    NULL,
    NULL,
    "curso agua",
    "rivière, permanente",
    "corso d'acqua permanente",
    "fluxo de água permanente",
    NULL,
    NULL,
    "постоянный водоток",
    "vodný tok",
    "rrjedhe uji e perhershme",
  },
  {
    "Kreslil",
    "Zeichnung",
    "Σκαρίφημα",
    "Drawn by",
    NULL,
    NULL,
    "Cartografía",
    "Dessinateur",
    "Cartografia",
    "Desenhada por",
    NULL,
    NULL,
    "Камеральная обработка",
    "Kreslil",
    "vizatuar nga",
  },
  {
    "Kreslili",
    "Zeichnung",
    "Σκαρίφημα",
    "Drawn by",
    NULL,
    NULL,
    "Cartografía",
    "Dessinateurs",
    "Cartografia",
    "Desenhadas por",
    NULL,
    NULL,
    "Камеральная обработка",
    "Kreslili",
    "vizatuar nga",
  },
  {
    "Převýšení",
    "Niveaudifferenz",
    "Βάθος",
    "Depth",
    NULL,
    NULL,
    "Desnivel",
    "Profondeur",
    "Profondità",
    "Desnível",
    NULL,
    NULL,
    "Глубина",
    "Prevýšenie",
    "thellesia",
  },
  {
    "Délka",
    "Gesamtlänge",
    "Μήκος",
    "Length",
    NULL,
    NULL,
    "Desarrollo",
    "Longueur",
    "Sviluppo",
    "Extensão",
    NULL,
    NULL,
    "Длина",
    "Dĺžka",
    "gjatesia",
  },
  {
    "Nadmořské výšky",
    "Höhe des Titelfeldes",
    "Υψομετρικά",
    "Altitudes",
    NULL,
    NULL,
    "color (altitud)",
    "Altitudes",
    "Profondità",
    "Altitudes",
    NULL,
    NULL,
    "Высотная шкала",
    "Nadmorské výšky",
    "titulli ngjyra-permbajtja-lartesia mbidetare",
  },
  {
    "Mapy",
    "Karten",
    "Χάρτες",
    "Maps",
    NULL,
    NULL,
    "color (mapa)",
    "Cartes",
    "Mappa",
    "Mapas",
    NULL,
    NULL,
    "Карты",
    "Mapy",
    "hartat",
  },
  {
    "Objevil",
    "Entdeckung",
    "Εξερευνητής",
    "Explored by",
    NULL,
    NULL,
    "Exploración",
    "Explorateur",
    "Esplorazione",
    "Explorada por",
    NULL,
    NULL,
    "Исследование",
    "Objavil",
    "hulumtuar nga",
  },
  {
    "Objevili",
    "Entdeckung",
    "Εξερευνητές",
    "Explored by",
    NULL,
    NULL,
    "Exploración",
    "Explorateurs",
    "Esplorazione",
    "Exploradas por",
    NULL,
    NULL,
    "Исследование",
    "Objavili",
    "hulumtuar nga",
  },
  {
    "Legenda",
    "Legende",
    "Τίτλος",
    "Legend",
    NULL,
    NULL,
    "Leyenda",
    "Légende",
    "Legenda",
    "Legenda",
    NULL,
    NULL,
    "Условные обозначения",
    "Legenda",
    "permbajtja",
  },
  {
    "[Náhled horních vrstev]",
    "Vorschau oben",
    "[προεπισκόπηση πάνω]",
    "[Preview above]",
    NULL,
    NULL,
    "Vista previa superior",
    "[Prévisualisation au-dessus]",
    "Anteprima sopra",
    "[Visualização acima]",
    NULL,
    NULL,
    "[Вид выше]",
    "[Náhľad horných vrstiev]",
    "parashiqimi lart",
  },
  {
    "[Náhled dolních vrstev]",
    "Vorschau unten",
    "[προεπισκόπηση κάτω]",
    "[Preview below]",
    NULL,
    NULL,
    "Vista previa inferior",
    "[Prévisualisation au-dessous]",
    "Anteprima sotto",
    "[Visualização abaixo]",
    NULL,
    NULL,
    "[Вид ниже]",
    "[Náhľad spodných vrstiev]",
    "parashiqimi perfundi",
  },
  {
    "[Povrchová mapa]",
    "Erdoberfläche",
    "[χάρτης επιφάνειας]",
    "[Surface map]",
    NULL,
    NULL,
    "Mapa superficie",
    "[Carte extérieure]",
    "Mappa superficie",
    "[Mapa de superfície]",
    NULL,
    NULL,
    "[Карта поверхности]",
    "[Povrchová mapa]",
    "harta e siperfaqes",
  },
  {
    "Měřil",
    "Vermessung",
    "Χαρτογραφήθηκε από τον",
    "Surveyed by",
    NULL,
    NULL,
    "Topografía",
    "Topographe",
    "Topografia",
    "Topografada por",
    NULL,
    NULL,
    "Съемка",
    "Zameral",
    "matur nga",
  },
  {
    "Měřili",
    "Vermessung",
    "Χαρτογραφήθηκε από τους",
    "Surveyed by",
    NULL,
    NULL,
    "Espeleometría",
    "Topographes",
    "Topografia",
    "Topografadas por",
    NULL,
    NULL,
    "Съемка",
    "Zamerali",
    "matur nga",
  },
  {
    "ft",
    "ft",
    "πόδια",
    "ft",
    NULL,
    NULL,
    "ft",
    "ft",
    "ft",
    "pés",
    NULL,
    NULL,
    "футов",
    "ft",
    "njesia matese-kembe",
  },
  {
    "m",
    "m",
    "μ",
    "m",
    NULL,
    NULL,
    "m",
    "m",
    "m",
    "m",
    NULL,
    NULL,
    "м",
    "m",
    "njesia matese-metri",
  },
};

 
 
