;; Copyright (C) 2008-2013 Tommi Höynälänmaa
;; Distributed under GNU General Public License version 3,
;; see file doc/GPL-3.


(library (theme-d translator theme-d-linker)


  (export theme-open-input-file
	  theme-read
	  theme-close-input-port
	  write-line-info
	  gl-show-info?
	  debug-level
	  parse-search-path
	  theme-file-exception?
	  get-file-error-message
	  is-module-name?
	  dw1
	  dwl1
	  theme-link-program
	  gl-linker)

  
  (import (guile)
	  (rnrs exceptions)
	  (srfi srfi-1)
	  (srfi srfi-13)
	  (srfi srfi-43)
	  (th-scheme-utilities stdutils)
	  (th-scheme-utilities hrecord)
	  (theme-d common theme-d-config))

	  
  (define platform 'guile)

  (init-theme-d-config)
  
  (define gl-theme-d-translator-dir
    (get-theme-d-config-var 'translator-dir))


  (define (load-theme-file filename)
    (load-compiled
     (string-append gl-theme-d-translator-dir "/" filename ".go")))

  
  ;; *** Handling variable names ***

  (load-theme-file "theme-d-var-names")


  ;; *** Debug output ***

  (load-theme-file "theme-d-print-target-object")


  ;; *** Debugging ***

  (load-theme-file "theme-d-debug")


  ;; *** Common ***

  (load-theme-file "theme-d-common")
					;(use-modules (theme common))


  ;; *** Support for hash tables ***

  ;; (dwl4 "Hash tables")
  (load-theme-file "theme-d-hash-tables")


  ;; *** Symbol table ***
					;(use-modules (general hrecord))
  ;; (dwl4 "Symbol table")
  (load-theme-file "theme-d-symbol-table")
					;(use-modules (theme symbol-table))


  ;; *** Entities ***

  ;; (dwl4 "Entities")
  (load-theme-file "theme-d-entities")


  ;; *** Expressions ***

  ;; (dwl4 "Expressions")
  (load-theme-file "theme-d-expressions")
  ;;(use-modules (theme expressions))


  ;; *** Keywords ***

  ;; (dwl4 "Keywords")
  (load-theme-file "theme-d-keywords")


  ;; *** File handling ***

  ;; (dwl4 "File handling")
  (load-theme-file "theme-d-file-handling")


  ;; *** Common definitions for errors ***

  ;; (dwl4 "Common definitions for errors")
  (load-theme-file "theme-d-errors-common")


  ;; *** Linker error output ***

  ;; (dwl4 "Linker error output")
  (load-theme-file "theme-d-linker-errors")


  ;; *** Representation of target objects ***

  ;; (dwl4 "Representation")
  (load-theme-file "theme-d-representation")


  ;; *** Parametrized instance cache ***

  ;; (dwl4 "Parametrized instance cache")
  (load-theme-file "theme-d-param-cache")


  ;; *** Binder ***

  ;; (dwl4 "Binder")
  (load-theme-file "theme-d-binder")


  ;; *** Address environment ***

  ;; (dwl4 "Address environment")
  (load-theme-file "theme-d-address-environment")


  ;; *** Core definitions for linking ***
  ;; (dwl4 "Linker core def.")
  (load-theme-file "theme-d-linker-core-def")


  ;; *** Type system ***

  ;; (dwl4 "Type system")
  (load-theme-file "theme-d-type-system")


  ;; *** Common utilities for procedures ***

  ;; (dwl4 "Common procedure utilities")
  (load-theme-file "theme-d-common-procedure-utilities")


  ;; *** Translation of type expressions ***

  ;; (dwl4 "Translation of type expressions")
  (load-theme-file "theme-d-type-translation")


  ;; *** Finalization of builtin types ***

  ;; (dwl4 "Finalization of builtin types")
  (load-theme-file "theme-d-builtin-type-finalization")


  ;; *** Translation common ***

  ;; (dwl4 "Translation common")
  (load-theme-file "theme-d-translation-common")


  ;; *** Constructors ***

  ;; (dwl4 "Constructors")
  (load-theme-file "theme-d-constructors")


  ;; *** Parametrized definitions ***

  ;; (dwl4 "Utilities for parametrized definitions")
  (load-theme-file "theme-d-parametrized-definitions")


  ;; *** Parametrized instances ***

  ;; (dwl4 "Parametrized instances")
  (load-theme-file "theme-d-parametrized-instances")


  ;; *** Translation of expressions ***

  ;; (dwl4 "Translation of expressions")
  (load-theme-file "theme-d-expression-translation")


  ;; *** Expression rebinding ***

  ;; (dwl4 "Expression rebinding")
  (load-theme-file "theme-d-expression-rebinding")


  ;; *** Expression cloning ***

  ;; (dwl4 "Expression cloning")
  (load-theme-file "theme-d-expression-cloning")


  ;; *** Special procedures ***
  ;; These are needed for expression cloning in the linker.

  ;; (dwl4 "Special procedures")
  (load-theme-file "theme-d-special-procedures")


  ;; *** Pseudocode common ***

  ;; (dwl4 "Pseudocode common")
  (load-theme-file "theme-d-pcode-common")


  ;; *** Reading implementation pseudocode ***

  ;; (dwl4 "Implementation pseudocode reading")
  (load-theme-file "theme-d-implementation-pcode-reading")


  ;; *** Stripping unused code ***

  ;; (dwl4 "Stripping unused code")
  (load-theme-file "theme-d-stripping")


  ;; *** Handling cyclic data structures ***

  ;; (dwl4 "Cycles")
  (load-theme-file "theme-d-cycles")


  ;; *** Linker instantiation and factorization ***

  ;; (dwl4 "Linker instantiation and factorization")
  (load-theme-file "theme-d-linker-instantiation")


  ;; *** Target code compilation common procedures ***

  ;; (dwl4 "Target code compilation common procedures")
  (load-theme-file "theme-d-target-compilation-common")


  ;; *** Tree-IL target code compilation ***

  ;; (dwl4 "Tree-IL target code compilation")
  (load-theme-file "theme-d-tree-il-target-compilation")


  ;; *** Scheme target code compilation ***

  ;; (dwl4 "Scheme target code compilation")
  (load-theme-file "theme-d-scheme-target-compilation")


  ;; *** Call with current continuation ***

  ;; (dwl4 "Call with current continuation")
  (load-theme-file "theme-d-call-cc")


  ;; *** Builtin definitions ***

  ;; (dwl4 "Builtins")
  (load-theme-file "theme-d-builtins")


  ;; *** Program linking main program ***


  ;; (dwl4 "Program linking main program")
  (load-theme-file "theme-d-link-program"))
