#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <string.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <sys/time.h>
#include <time.h>
#include <netinet/in.h>
#include <netdb.h>
#include <arpa/inet.h>
#include <sys/stat.h>

#define MAX( a, b ) ( (a) > (b) ? (a) : (b) )
#define MAX_PACK_SIZE ( 64 * 1024 )

/* Included by Allyson & Milena to get the flags from the mcast packet */
#define FLAGS 1
#define SENT_BY_PROXY 1
#define get(dest, org, bytes) { bzero(dest,bytes); memcpy(dest,org, bytes); org+=bytes; }

typedef struct
{
    char * group_addr;
    char ** addr_list;
    int n_addr;
    char ttl;
    char reuse_addr;

/* Included by Allyson */
    char enable_loopback;

    int ucast_port; 
    int mcast_port;
} Config;

int read_config_file( FILE *, Config * );
int create_ucast_socket( Config * );
int create_mcast_socket( Config *, struct sockaddr_in *);
int convert_addr( Config *, struct sockaddr_in *, struct sockaddr_in ** );
void close_mcast_sock( int , struct sockaddr_in * );

int main( int argc, char * argv[] )
{   
    Config config;
    FILE * fp;
    FILE * pidfile;
    struct timeval current_time;
    struct tm time;
    struct sockaddr_in group_addr;
    struct sockaddr_in * addr_list;
    fd_set readfds;
    int mcast_sock, ucast_sock, byread, bysent, i;
    char pack_buf[MAX_PACK_SIZE];
    char mcastproxy_config_file[255];
    char mcastproxy_pid_file[255];
    char *homedir;
    
    /* Included by Allyson & Milena to get the flags from the mcast packet */
    unsigned char flags;
    
    if ( (homedir = getenv("HOME")) != NULL ){
         sprintf(mcastproxy_pid_file,"%s/.tgwb/mcastproxy.pid",homedir);
         if ( (pidfile = fopen( mcastproxy_pid_file, "w" ))==NULL ){
            fprintf(stderr,"\n[mcastproxy Error] Opening %s file.\n",mcastproxy_pid_file);
            exit( -1 );
         }
        fprintf(pidfile,"%d",(int)getpid());
        fclose(pidfile);
    }
    else{
        fprintf(stderr,"\n[mcastproxy Error] $HOME environment variable not found\n");
        exit( -1);
    }
    

    printf("\n----------------------------\n");    
    printf("Starting mcastproxy ...\n");

    printf("\tReading mcastproxy.conf ...");
    
    sprintf(mcastproxy_config_file,"%s/.tgwb/mcastproxy.conf",homedir);
    if ( (fp = fopen( mcastproxy_config_file, "r" ))==NULL){
         fprintf(stderr,"\n[mcastproxy Error] Opening configuration file '%s'\n",mcastproxy_config_file);
         exit( -1 );
    }

    if( read_config_file( fp, &config ) < 0 )
    {
        fprintf(stderr,"\n[mcastproxy Error] Invalid Configuration file." );
        exit( -1 );
    }
    printf(" OK!\n");
    if( convert_addr( &config, &group_addr, &addr_list ) < 0 )
    {
        fprintf(stderr,"\n\n[mcastproxy Error] Could not resolve host.\n" );
        exit( -1 );
    }
    
    mcast_sock = create_mcast_socket( &config, &group_addr );
    if( mcast_sock < 0 )
    {
        fprintf(stderr,"\n[mcastproxy Error] Creating the multicast socket." );
        exit( -1 );
    }

    ucast_sock = create_ucast_socket( &config );
    if( ucast_sock < 0 )
    {
        fprintf(stderr,"\n[mcastproxy Error] Creating the unicast socket.\n" );
        exit( -1 );
    }
    
    printf("mcastproxy is running.\n");
    printf("----------------------------\n");
    while( 1 )
    {
       FD_ZERO( &readfds ); 
       FD_SET( mcast_sock, &readfds );
       FD_SET( ucast_sock, &readfds );
       if(select(MAX(mcast_sock,ucast_sock)+1, &readfds, NULL, NULL, NULL) <0)
       {
            fprintf(stderr,"\n[mcastproxy Error]Select error." );
            continue;
       }
       if( FD_ISSET( mcast_sock, &readfds ) )
       {
            byread = recv( mcast_sock, pack_buf, MAX_PACK_SIZE, 0 );
            //printf( "Multicast RECV. %d bytes received\n", byread );

            if( byread > 0 )
            {
                gettimeofday(&current_time, 0);    
                time = *gmtime((const time_t*)&current_time);
                current_time.tv_sec = ( (time.tm_hour * 60 + time.tm_min) * 60 ) + time.tm_sec;

                for( i = 0; i < config.n_addr; i++ )
                {
                    /* Included by Allyson & Milena to get the flags from the mcast packet */                    
                    if( config.enable_loopback == 1 )
                        flags=pack_buf[FLAGS];
                    //fprintf(stderr,"flag=%d\n",flags);

                    if( (config.enable_loopback == 0) || (flags != SENT_BY_PROXY) )
                    {
                        bysent = sendto( ucast_sock, pack_buf, byread, 0, 
                                (struct sockaddr *)&addr_list[i],
                                sizeof( struct sockaddr ) );

                        //printf( "Unicast SEND. %d bytes sent to %s\n", bysent,config.addr_list[i] );

                        if( bysent < 0 )
                            perror( "sendto" );
                        usleep(1);
                    }
                    //else fprintf(stderr,"My own packet received!\n");
                               
                }

                if( bysent > 0 ){
                    gettimeofday(&current_time, 0);    
                    time = *gmtime((const time_t*)&current_time);
                    current_time.tv_sec = ( (time.tm_hour * 60 + time.tm_min) * 60 ) + time.tm_sec;
/*                     fprintf(logfile,"%.0Lf %s %d\n",( (((long double)current_time.tv_sec)*1000000+(long
                    double)current_time.tv_usec) ),"S U",byread); */
                }

            }
       }
       if( FD_ISSET( ucast_sock, &readfds ) )
       {
            byread = recv( ucast_sock, pack_buf, MAX_PACK_SIZE, 0 );
            //printf( "Unicast RECV. %d bytes received\n", byread );

            if( byread > 0 )
            {
                gettimeofday(&current_time, 0);    
                time = *gmtime((const time_t*)&current_time);
                current_time.tv_sec = ( (time.tm_hour * 60 + time.tm_min) * 60 ) + time.tm_sec;
/*                 fprintf(logfile,"%.0Lf %s %d\n",( (((long double)current_time.tv_sec)*1000000+(long
                double)current_time.tv_usec) ),"R U",byread);
 */
                memset( &group_addr, 0, sizeof(group_addr) );
                group_addr.sin_family = AF_INET;
                group_addr.sin_port = htons(config.mcast_port);
                group_addr.sin_addr.s_addr = inet_addr( config.group_addr );
                //printf( "sending to %s\n", config.group_addr );
                
                /* Included by Allyson & Milena to get the flags from the mcast packet */
                if( config.enable_loopback == 1 )
                    pack_buf[FLAGS] = SENT_BY_PROXY;
                
                bysent = sendto( mcast_sock, pack_buf, byread, 0,
                                 (struct sockaddr *) &group_addr, 
                                 sizeof( struct sockaddr ) );
                //printf( "Multicast SEND. %d bytes sent\n", bysent );
                if( bysent < 0 ){
                    perror( "sendto" );
                }
                else{
                    gettimeofday(&current_time, 0);    
                    time = *gmtime((const time_t*)&current_time);
                    current_time.tv_sec = ( (time.tm_hour * 60 + time.tm_min) * 60 ) + time.tm_sec;
/*                     fprintf(logfile,"%.0Lf %s %d\n",( (((long double)current_time.tv_sec)*1000000+(long
                    double)current_time.tv_usec) ),"S M",byread); */
                }
                usleep(1);
            }
       }
    }
    close_mcast_sock( mcast_sock, &group_addr );
    close( ucast_sock );

    return 0;
}


int read_config_file( FILE * fp, Config * config )
{
    char line[100];
    char * temp;
    int i;
    
    if( fgets( line, 100, fp ) == NULL )
        return -1;
    
    if( ( temp = strchr( line, '=' ) ) == NULL )
        return -1;
    temp++;
    if( temp[strlen(temp)-1] == '\n' )
        temp[strlen(temp)-1] = '\0';
    
    config->group_addr = strdup( temp );
    
    if( fgets( line, 100, fp ) == NULL )
        return -1;
    
    if( ( temp = strchr( line, '=' ) ) == NULL )
        return -1;
    
    temp++;
    config->n_addr = atoi( temp );
    config->addr_list = ( char ** ) malloc( sizeof(char *) * config->n_addr );

    if( fgets( line, 100, fp ) == NULL )
        return -1;
/* We will read one IP address or hostname per line    */
    for ( i=0;i<config->n_addr;i++)
    {
        if( fgets( line, 100, fp ) == NULL )
            return -1;

        line[strlen(line)-1]='\0';
        config->addr_list[i]=strdup(line);
    }
    
    if( fgets( line, 100, fp ) == NULL )
        return -1;
    
    if( ( temp = strchr( line, '=' ) ) == NULL )
        return -1;
    temp++;
    config->ttl = (char) atoi( temp );
    
    if( fgets( line, 100, fp ) == NULL )
        return -1;
    
    if( ( temp = strchr( line, '=' ) ) == NULL )
        return -1;
    temp++;
    config->reuse_addr = (char) atoi( temp );
    
    if( fgets( line, 100, fp ) == NULL )
        return -1;
    
    if( ( temp = strchr( line, '=' ) ) == NULL )
        return -1;
    temp++;
    config->enable_loopback = (char) atoi( temp );
    
    if( fgets( line, 100, fp ) == NULL )
        return -1;
    
    if( ( temp = strchr( line, '=' ) ) == NULL )
        return -1;
    temp++;
    config->ucast_port = atoi( temp );
    
    if( fgets( line, 100, fp ) == NULL )
        return -1;
    
    if( ( temp = strchr( line, '=' ) ) == NULL )
        return -1;
    temp++;
    config->mcast_port = atoi( temp );
    
    return 0;
}

int create_ucast_socket( Config * config )
{
    int sckd;
    struct sockaddr_in addr;

    memset( &addr, 0, sizeof( addr ) );
    
    sckd = socket( AF_INET, SOCK_DGRAM, 0 );
    
    if( sckd > 0 )
    {
        addr.sin_family = AF_INET;
        addr.sin_addr.s_addr = INADDR_ANY;
        addr.sin_port = htons( config->ucast_port );
        
        if( bind( sckd, (struct sockaddr *) &addr, sizeof( addr ) ) < 0 ){
            perror("Binding");
            return -1;
        }
    }
    
    return sckd;  
}

int create_mcast_socket( Config * config , struct sockaddr_in * group_addr)
{
    int sckd;
    unsigned char byte;  /* variable used to enable/disable loopback */
    struct sockaddr_in groupHost; /* multicast group host info structure */
    struct ip_mreq mreq;  /* multicast group info structure */
    int flag;

    byte = 1;
    
    /* Get the multicast group host information */
    groupHost.sin_family = AF_INET;
    groupHost.sin_port = htons(config->mcast_port);
    groupHost.sin_addr.s_addr = htonl(INADDR_ANY);
  
    /* Allocate a UDP socket and set the multicast options */

    if ( ( sckd = socket( AF_INET, SOCK_DGRAM, 0 ) ) < 0 )
        return -1;
   
    /* allow multipule processes to bind to same multicast port */
    flag = 1;
    if ( setsockopt(sckd, SOL_SOCKET,SO_REUSEADDR, (char *)&flag, sizeof(flag) ) == -1 )
        return -1;

    /* bind the UDP socket to the mcast address to recv messages from the group */
    if( bind( sckd,(struct sockaddr *) &groupHost, sizeof(groupHost) )< 0 )
        return -1;

    byte = config->ttl;
    if( setsockopt( sckd,IPPROTO_IP,IP_MULTICAST_TTL, &byte, sizeof(byte) ) < 0 )
        return -1;

    byte = config->enable_loopback;  /*enable loopback*/   
    if( setsockopt( sckd,IPPROTO_IP,IP_MULTICAST_LOOP, (char *)&byte, sizeof(byte) ) < 0 )
        return -1;

    /* check if group address is indeed a Class D address */
    mreq.imr_multiaddr = group_addr->sin_addr;
    mreq.imr_interface.s_addr = INADDR_ANY;
  
    if ( setsockopt(sckd,IPPROTO_IP,IP_ADD_MEMBERSHIP,(char *) &mreq,
		  sizeof(mreq)) < 0 )
        return -1;    
    
    return sckd;
}

int convert_addr( Config * config, struct sockaddr_in * group_addr, 
                struct sockaddr_in ** addr_list )
{
    struct hostent *host;
    int i;

    memset( group_addr, 0, sizeof(*group_addr) );
    group_addr->sin_family = AF_INET;
    group_addr->sin_port = htons(config->mcast_port);
    group_addr->sin_addr.s_addr = inet_addr( config->group_addr );
    (*addr_list) = (struct sockaddr_in *) malloc( config->n_addr * 
                                                  sizeof(struct sockaddr_in) ) ;
    for( i = 0; i < config->n_addr; i++ )
    {
        memset( &((*addr_list)[i]), 0, sizeof((*addr_list)[i]) );
        (*addr_list)[i].sin_family = AF_INET;
        (*addr_list)[i].sin_port   = htons(config->ucast_port);
        
        printf("\tAdding host %s ...",config->addr_list[i]);
        host = gethostbyname( config->addr_list[i] );    
        if( host == 0 ){
            fprintf(stderr,"\n[mcastproxy Error] Resolving host '%s'\n",config->addr_list[i]);
            return -1;
        }
        printf(" OK!\n");
        
        memcpy( &((*addr_list)[i].sin_addr), host->h_addr, host->h_length ); 
    }
    return 0;
}

void close_mcast_sock( int mcast_sock, struct sockaddr_in * group_addr )
{
    struct ip_mreq dreq;  /* multicast group info structure */

    dreq.imr_multiaddr = group_addr->sin_addr;
    dreq.imr_interface.s_addr = INADDR_ANY;
  
    setsockopt(mcast_sock,IPPROTO_IP,IP_DROP_MEMBERSHIP,
              (char *) &dreq,sizeof(dreq));
}
