/* help.h: help messages for web2c programs.

   This is included by everyone, from cpascal.h.  This is better than
   putting the help messages directly in the change files because (1)
   multiline strings aren't supported by tangle, and it would be a pain
   to make up a new syntax for them in web2c, and (2) when a help msg
   changes, we need only recompile, not retangle or reconvert.  The
   downside is that everything gets recompiled when any msg changes, but
   that's better than having umpteen separate tiny files.  (For one
   thing, the messages have a lot in common, so it's nice to have them
   in one place.)

Copyright (C) 1995, 96 Karl Berry, 2001 O.Weber.

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.  */

/* Note: Help messages for TeX & MF family moved to texmfmp-help.h, to
   prevent multiple-definition errors. */

#ifndef HELP_H
#define HELP_H

#ifdef BIBTEX
const_string BIBTEXHELP[] = {
    "Usage: jbibtex [OPTION]... AUXFILE[.aux]",
    "  Write bibliography for entries in AUXFILE to AUXFILE.bbl.",
    "",
    "-min-crossrefs=NUMBER  include item after NUMBER cross-refs; default 2",
    "-terse                 do not print progress reports",
    "-help                  display this help and exit",
    "-version               output version information and exit",
    NULL
};    
#endif /* BIBTEX */

#endif /* not HELP_H */
