#!/bin/sh
# Created by Kapil Hari Paranjape <kapil@imsc.res.in>
# This updates the html documentation in debian/{html,images}
# if the file debian/doc/tex4ht_doc.tex has changed.

set -e

mkdir -p doc
cd doc
cp -p ../debian/html/tex4ht_doc.tex .
cp -p ../debian/html/bg.cfg .

htlatex tex4ht_doc "bg"

mkdir -p images html

cp -p *.html *.tex *.css *.cfg html/
for i in *.png
do
	j=$(basename $i .png)
	uuencode $i < $i > images/$j.uue
done
cp -p ../debian/images/bgimage.uue images

for i in html images
do
	mv ../debian/$i ../debian/$i.old
	mv $i ../debian/$i
done

cd ..
rm -rf doc

