/*
 * window.h - a header file for window interface
 * by Hirotsugu Kakugawa
 */
/*
 * Copyright (C) 1996-1997 Hirotsugu Kakugawa. 
 * All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.  
 */

/** Cursor **/
#define CURSOR_READING     1
#define CURSOR_READY       2
#define CURSOR_DRAWING     3
#define CURSOR_DRAWING_PS  4

/** Page Cache **/
struct s_page_cache {
  int          w, h;   /* width, height */
  Pixmap       pix;    /* page image */
  int          page;   /* page no */
  DVI_CONTEXT  cont;   /* saved continuation on interruption */
  int          pending_eps;  /* the number of ignored eps figures */
  int          n_eps_figs;   /* the number of eps figures in this page */
};
typedef struct s_page_cache  *PAGE_CACHE;

/** X Window Status **/
struct s_xstat {
  Display        *xdisp;
  Window         view;
  int            cursor;
  int            page_width, page_height;
  int            offset_x, offset_y;
  unsigned long  default_color_char,  color_char;
  unsigned long  default_color_paper, color_paper;
  unsigned long  color_frame;
  PAGE_CACHE     page_cache;
  int            page_cache_size;
  XImage         image;
  GC             gc_pc_image_mask, gc_pc_image_put, gc_pc_image_rgb; 
  GC             gc_pc_rect, gc_pc_clear;
  GC             gc_pc_frame;
  GC             gc_copy, gc_clear;
};
typedef struct s_xstat  *XSTAT;


extern int              x_open_display(void);
extern int              x_visual_color_direct(void);
extern int              x_visual_color(void);
extern int              x_ui_make(void);
extern int              x_ui_loop(void);
extern int              x_poll(void);
extern void             x_put_rectangle(long,long,long,long);
extern void             x_put_bitmap(DVI_BITMAP,long,long);
extern void             x_put_pixmap_rgb(DVI_PIXMAP_RGB,long,long);
extern void             x_put_graymap(DVI_GRAYMAP,long,long);
extern void             x_change_color_fg(double,double,double);
extern void             x_change_color_bg(double,double,double,int);
extern void             x_change_color_gray_fg(double);
extern void             x_change_color_gray_bg(double,int);
extern void             x_reset_colors(void);
extern void             x_bell(void);
extern void             x_message(char*);
extern void             x_vmessage(char*,...);
extern void             x_error_message(char*);
extern void             x_error_vmessage(char*,...);
extern void             x_message_advice(char*);
extern void             x_vmessage_advice(char*,...);
extern void             x_cursor_change(int);
extern void             x_cancel_page_cache(void);
extern void             x_cancel_page_cache_by_eps_mode_change(void);
extern PAGE_CACHE       x_get_cache(int);
extern void             x_alloc_page_cache(double,int,int);
extern XrmDatabase      x_init_application_resources(void);
extern void             x_resource_set_defaults(RESOURCE);

extern int  x_ui_command;
#define UI_CMD_NONE            0
#define UI_CMD_QUIT            1
#define UI_CMD_REDRAW          2
#define UI_CMD_LOAD            3
#define UI_CMD_RELOAD          4
#define UI_CMD_PAGE            5

/*EOF*/
