/*
 * ui-opt.c - a module for option UI
 * by Hirotsugu Kakugawa
 */
/*
 * Copyright (C) 1996-1997 Hirotsugu Kakugawa. 
 * All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.  
 */

#include "../config.h"
#include <stdio.h>
#include <stdlib.h>
#include <sys/param.h>
#include <X11/Xlib.h>
#include <Xm/Xm.h>
#include <Xm/Form.h>
#include <Xm/Label.h>
#include <Xm/PushB.h>
#include <Xm/ToggleB.h>
#include <Xm/RowColumn.h>

#include "cf-xmdvi.h"
#include "dvi-2_6.h"
#include "defs.h"
#include "dev.h"
#include "resource.h"
#include "window.h"
#include "ui.h"

Private Widget  dialog_opt; 

Private void  cb_visual_text_change(Widget,int,
				    XmToggleButtonCallbackStruct*);
Private void  cb_eps_mode_change(Widget,int,
				 XmToggleButtonCallbackStruct*);
Private void  cb_visual_eps_change(Widget,int,
				   XmToggleButtonCallbackStruct*);
Private void  cb_epssty_mode_change(Widget,int,
				    XmToggleButtonCallbackStruct*);


Public Widget
x_make_panel_option(Widget parent)
{
  Widget  xpop, xfm, xtitle, xb_close, xsep1, xsep2, xsep3, xsep4;
  Widget  x_visu_text_label, x_visu_text_mode;
  Widget  xb_visu_text_mono, xb_visu_text_gray, xb_visu_text_rgb; 
  Widget  x_eps_label, x_eps_mode, xb_eps_yes, xb_eps_no;
  Widget  x_visu_eps_label, x_visu_eps_mode;
  Widget  xb_visu_eps_mono, xb_visu_eps_gray, xb_visu_eps_rgb; 
  Widget  x_epssty_label, x_epssty_mode;
  Widget  xb_epssty_latex2e_graphics, xb_epssty_latex209_epsf; 
  Arg     args[15];
  int     i;

  i = 0;
  XtSetArg(args[i], XmNdialogStyle, XmDIALOG_MODELESS); i++;
  xpop = XmCreateBulletinBoardDialog(parent, "Option", args, i);
  dialog_opt = xpop;

  xfm = XmCreateForm(xpop, "option", NULL, 0);
  XtManageChild(xfm);

  i = 0;
  XtSetArg(args[i], XmNlabelString, 
	   XmStringCreate("Options",
			  XmSTRING_DEFAULT_CHARSET));  i++;
  XtSetArg(args[i], XmNtopAttachment, XmATTACH_FORM);  i++;
  XtSetArg(args[i], XmNleftAttachment, XmATTACH_FORM);  i++;
  xtitle = XmCreateLabel(xfm, "title", args, i);
  XtManageChild(xtitle);
  i = 0;
  XtSetArg(args[i], XmNlabelString, 
	   XmStringCreate("Close", XmSTRING_DEFAULT_CHARSET)); i++;
  XtSetArg(args[i], XmNrightAttachment, XmATTACH_FORM);  i++;
  XtSetArg(args[i], XmNleftAttachment, XmATTACH_NONE);  i++;
  XtSetArg(args[i], XmNtopAttachment, XmATTACH_FORM);  i++;
  xb_close  = XmCreatePushButton(xfm, "close", args, i);
  XtAddCallback(xb_close, XmNactivateCallback, 
		(XtCallbackProc)cb_option_close, NULL);
  XtManageChild(xb_close);

  xsep1 = x_p_make_hsep(xfm);
  x_p_put_below(xsep1, xtitle);
  x_p_put_below(xsep1, xb_close);

  i = 0;
  XtSetArg(args[i], XmNlabelString, 
	   XmStringCreate("Visual Mode for Text",
			  XmSTRING_DEFAULT_CHARSET));  i++;
  XtSetArg(args[i], XmNleftAttachment, XmATTACH_FORM);  i++;
  XtSetArg(args[i], XmNtopAttachment, XmATTACH_WIDGET);  i++;
  XtSetArg(args[i], XmNtopWidget, xsep1);  i++;
  x_visu_text_label = XmCreateLabel(xfm, "label", args, i);
  XtManageChild(x_visu_text_label);

  i = 0;
  XtSetArg(args[i], XmNorientation, XmHORIZONTAL);  i++;
  XtSetArg(args[i], XmNpacking, XmPACK_COLUMN);  i++;
  XtSetArg(args[i], XmNtopAttachment, XmATTACH_WIDGET);  i++;
  XtSetArg(args[i], XmNtopWidget, x_visu_text_label);  i++;
  XtSetArg(args[i], XmNleftAttachment, XmATTACH_FORM);  i++;
  x_visu_text_mode = XmCreateRadioBox(xfm, "visualText", args, i);
  XtManageChild(x_visu_text_mode);
  xb_visu_text_mono
    = XtCreateManagedWidget("Monochrome", xmToggleButtonWidgetClass, 
			    x_visu_text_mode, NULL, 0);
  XtAddCallback(xb_visu_text_mono, XmNvalueChangedCallback,
		(XtCallbackProc)cb_visual_text_change, 
		(XtPointer)VISUAL_MONO);
  xb_visu_text_gray
    = XtCreateManagedWidget("Grayscale", xmToggleButtonWidgetClass, 
			    x_visu_text_mode, NULL, 0);
  XtAddCallback(xb_visu_text_gray, XmNvalueChangedCallback,
		(XtCallbackProc)cb_visual_text_change, 
		(XtPointer)VISUAL_GRAY);
  xb_visu_text_rgb
    = XtCreateManagedWidget("RGB Color", xmToggleButtonWidgetClass, 
			    x_visu_text_mode, NULL, 0);
  XtAddCallback(xb_visu_text_rgb, XmNvalueChangedCallback,
		(XtCallbackProc)cb_visual_text_change, 
		(XtPointer)VISUAL_RGB);
  switch (DviVisualText){
  default:
  case VISUAL_MONO:
    XmToggleButtonSetState(xb_visu_text_mono, TRUE,  TRUE);
    XmToggleButtonSetState(xb_visu_text_gray, FALSE, TRUE);
    XmToggleButtonSetState(xb_visu_text_rgb,  FALSE, TRUE);
    break;
  case VISUAL_GRAY:
    XmToggleButtonSetState(xb_visu_text_mono, FALSE, TRUE);
    XmToggleButtonSetState(xb_visu_text_gray, TRUE,  TRUE);
    XmToggleButtonSetState(xb_visu_text_rgb,  FALSE, TRUE);
    break;
  case VISUAL_RGB:
    XmToggleButtonSetState(xb_visu_text_mono, FALSE, TRUE);
    XmToggleButtonSetState(xb_visu_text_gray, FALSE, TRUE);
    XmToggleButtonSetState(xb_visu_text_rgb,  TRUE,  TRUE);
    break;
  }

  xsep2 = x_p_make_hsep(xfm);
  x_p_put_below(xsep2, x_visu_text_mode);

  i = 0;
  XtSetArg(args[i], XmNlabelString, 
	   XmStringCreate("EPS (Encapsulated PostScript) Mode",
			  XmSTRING_DEFAULT_CHARSET));  i++;
  XtSetArg(args[i], XmNleftAttachment, XmATTACH_FORM);  i++;
  XtSetArg(args[i], XmNtopAttachment, XmATTACH_WIDGET);  i++;
  XtSetArg(args[i], XmNtopWidget, xsep2);  i++;
  x_eps_label = XmCreateLabel(xfm, "label", args, i);
  XtManageChild(x_eps_label);

  i = 0;
  XtSetArg(args[i], XmNorientation, XmHORIZONTAL);  i++;
  XtSetArg(args[i], XmNpacking, XmPACK_COLUMN);  i++;
  XtSetArg(args[i], XmNtopAttachment, XmATTACH_WIDGET);  i++;
  XtSetArg(args[i], XmNtopWidget, x_eps_label);  i++;
  XtSetArg(args[i], XmNleftAttachment, XmATTACH_FORM);  i++;
  x_eps_mode = XmCreateRadioBox(xfm, "epsMode", args, i);
  XtManageChild(x_eps_mode);
  xb_eps_yes = XtCreateManagedWidget("Draw EPS Figures", 
				     xmToggleButtonWidgetClass,
				     x_eps_mode, NULL, 0);
  XtAddCallback(xb_eps_yes, XmNvalueChangedCallback,
		(XtCallbackProc)cb_eps_mode_change, (XtPointer)1);
  xb_eps_no  = XtCreateManagedWidget("Ignore EPS Figures", 
				     xmToggleButtonWidgetClass,
				     x_eps_mode, NULL, 0);
  XtAddCallback(xb_eps_no, XmNvalueChangedCallback,
		(XtCallbackProc)cb_eps_mode_change, (XtPointer)0);
  switch (DviEPSRendering){
  default:
  case 1:
    XmToggleButtonSetState(xb_eps_yes, TRUE,  TRUE);
    XmToggleButtonSetState(xb_eps_no,  FALSE, TRUE);
    break;
  case 0:
    XmToggleButtonSetState(xb_eps_yes, FALSE,  TRUE);
    XmToggleButtonSetState(xb_eps_no,  TRUE, TRUE);
    break;
  }

  xsep3 = x_p_make_hsep(xfm);
  x_p_put_below(xsep3, x_eps_mode);

  i = 0;
  XtSetArg(args[i], XmNlabelString, 
	   XmStringCreate("Visual Mode for EPS Figures",
			  XmSTRING_DEFAULT_CHARSET));  i++;
  XtSetArg(args[i], XmNleftAttachment, XmATTACH_FORM);  i++;
  XtSetArg(args[i], XmNtopAttachment, XmATTACH_WIDGET);  i++;
  XtSetArg(args[i], XmNtopWidget, xsep3);  i++;
  x_visu_eps_label = XmCreateLabel(xfm, "label", args, i);
  XtManageChild(x_visu_eps_label);

  i = 0;
  XtSetArg(args[i], XmNorientation, XmHORIZONTAL);  i++;
  XtSetArg(args[i], XmNpacking, XmPACK_COLUMN);  i++;
  XtSetArg(args[i], XmNtopAttachment, XmATTACH_WIDGET);  i++;
  XtSetArg(args[i], XmNtopWidget, x_visu_eps_label);  i++;
  XtSetArg(args[i], XmNleftAttachment, XmATTACH_FORM);  i++;
  /*XtSetArg(args[i], XmNrightAttachment, XmATTACH_FORM);  i++;*/
  x_visu_eps_mode = XmCreateRadioBox(xfm, "visualEPS", args, i);
  XtManageChild(x_visu_eps_mode);
  xb_visu_eps_mono
    = XtCreateManagedWidget("Monochrome", xmToggleButtonWidgetClass, 
			    x_visu_eps_mode, NULL, 0);
  XtAddCallback(xb_visu_eps_mono, XmNvalueChangedCallback,
		(XtCallbackProc)cb_visual_eps_change, 
		(XtPointer)VISUAL_MONO);
  xb_visu_eps_gray
    = XtCreateManagedWidget("Grayscale", xmToggleButtonWidgetClass, 
			    x_visu_eps_mode, NULL, 0);
  XtAddCallback(xb_visu_eps_gray, XmNvalueChangedCallback,
		(XtCallbackProc)cb_visual_eps_change, 
		(XtPointer)VISUAL_GRAY);
  xb_visu_eps_rgb
    = XtCreateManagedWidget("RGB Color", xmToggleButtonWidgetClass, 
			    x_visu_eps_mode, NULL, 0);
  XtAddCallback(xb_visu_eps_rgb, XmNvalueChangedCallback,
		(XtCallbackProc)cb_visual_eps_change, 
		(XtPointer)VISUAL_RGB);
  switch (DviVisualEPS){
  default:
  case VISUAL_MONO:
    XmToggleButtonSetState(xb_visu_eps_mono, TRUE,  TRUE);
    XmToggleButtonSetState(xb_visu_eps_gray, FALSE, TRUE);
    XmToggleButtonSetState(xb_visu_eps_rgb,  FALSE, TRUE);
    break;
  case VISUAL_GRAY:
    XmToggleButtonSetState(xb_visu_eps_mono, FALSE, TRUE);
    XmToggleButtonSetState(xb_visu_eps_gray, TRUE,  TRUE);
    XmToggleButtonSetState(xb_visu_eps_rgb,  FALSE, TRUE);
    break;
  case VISUAL_RGB:
    XmToggleButtonSetState(xb_visu_eps_mono, FALSE, TRUE);
    XmToggleButtonSetState(xb_visu_eps_gray, FALSE, TRUE);
    XmToggleButtonSetState(xb_visu_eps_rgb,  TRUE,  TRUE);
    break;
  }

  xsep4 = x_p_make_hsep(xfm);
  x_p_put_below(xsep4, x_visu_eps_mode);

  i = 0;
  XtSetArg(args[i], XmNlabelString, 
	   XmStringCreate("Style File for EPS Figures",
			  XmSTRING_DEFAULT_CHARSET));  i++;
  XtSetArg(args[i], XmNleftAttachment, XmATTACH_FORM);  i++;
  XtSetArg(args[i], XmNtopAttachment, XmATTACH_WIDGET);  i++;
  XtSetArg(args[i], XmNtopWidget, xsep4);  i++;
  x_epssty_label = XmCreateLabel(xfm, "label", args, i);
  XtManageChild(x_epssty_label);

  i = 0;
  XtSetArg(args[i], XmNorientation, XmHORIZONTAL);  i++;
  XtSetArg(args[i], XmNpacking, XmPACK_COLUMN);  i++;
  XtSetArg(args[i], XmNtopAttachment, XmATTACH_WIDGET);  i++;
  XtSetArg(args[i], XmNtopWidget, x_epssty_label);  i++;
  XtSetArg(args[i], XmNleftAttachment, XmATTACH_FORM);  i++;
  x_epssty_mode = XmCreateRadioBox(xfm, "epsStyleFile", args, i);
  XtManageChild(x_epssty_mode);
  xb_epssty_latex2e_graphics
    = XtCreateManagedWidget("LaTeX 2e graphics package",
			    xmToggleButtonWidgetClass, 
			    x_epssty_mode, NULL, 0);
  XtAddCallback(xb_epssty_latex2e_graphics, XmNvalueChangedCallback,
		(XtCallbackProc)cb_epssty_mode_change, 
		(XtPointer)EPS_STYLE_LATEX2E_GRAPHICS_STY);
  xb_epssty_latex209_epsf
    = XtCreateManagedWidget("LaTeX 2.09 epsf.sty", 
			    xmToggleButtonWidgetClass, 
			    x_epssty_mode, NULL, 0);
  XtAddCallback(xb_epssty_latex209_epsf, XmNvalueChangedCallback,
		(XtCallbackProc)cb_epssty_mode_change, 
		(XtPointer)EPS_STYLE_LATEX209_EPSF_STY);
  switch (RES(DviDev,eps_style)){
  default:
  case EPS_STYLE_LATEX2E_GRAPHICS_STY:
    XmToggleButtonSetState(xb_epssty_latex2e_graphics,  TRUE, TRUE);
    XmToggleButtonSetState(xb_epssty_latex209_epsf,     FALSE, TRUE);
    break;
  case EPS_STYLE_LATEX209_EPSF_STY:
    XmToggleButtonSetState(xb_epssty_latex2e_graphics,  FALSE, TRUE);
    XmToggleButtonSetState(xb_epssty_latex209_epsf,     TRUE,  TRUE);
    break;
  }

  return xpop;
}


Public void
cb_option(Widget w, caddr_t d1, caddr_t d2)
{
  if (XtIsManaged(dialog_opt)){
    XtUnmanageChild(dialog_opt);
  } else {
    ui_close_panel_all();
    XtManageChild(dialog_opt);
  }
}

Public void
cb_option_close(Widget w, caddr_t d1, caddr_t d2)
{
  if (XtIsManaged(dialog_opt))
    XtUnmanageChild(dialog_opt);
}



Private void  
cb_visual_text_change(Widget w, int mode, XmToggleButtonCallbackStruct *cbs)
{
  if (cbs->set){
    if (DviVisualText != mode){
      if (DviFile != NULL)
	x_ui_command = UI_CMD_REDRAW;
      x_cancel_page_cache(); 
      dvi_device_change_visual_text(DviDev, mode);
    }
  }
}

Private void  
cb_eps_mode_change(Widget w, int mode, XmToggleButtonCallbackStruct *cbs)
{
  PAGE_CACHE pc; 

  if (cbs->set){
    if (DviEPSRendering != mode){
      DviEPSRendering = mode;
      pc = x_get_cache(DviCurrentPage);
      if ((pc->page != -1) && (pc->n_eps_figs > 0)){
	if (DviFile != NULL)
	  x_ui_command = UI_CMD_REDRAW;
      }
      x_cancel_page_cache_by_eps_mode_change(); 
    }
  }
}

Private void  
cb_visual_eps_change(Widget w, int mode, XmToggleButtonCallbackStruct *cbs)
{
  if (cbs->set){
    if (DviVisualEPS != mode){
      if (DviFile != NULL)
	x_ui_command = UI_CMD_REDRAW;
      x_cancel_page_cache(); 
      dvi_device_change_visual_eps(DviDev, mode);
    }
  }
}

Private void  
cb_epssty_mode_change(Widget w, int mode, XmToggleButtonCallbackStruct *cbs)
{
  if (cbs->set){
    if ((DviProperty != NULL) && (mode != RES(DviDev,eps_style))){
      switch (mode){
      default:
      case EPS_STYLE_LATEX2E_GRAPHICS_STY:
	RES(DviDev,eps_style) = EPS_STYLE_LATEX2E_GRAPHICS_STY;
	DVI_PROPERTY_SET(DviProperty,   DVI_PROP_LATEX2E_GRAPHICS_STY);
	DVI_PROPERTY_UNSET(DviProperty, DVI_PROP_LATEX209_EPSF_STY);
	break;
      case EPS_STYLE_LATEX209_EPSF_STY:
	RES(DviDev,eps_style) = EPS_STYLE_LATEX209_EPSF_STY;
	DVI_PROPERTY_UNSET(DviProperty, DVI_PROP_LATEX2E_GRAPHICS_STY);
	DVI_PROPERTY_SET(DviProperty,   DVI_PROP_LATEX209_EPSF_STY);
	break;
      }
      if (DviFile != NULL){
	DVI_PROPERTY_UPDATE(DviFile,DviDev,DviProperty);
	x_ui_command = UI_CMD_REDRAW;
      }
      x_cancel_page_cache(); 
    }
  }
}


