package process

import (
	. "github.com/tendermint/go-common"
)

// Runs a command and gets the result.
func Run(command string, args []string) (string, bool, error) {
	outFile := NewBufferCloser(nil)
	proc, err := StartProcess("", command, args, nil, outFile)
	if err != nil {
		return "", false, err
	}

	<-proc.WaitCh

	if proc.ExitState.Success() {
		return string(outFile.Bytes()), true, nil
	} else {
		return string(outFile.Bytes()), false, nil
	}
}
