/***************************************************************************
 *  IConnectionPresence.cs
 *
 *  Copyright (C) 2006 INdT
 *  Written by 
 *	Andre Moreira Magalhaes <andre.magalhaes@indt.org.br>
 *	Kenneth Christiansen <kenneth.christiansen@gmail.com>
 *	Renato Araujo Oliveira Filho <renato.filho@indt.org>
 ****************************************************************************/

/*  THIS FILE IS LICENSED UNDER THE MIT LICENSE AS OUTLINED IMMEDIATELY BELOW:
 *
 *  Permission is hereby granted, free of charge, to any person obtaining a
 *  copy of this software and associated documentation files (the "Software"),
 *  to deal in the Software without restriction, including without limitation
 *  the rights to use, copy, modify, merge, publish, distribute, sublicense,
 *  and/or sell copies of the Software, and to permit persons to whom the
 *  Software is furnished to do so, subject to the following conditions:
 *
 *  The above copyright notice and this permission notice shall be included in
 *  all copies or substantial portions of the Software.
 *
 *  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 *  IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 *  FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 *  AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 *  LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 *  FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 *  DEALINGS IN THE SOFTWARE.
 */

using System;
using System.Collections.Generic;
using NDesk.DBus;
using org.freedesktop.DBus;

namespace org.freedesktop.Telepathy
{
	public delegate void PresenceUpdateHandler (IDictionary<uint, PresenceUpdateInfo> presence);

	public enum PresenceType : uint
	{
		Offline = 1,
		Available = 2,
		Away = 3,
		ExtendedAway = 4,
		Hidden = 5
	}

	public struct StatusInfo
	{
		public PresenceType PresenceType;
		public bool IsChanged;
		public bool IdExclusive;
		public IDictionary <string, object> Options;
	}

	public struct PresenceUpdateInfo
	{
		public uint TimeStamp;
		public IDictionary <string, IDictionary<string, object>> info;
	}

	[Interface ("org.freedesktop.Telepathy.Connection.Interface.Presence")]
	public interface IConnectionPresence
	{
		event PresenceUpdateHandler PresenceUpdate;

		void AddStatus (string status, IDictionary<string, object> parms);
		void ClearStatus ();
		IDictionary <string, StatusInfo> Statuses { get; }
		void RemoveStatus (string status);
		void RequestPresence (uint[] contacts);
		void SetLastActivityTime (uint time);
		void SetStatus (IDictionary<string, IDictionary<string, object>> statuses);
	}
}


