/***************************************************************************
 *  IChannelContactSearch.cs
 *
 *  Copyright (C) 2006 INdT
 *  Written by 
 *	Andre Moreira Magalhaes <andre.magalhaes@indt.org.br>
 *	Kenneth Christiansen <kenneth.christiansen@gmail.com>
 *	Renato Araujo Oliveira Filho <renato.filho@indt.org>
 ****************************************************************************/

/*  THIS FILE IS LICENSED UNDER THE MIT LICENSE AS OUTLINED IMMEDIATELY BELOW:
 *
 *  Permission is hereby granted, free of charge, to any person obtaining a
 *  copy of this software and associated documentation files (the "Software"),
 *  to deal in the Software without restriction, including without limitation
 *  the rights to use, copy, modify, merge, publish, distribute, sublicense,
 *  and/or sell copies of the Software, and to permit persons to whom the
 *  Software is furnished to do so, subject to the following conditions:
 *
 *  The above copyright notice and this permission notice shall be included in
 *  all copies or substantial portions of the Software.
 *
 *  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 *  IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 *  FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 *  AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 *  LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 *  FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 *  DEALINGS IN THE SOFTWARE.
 */

using System;
using System.Collections.Generic;
using NDesk.DBus;

namespace org.freedesktop.Telepathy
{
	public delegate void SearchResultReceivedHandler (uint contact, IDictionary<string, object> values);
	public delegate void SearchStateChangedHandler (SearchState state);

	public enum SearchState : uint
	{
		Before = 0,
		During = 1,
		After  = 2
	}

	public struct SearchInfo
	{
		public bool KeyIsMandatory;
		public string Signature;
	}

	public struct SearchKeys
	{
		public string Instructions;
		public IDictionary<string, SearchInfo> SearchInfo;
	}

	[Interface ("org.freedesktop.Telepathy.Channel.Type.ContactSearch")]
	public interface IChannelContactSearch : IChannel
	{
		event SearchResultReceivedHandler SearchResultReceived;
		event SearchStateChangedHandler SearchStateChanged;

		SearchKeys SearchKeys { get; }
		SearchState GetSearchState { get; }
		void Search (IDictionary<string, object> terms);
	}
}
