/*
 * Telepathy Inspector - A Telepathy client which exposes Telepathy interfaces.
 *                       Meant to inspect and/or test connection managers.
 *
 * ti-page-channel-group.h:
 * A GtkNotebook page exposing org.freedesktop.Telepathy.Channel.Interface.Group
 * functionality.
 *
 * Copyright (C) 2008 Collabora Ltd. <http://www.collabora.co.uk/>
 * Copyright (C) 2008 Nokia Corporation
 * Copyright (C) 2006 INdT - Instituto Nokia de Tecnologia
 * Originally by Daniel d'Andrada T. de Carvalho <daniel.carvalho@indt.org.br>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA
 */

#ifndef __TI_PAGE_CHANNEL_GROUP_H__
#define __TI_PAGE_CHANNEL_GROUP_H__

#include <gtk/gtk.h>
#include <glib-object.h>
#include <telepathy-glib/channel.h>

#include "page.h"
#include "handle-mapper.h"

/*
 * Type macros.
 */

typedef struct _TIPageChannelGroup TIPageChannelGroup;
typedef struct _TIPageChannelGroupClass TIPageChannelGroupClass;

#define TI_TYPE_PAGE_CHANNEL_GROUP               ti_page_channel_group_get_type()
#define TI_PAGE_CHANNEL_GROUP(object)            (G_TYPE_CHECK_INSTANCE_CAST ((object), TI_TYPE_PAGE_CHANNEL_GROUP, TIPageChannelGroup))
#define TI_PAGE_CHANNEL_GROUP_CLASS(klass)       (G_TYPE_CHECK_CLASS_CAST ((klass), TI_TYPE_PAGE_CHANNEL_GROUP, TIPageChannelGroupClass))
#define TI_IS_PAGE_CHANNEL_GROUP(object)         (G_TYPE_CHECK_INSTANCE_TYPE ((object), TI_TYPE_PAGE_CHANNEL_GROUP))
#define TI_IS_PAGE_CHANNEL_GROUP_CLASS(klass)    (G_TYPE_CHECK_CLASS_TYPE ((klass), TI_TYPE_PAGE_CHANNEL_GROUP))
#define TI_PAGE_CHANNEL_GROUP_GET_CLASS(object)  (G_TYPE_INSTANCE_GET_CLASS ((object), TI_TYPE_PAGE_CHANNEL_GROUP, TIPageChannelGroupClass))

struct _TIPageChannelGroup {
    TIPage parent;
};

GType ti_page_channel_group_get_type (void);

TIPageChannelGroup *ti_page_channel_group_new (GtkNotebook *parent_notebook,
    GtkWindow *parent_window, TpChannel *channel,
    TIHandleMapper *handle_mapper);

#endif
